/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.manager;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.model.ExasolConnection;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.ext.exasol.tools.ExasolUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class ExasolConnectionManager
extends SQLObjectEditor<ExasolConnection, ExasolDataSource>
implements DBEObjectRenamer<ExasolConnection> {
    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 1L;
    }

    public DBSObjectCache<ExasolDataSource, ExasolConnection> getObjectsCache(ExasolConnection object) {
        ExasolDataSource source = object.getDataSource();
        return source.getConnectionCache();
    }

    protected ExasolConnection createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        return new ExasolConnection((ExasolDataSource)((Object)container), null, null, null, null, null);
    }

    private SQLDatabasePersistAction getCommentCommand(ExasolConnection con) {
        return new SQLDatabasePersistAction("Comment on Connection", String.format("COMMENT ON CONNECTION %s is '%s'", DBUtils.getQuotedIdentifier((DBSObject)con), ExasolUtils.quoteString(con.getDescription())));
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        ExasolConnection con = (ExasolConnection)command.getObject();
        StringBuilder script = new StringBuilder(String.format("CREATE CONNECTION %s TO ", DBUtils.getQuotedIdentifier((DBSObject)con)));
        script.append(" '" + ExasolUtils.quoteString(con.getConnectionString()) + "' ");
        if (!(con.getUserName().isEmpty() | con.getPassword().isEmpty())) {
            script.append(String.format("USER '%s' IDENTIFIED BY '%s'", ExasolUtils.quoteString(con.getUserName()), ExasolUtils.quoteString(con.getPassword())));
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create Connection", script.toString()));
        if (!con.getDescription().isEmpty()) {
            actions.add((DBEPersistAction)this.getCommentCommand(con));
        }
    }

    protected void addObjectRenameActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectRenameCommand command, @NotNull Map<String, Object> options) {
        ExasolConnection obj = (ExasolConnection)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename Connection", "RENAME CONNECTION " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getOldName()) + " to " + DBUtils.getQuotedIdentifier((DBPDataSource)obj.getDataSource(), (String)command.getNewName())));
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
        ExasolConnection con = (ExasolConnection)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop Connection", "DROP CONNECTION " + DBUtils.getQuotedIdentifier((DBSObject)con)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        ExasolConnection con = (ExasolConnection)command.getObject();
        Map com = command.getProperties();
        if (com.containsKey("description")) {
            actionList.add((DBEPersistAction)this.getCommentCommand(con));
        }
        if (com.containsKey("url") | com.containsKey("userName") | com.containsKey("password")) {
            StringBuilder script = new StringBuilder(String.format("ALTER CONNECTION %s TO", DBUtils.getQuotedIdentifier((DBSObject)con)));
            script.append(" '" + ExasolUtils.quoteString(con.getConnectionString()) + "' ");
            if (!(con.getUserName().isEmpty() | con.getPassword().isEmpty())) {
                script.append(String.format(" USER '%s' IDENTIFIED BY '%s'", ExasolUtils.quoteString(con.getUserName()), ExasolUtils.quoteString(con.getPassword())));
            }
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("alter Connection", script.toString()));
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull ExasolConnection object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }
}

