/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.multiselection;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.internal.texteditor.multiselection.AbstractMultiSelectionHandler;

public class MultiCaretUpHandler
extends AbstractMultiSelectionHandler {
    @Override
    public void execute() throws ExecutionException {
        if (this.selectionIsBelowAnchorRegion()) {
            this.removeLastRegionFromSelection();
        } else {
            this.extendSelectionWithSamePositionInPreviousLine();
        }
    }

    private void extendSelectionWithSamePositionInPreviousLine() throws ExecutionException {
        IRegion[] regions = this.getSelectedRegions();
        if (regions == null || regions.length == 0) {
            return;
        }
        try {
            IRegion firstRegion = regions[0];
            int newOffset = this.offsetInPreviousLine(firstRegion.getOffset());
            IRegion previousLineRegion = this.createRegionIfValid(newOffset, firstRegion.getLength());
            this.selectRegions(this.addRegion(regions, previousLineRegion));
        }
        catch (BadLocationException e) {
            throw new ExecutionException("Internal error in extendSelectionWithSamePositionInPreviousLine", (Throwable)e);
        }
    }

    private void removeLastRegionFromSelection() {
        this.selectRegions(this.removeLastRegionButOne(this.getSelectedRegions()));
    }
}

