/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tasks.nativetool.AbstractImportExportSettings;
import org.jkiss.dbeaver.tasks.ui.DBTTaskConfigPanel;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractNativeToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;
import org.jkiss.utils.CommonUtils;

public abstract class NativeToolConfigPanel<OBJECT_TYPE extends DBSObject>
implements DBTTaskConfigPanel {
    private static final Log log = Log.getLog(NativeToolConfigPanel.class);
    private final DBRRunnableContext runnableContext;
    private final DBTTaskType taskType;
    private final Class<OBJECT_TYPE> objectClass;
    private final Class<? extends DBPDataSourceProvider> providerClass;
    private AbstractNativeToolWizard ieWizard;
    private ClientHomesSelector homesSelector;
    private OBJECT_TYPE selectedObject;
    private DBPDataSourceContainer curDataSource;
    private DatabaseObjectsSelectorPanel selectorPanel;

    public NativeToolConfigPanel(DBRRunnableContext runnableContext, DBTTaskType taskType, Class<OBJECT_TYPE> objectClass, Class<? extends DBPDataSourceProvider> providerClass) {
        this.runnableContext = runnableContext;
        this.taskType = taskType;
        this.objectClass = objectClass;
        this.providerClass = providerClass;
    }

    public void createControl(Composite parent, TaskConfigurationWizard wizard, final Runnable propertyChangeListener) {
        this.ieWizard = (AbstractNativeToolWizard)wizard;
        Composite databasesGroup = UIUtils.createTitledComposite((Composite)parent, (String)TaskNativeUIMessages.tools_wizard_database_group_title, (int)1, (int)1808);
        this.selectorPanel = new DatabaseObjectsSelectorPanel(this, databasesGroup, false, this.runnableContext){
            final /* synthetic */ NativeToolConfigPanel this$0;
            {
                this.this$0 = this$0;
                super(arg0, arg1, arg2);
            }

            protected boolean isDatabaseFolderVisible(DBNDatabaseFolder folder) {
                return folder.getChildrenClass() == this.this$0.objectClass;
            }

            protected boolean isDatabaseObjectVisible(DBSObject obj) {
                return this.this$0.objectClass.isInstance(obj);
            }

            protected void onSelectionChange(Object element) {
                this.this$0.selectedObject = element instanceof DBSWrapper && this.this$0.objectClass.isInstance(((DBSWrapper)element).getObject()) ? (DBSObject)this.this$0.objectClass.cast(((DBSWrapper)element).getObject()) : null;
                Object settings = this.this$0.ieWizard.getSettings();
                List databaseObjects = settings.getDatabaseObjects();
                databaseObjects.clear();
                if (this.this$0.selectedObject != null) {
                    databaseObjects.add(this.this$0.selectedObject);
                }
                if (settings instanceof AbstractImportExportSettings) {
                    ((AbstractImportExportSettings)settings).fillExportObjectsFromInput();
                }
                this.this$0.updateHomeSelector();
                propertyChangeListener.run();
            }

            protected boolean isFolderVisible(DBNLocalFolder folder) {
                for (DBNDataSource ds : folder.getNestedDataSources()) {
                    if (!this.isDataSourceVisible(ds)) continue;
                    return true;
                }
                return false;
            }

            protected boolean isDataSourceVisible(DBNDataSource dataSource) {
                try {
                    DBPDriver driver = dataSource.getDataSourceContainer().getDriver();
                    return this.this$0.providerClass.isInstance(driver.getDataSourceProvider()) && driver.getNativeClientManager() != null && driver.getNativeClientManager().supportsNativeClients();
                }
                catch (Exception e) {
                    log.debug((Object)e);
                    return false;
                }
            }
        };
        Composite clientGroup = UIUtils.createTitledComposite((Composite)parent, (String)TaskNativeUIMessages.tools_wizard_client_group_title, (int)1, (int)768);
        this.homesSelector = new ClientHomesSelector(clientGroup, TaskNativeUIMessages.tools_wizard_client_group_client);
        this.homesSelector.addSelectionChangedListener(event -> propertyChangeListener.run());
        this.homesSelector.getPanel().setLayoutData((Object)new GridData(768));
    }

    private void updateHomeSelector() {
        DBPDataSourceContainer newDataSource = null;
        if (this.selectedObject instanceof DBPDataSourceContainer) {
            newDataSource = (DBPDataSourceContainer)this.selectedObject;
        } else if (this.selectedObject != null) {
            newDataSource = this.selectedObject.getDataSource().getContainer();
        }
        if (newDataSource != null && this.curDataSource != newDataSource) {
            this.homesSelector.populateHomes(newDataSource.getDriver(), newDataSource.getConnectionConfiguration().getClientHomeId(), true);
        }
        this.curDataSource = newDataSource;
    }

    public void loadSettings() {
        List databaseObjects = this.ieWizard.getSettings().getDatabaseObjects();
        Iterator iterator = databaseObjects.iterator();
        block3: while (iterator.hasNext()) {
            DBSObject obj;
            for (DBSObject child = obj = (DBSObject)iterator.next(); child != null; child = child.getParentObject()) {
                if (!this.objectClass.isInstance(child)) continue;
                this.selectedObject = (DBSObject)this.objectClass.cast(child);
                continue block3;
            }
        }
        DBPDataSourceContainer container = this.ieWizard.getSettings().getDataSourceContainer();
        if (this.selectorPanel != null && (this.selectedObject != null || container != null)) {
            try {
                DBNDatabaseNode[] catalogNode = new DBNDatabaseNode[1];
                this.ieWizard.getRunnableContext().run(true, true, monitor -> {
                    catalogNode[0] = DBNUtils.getNodeByObject((DBRProgressMonitor)monitor, (DBSObject)(this.selectedObject != null ? this.selectedObject : container), (boolean)false);
                });
                if (catalogNode[0] != null) {
                    List<DBNDatabaseNode> selCatalogs = Collections.singletonList(catalogNode[0]);
                    this.selectorPanel.setSelection(selCatalogs);
                }
            }
            catch (InvocationTargetException e) {
                DBWorkbench.getPlatformUI().showError("Catalogs", " Error loading catalog list", e.getTargetException());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void saveSettings() {
        String selectedHome = this.homesSelector.getSelectedHome();
        this.curDataSource.getConnectionConfiguration().setClientHomeId(selectedHome);
        this.curDataSource.persistConfiguration();
    }

    public boolean isComplete() {
        return this.homesSelector.getSelectedHome() != null && this.selectedObject != null;
    }

    public String getErrorMessage() {
        if (this.selectedObject == null) {
            return TaskNativeUIMessages.tools_wizard_error_no_database_object_selected;
        }
        if (CommonUtils.isEmpty((String)this.homesSelector.getSelectedHome())) {
            return TaskNativeUIMessages.tools_wizard_error_no_native_client_selected;
        }
        return null;
    }
}

