/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.browser.handlers;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.BeanUtils;

public class BrowserClearCookiesHandler
implements DBRRunnableWithProgress {
    private static final String BROWSER_HELPER_CLASS_NAME = "org.eclipse.swt.browser.DBeaverBrowserHelper";
    private static final String BROWSER_HELPER_CLASS_CLEAR_COOKIES_NAME = "clearCookies";
    private static final Log log = Log.getLog(BrowserClearCookiesHandler.class);

    public void run(DBRProgressMonitor monitor) {
        UIUtils.syncExec(BrowserClearCookiesHandler::clearCookies);
    }

    private static void clearCookies() {
        Shell shell = new Shell(0);
        Browser browser = null;
        try {
            browser = new Browser((Composite)shell, 0);
            BeanUtils.invokeStaticMethod(Class.forName(BROWSER_HELPER_CLASS_NAME), (String)BROWSER_HELPER_CLASS_CLEAR_COOKIES_NAME, (Class[])new Class[]{Browser.class}, (Object[])new Object[]{browser});
        }
        catch (Throwable e) {
            log.error((Object)"Error clearing cookies", e);
        }
        finally {
            if (browser != null) {
                browser.dispose();
            }
            shell.dispose();
        }
    }
}

