/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.infonode.gui.ComponentPaintChecker;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.RotatableLabel;
import net.infonode.gui.hover.panel.HoverableShapedPanel;
import net.infonode.util.Alignment;
import net.infonode.util.Direction;

public class ContentTitleBar
extends HoverableShapedPanel {
    private final ComponentPaintChecker repaintChecker;
    private JComponent[] leftTitleComponents;
    private JComponent[] rightTitleComponents;
    private Insets[] leftTitleComponentsInsets;
    private Insets[] rightTitleComponentsInsets;
    private boolean flipTitleComponents = false;
    private GridBagConstraints constraints = new GridBagConstraints();
    private Insets labelInsets = InsetsUtil.EMPTY_INSETS;
    private Alignment labelAlignment = Alignment.LEFT;
    private final RotatableLabel label = new RotatableLabel(""){

        @Override
        public Dimension getMinimumSize() {
            Dimension d = super.getMinimumSize();
            if (this.getDirection().isHorizontal()) {
                return new Dimension(0, d.height);
            }
            return new Dimension(d.width, 0);
        }
    };

    public ContentTitleBar() {
        this((Component)null);
    }

    public ContentTitleBar(Component hoveredComponent) {
        super(new GridBagLayout(), null, hoveredComponent);
        this.repaintChecker = new ComponentPaintChecker(this);
        this.add(this.label);
        this.updateLayout();
    }

    public JLabel getLabel() {
        return this.label;
    }

    public String getText() {
        return this.label.getText();
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setIcon(Icon icon) {
        if (this.label.getIcon() != icon) {
            this.label.setIcon(icon);
            this.doUpdate();
        }
    }

    public Alignment getLabelAlignment() {
        return this.labelAlignment;
    }

    public void setLabelAlignment(Alignment labelAlignment) {
        if (this.labelAlignment != labelAlignment) {
            this.labelAlignment = labelAlignment;
            this.updateLabelAlignment();
        }
    }

    public void setLayoutDirection(Direction direction) {
        if (this.label.getDirection() != direction) {
            this.label.setDirection(direction);
            this.updateLayout();
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets labelInsets) {
        this.labelInsets = labelInsets;
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints(this.label);
        c.insets = InsetsUtil.rotate(this.getDirection(), labelInsets);
        ((GridBagLayout)this.getLayout()).setConstraints(this.label, c);
        this.doUpdate();
    }

    public boolean isFlipTitleComponents() {
        return this.flipTitleComponents;
    }

    public void setFlipTitleComponents(boolean flipTitleComponents) {
        if (this.flipTitleComponents != flipTitleComponents) {
            this.flipTitleComponents = flipTitleComponents;
            this.updateLayout();
        }
    }

    public JComponent[] getLeftTitleComponents() {
        return this.leftTitleComponents;
    }

    public void setLeftTitleComponents(JComponent[] leftTitleComponents) {
        this.setLeftTitleComponents(leftTitleComponents, leftTitleComponents == null ? null : this.createEmptyInsets(leftTitleComponents.length));
    }

    public void setLeftTitleComponents(JComponent[] leftTitleComponents, Insets[] leftTitleComponentsInsets) {
        JComponent[] oldComponents = this.leftTitleComponents;
        this.leftTitleComponents = leftTitleComponents;
        this.leftTitleComponentsInsets = leftTitleComponentsInsets;
        this.updateTitleComponents(oldComponents, leftTitleComponents);
    }

    public JComponent[] getRightTitleComponents() {
        return this.rightTitleComponents;
    }

    public void setRightTitleComponents(JComponent[] rightTitleComponents) {
        this.setRightTitleComponents(rightTitleComponents, rightTitleComponents == null ? null : this.createEmptyInsets(rightTitleComponents.length));
    }

    public void setRightTitleComponents(JComponent[] rightTitleComponents, Insets[] rightTitleComponentsInsets) {
        JComponent[] oldComponents = this.rightTitleComponents;
        this.rightTitleComponents = rightTitleComponents;
        this.rightTitleComponentsInsets = rightTitleComponentsInsets;
        this.updateTitleComponents(oldComponents, rightTitleComponents);
    }

    private Insets[] createEmptyInsets(int num) {
        Insets[] insets = new Insets[num];
        int i = 0;
        while (i < num) {
            insets[i] = InsetsUtil.EMPTY_INSETS;
            ++i;
        }
        return insets;
    }

    private void updateLabelAlignment() {
        this.label.setHorizontalAlignment(this.labelAlignment == Alignment.LEFT ? 2 : (this.labelAlignment == Alignment.RIGHT ? 4 : 0));
    }

    private void updateTitleComponents(JComponent[] oldComponents, JComponent[] newComponents) {
        int i;
        if (oldComponents != null) {
            i = 0;
            while (i < oldComponents.length) {
                this.remove(oldComponents[i]);
                ++i;
            }
        }
        if (newComponents != null) {
            i = 0;
            while (i < newComponents.length) {
                this.add(newComponents[i]);
                ++i;
            }
        }
        this.updateLayout();
    }

    private void updateLayout() {
        Insets[] rightInsets;
        Direction direction = this.label.getDirection();
        this.constraints = new GridBagConstraints();
        JComponent[] leftComponents = this.flipTitleComponents ? this.rightTitleComponents : this.leftTitleComponents;
        JComponent[] rightComponents = this.flipTitleComponents ? this.leftTitleComponents : this.rightTitleComponents;
        Insets[] leftInsets = this.flipTitleComponents ? this.rightTitleComponentsInsets : this.leftTitleComponentsInsets;
        Insets[] insetsArray = rightInsets = this.flipTitleComponents ? this.leftTitleComponentsInsets : this.rightTitleComponentsInsets;
        if (direction == Direction.LEFT || direction == Direction.UP) {
            JComponent[] tmpComponents = leftComponents;
            leftComponents = rightComponents;
            rightComponents = tmpComponents;
            Insets[] tmpInsets = leftInsets;
            leftInsets = rightInsets;
            rightInsets = tmpInsets;
        }
        if (direction.isHorizontal()) {
            int index;
            int x = 0;
            if (leftComponents != null) {
                int i = 0;
                while (i < leftComponents.length) {
                    index = direction == Direction.RIGHT ? i : leftComponents.length - i - 1;
                    this.setConstraints(leftComponents[index], leftInsets[index], x++, 0, 1, 1, 0, 0.0, 0.0, 10);
                    ++i;
                }
            }
            this.setConstraints(this.label, this.labelInsets, x++, 0, 1, 1, 1, 1.0, 1.0, 10);
            if (rightComponents != null) {
                int i = 0;
                while (i < rightComponents.length) {
                    index = direction == Direction.RIGHT ? i : rightComponents.length - i - 1;
                    this.setConstraints(rightComponents[index], rightInsets[index], x++, 0, 1, 1, 0, 0.0, 0.0, 10);
                    ++i;
                }
            }
        } else {
            int index;
            int y = 0;
            if (leftComponents != null) {
                int i = 0;
                while (i < leftComponents.length) {
                    index = direction == Direction.DOWN ? i : leftComponents.length - i - 1;
                    this.setConstraints(leftComponents[index], leftInsets[index], 0, y++, 1, 1, 0, 0.0, 0.0, 10);
                    ++i;
                }
            }
            this.setConstraints(this.label, this.labelInsets, 0, y++, 1, 1, 1, 1.0, 1.0, 10);
            if (rightComponents != null) {
                int i = 0;
                while (i < rightComponents.length) {
                    index = direction == Direction.DOWN ? i : rightComponents.length - i - 1;
                    this.setConstraints(rightComponents[index], rightInsets[index], 0, y++, 1, 1, 0, 0.0, 0.0, 10);
                    ++i;
                }
            }
        }
        this.doUpdate();
    }

    private void setConstraints(Component c, Insets insets, int gridx, int gridy, int gridWidth, int gridHeight, int fill, double weightx, double weighty, int anchor) {
        this.constraints.insets = InsetsUtil.rotate(this.getDirection(), insets);
        this.constraints.gridx = gridx;
        this.constraints.gridy = gridy;
        this.constraints.fill = fill;
        this.constraints.weightx = weightx;
        this.constraints.weighty = weighty;
        this.constraints.gridwidth = gridWidth;
        this.constraints.gridheight = gridHeight;
        this.constraints.anchor = anchor;
        ((GridBagLayout)this.getLayout()).setConstraints(c, this.constraints);
    }

    private void doUpdate() {
        this.revalidate();
        if (this.repaintChecker.isPaintingOk()) {
            this.repaint();
        }
    }
}

