/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaGenericArrayType;
import com.tngtech.archunit.core.domain.JavaParameterizedType;
import com.tngtech.archunit.core.domain.JavaTypeVariable;
import com.tngtech.archunit.core.domain.JavaWildcardType;
import com.tngtech.archunit.core.domain.properties.HasName;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.util.Set;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public interface JavaType
extends HasName {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass toErasure();

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    default public Set<JavaClass> getAllInvolvedRawTypes() {
        final ImmutableSet.Builder result = ImmutableSet.builder();
        this.traverseSignature(new SignatureVisitor(){

            @Override
            public SignatureVisitor.Result visitClass(JavaClass type) {
                result.add(type.getBaseComponentType());
                return SignatureVisitor.Result.CONTINUE;
            }

            @Override
            public SignatureVisitor.Result visitParameterizedType(JavaParameterizedType type) {
                result.add(type.toErasure());
                return SignatureVisitor.Result.CONTINUE;
            }
        });
        return result.build();
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void traverseSignature(SignatureVisitor var1);

    @PublicAPI(usage=PublicAPI.Usage.INHERITANCE)
    public static interface SignatureVisitor {
        default public Result visitClass(JavaClass type) {
            return Result.CONTINUE;
        }

        default public Result visitParameterizedType(JavaParameterizedType type) {
            return Result.CONTINUE;
        }

        default public Result visitTypeVariable(JavaTypeVariable<?> type) {
            return Result.CONTINUE;
        }

        default public Result visitGenericArrayType(JavaGenericArrayType type) {
            return Result.CONTINUE;
        }

        default public Result visitWildcardType(JavaWildcardType type) {
            return Result.CONTINUE;
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static enum Result {
            CONTINUE,
            STOP;

        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<JavaType, JavaClass> TO_ERASURE = new ChainableFunction<JavaType, JavaClass>(){

            @Override
            public JavaClass apply(JavaType input) {
                return input.toErasure();
            }
        };

        private Functions() {
        }
    }
}

