/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedIterable;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.properties.CanOverrideDescription;
import com.tngtech.archunit.lang.AllowEmptyShould;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.CanBeEvaluated;
import com.tngtech.archunit.lang.ClassesTransformer;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.EvaluationResult;
import com.tngtech.archunit.lang.FailureReport;
import com.tngtech.archunit.lang.Priority;
import com.tngtech.archunit.lang.extension.ArchUnitExtensions;
import com.tngtech.archunit.lang.extension.EvaluatedRule;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Optional;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public interface ArchRule
extends CanBeEvaluated,
CanOverrideDescription<ArchRule> {
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public void check(JavaClasses var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ArchRule because(String var1);

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public ArchRule allowEmptyShould(boolean var1);

    @Internal
    public static interface Transformation {
        public ArchRule apply(ArchRule var1);

        @Internal
        public static final class Because
        implements Transformation {
            private final String reason;

            public Because(String reason) {
                this.reason = reason;
            }

            @Override
            public ArchRule apply(ArchRule rule) {
                return rule.because(this.reason);
            }

            public String toString() {
                return String.format("because '%s'", this.reason);
            }
        }

        @Internal
        public static final class As
        implements Transformation {
            private final String description;

            public As(String description) {
                this.description = description;
            }

            @Override
            public ArchRule apply(ArchRule rule) {
                return (ArchRule)rule.as(this.description);
            }

            public String toString() {
                return String.format("as '%s'", this.description);
            }
        }
    }

    @Internal
    public static class Factory {
        public static <T> ArchRule create(ClassesTransformer<T> classesTransformer, ArchCondition<T> condition, Priority priority) {
            return new SimpleArchRule(priority, classesTransformer, condition, Optional.empty(), AllowEmptyShould.AS_CONFIGURED);
        }

        public static ArchRule withBecause(ArchRule rule, String reason) {
            return (ArchRule)rule.as(Factory.createBecauseDescription(rule, reason));
        }

        static String createBecauseDescription(ArchRule rule, String reason) {
            return rule.getDescription() + ", because " + reason;
        }

        private static class SimpleArchRule<T>
        implements ArchRule {
            private static final String FAIL_ON_EMPTY_SHOULD_PROPERTY_NAME = "archRule.failOnEmptyShould";
            private final Priority priority;
            private final ClassesTransformer<T> classesTransformer;
            private final ArchCondition<T> condition;
            private final Optional<String> overriddenDescription;
            private final AllowEmptyShould allowEmptyShould;

            private SimpleArchRule(Priority priority, ClassesTransformer<T> classesTransformer, ArchCondition<T> condition, Optional<String> overriddenDescription, AllowEmptyShould allowEmptyShould) {
                this.priority = priority;
                this.classesTransformer = classesTransformer;
                this.condition = condition;
                this.overriddenDescription = overriddenDescription;
                this.allowEmptyShould = allowEmptyShould;
            }

            @Override
            public ArchRule as(String newDescription) {
                return new SimpleArchRule<T>(this.priority, this.classesTransformer, this.condition, Optional.of(newDescription), this.allowEmptyShould);
            }

            @Override
            public void check(JavaClasses classes) {
                Assertions.check(this, classes);
            }

            @Override
            public ArchRule because(String reason) {
                return Factory.withBecause(this, reason);
            }

            @Override
            public ArchRule allowEmptyShould(boolean allowEmptyShould) {
                return new SimpleArchRule<T>(this.priority, this.classesTransformer, this.condition, this.overriddenDescription, AllowEmptyShould.fromBoolean(allowEmptyShould));
            }

            @Override
            public EvaluationResult evaluate(JavaClasses classes) {
                Collection<T> allObjects = this.toCollection(this.classesTransformer.transform(classes));
                this.verifyNoEmptyShouldIfEnabled(allObjects);
                this.condition.init(allObjects);
                ConditionEvents events = ConditionEvents.Factory.create();
                for (T object : allObjects) {
                    this.condition.check(object, events);
                }
                this.condition.finish(events);
                return new EvaluationResult(this, events, this.priority);
            }

            private Collection<T> toCollection(DescribedIterable<T> iterable) {
                return iterable instanceof Collection ? (ImmutableList<T>)((Object)iterable) : ImmutableList.copyOf(iterable);
            }

            private void verifyNoEmptyShouldIfEnabled(Iterable<T> allObjects) {
                if (Iterables.isEmpty(allObjects) && !this.allowEmptyShould.isAllowed()) {
                    throw new AssertionError((Object)String.format("Rule '%s' failed to check any classes. This means either that no classes have been passed to the rule at all, or that no classes passed to the rule matched the `that()` clause. To allow rules being evaluated without checking any classes you can either use `%s.allowEmptyShould(true)` on a single rule or set the configuration property `%s = false` to change the behavior globally.", this.getDescription(), ArchRule.class.getSimpleName(), FAIL_ON_EMPTY_SHOULD_PROPERTY_NAME));
                }
            }

            @Override
            public String getDescription() {
                return this.overriddenDescription.orElseGet(() -> this.classesTransformer.getDescription() + " should " + this.condition.getDescription());
            }

            public String toString() {
                return this.getDescription();
            }
        }
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Assertions {
        private static final ArchUnitExtensions extensions = new ArchUnitExtensions();

        private Assertions() {
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static void check(ArchRule rule, JavaClasses classes) {
            EvaluationResult result = rule.evaluate(classes);
            extensions.dispatch(new SimpleEvaluatedRule(rule, classes, result));
            Assertions.assertNoViolation(result);
        }

        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static void assertNoViolation(EvaluationResult result) {
            FailureReport report = result.getFailureReport();
            if (!report.isEmpty()) {
                throw new AssertionError((Object)report.toString());
            }
        }

        private static class SimpleEvaluatedRule
        implements EvaluatedRule {
            private final ArchRule rule;
            private final JavaClasses importedClasses;
            private final EvaluationResult evaluationResult;

            SimpleEvaluatedRule(ArchRule rule, JavaClasses importedClasses, EvaluationResult evaluationResult) {
                this.rule = rule;
                this.importedClasses = importedClasses;
                this.evaluationResult = evaluationResult;
            }

            @Override
            public ArchRule getRule() {
                return this.rule;
            }

            @Override
            public JavaClasses getClasses() {
                return this.importedClasses;
            }

            @Override
            public EvaluationResult getResult() {
                return this.evaluationResult;
            }
        }
    }
}

