/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.internal;

import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.infonode.gui.PopupList;
import net.infonode.gui.PopupListListener;
import net.infonode.gui.TextIconListCellRenderer;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabListener;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabbedPanel;

public class TabDropDownList
extends PopupList {
    private TabbedPanel tabbedPanel;
    private TextIconListCellRenderer cellRenderer;
    private TabListener tabListener = new TabAdapter(){

        @Override
        public void tabAdded(TabEvent event) {
            if (event.getTab().getTabbedPanel().getTabCount() == 2) {
                TabDropDownList.this.setVisible(true);
            }
        }

        @Override
        public void tabRemoved(TabRemovedEvent event) {
            if (event.getTabbedPanel().getTabCount() == 1) {
                TabDropDownList.this.setVisible(false);
            }
        }
    };

    public TabDropDownList(final TabbedPanel tabbedPanel, AbstractButton button) {
        super(button);
        this.tabbedPanel = tabbedPanel;
        this.addPopupListListener(new PopupListListener(){

            @Override
            public void willBecomeVisible(PopupList l) {
                int numTabs = tabbedPanel.getTabCount();
                Object[] tabs = new Tab[numTabs];
                int i = 0;
                while (i < numTabs) {
                    tabs[i] = tabbedPanel.getTabAt(i);
                    ++i;
                }
                TabDropDownList.this.cellRenderer.calculateMaximumIconWidth(tabs);
                TabDropDownList.this.getList().setListData(tabs);
                TabDropDownList.this.getList().setSelectedValue(tabbedPanel.getSelectedTab(), true);
            }
        });
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    tabbedPanel.setSelectedTab((Tab)TabDropDownList.this.getList().getSelectedValue());
                }
            }
        });
        if (tabbedPanel.getProperties().getTabDropDownListVisiblePolicy() == TabDropDownListVisiblePolicy.MORE_THAN_ONE_TAB) {
            tabbedPanel.addTabListener(this.tabListener);
            this.setVisible(tabbedPanel.getTabCount() > 1);
        }
        this.cellRenderer = new TextIconListCellRenderer(this.getList().getCellRenderer());
        this.getList().setCellRenderer(this.cellRenderer);
        this.setOpaque(false);
    }

    public void dispose() {
        this.tabbedPanel.removeTabListener(this.tabListener);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.cellRenderer != null) {
            ListCellRenderer renderer = (ListCellRenderer)UIManager.get("List.cellRenderer");
            if (renderer == null) {
                renderer = new DefaultListCellRenderer();
            }
            this.cellRenderer.setRenderer(renderer);
        }
    }
}

