/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc;

import io.sf.carte.doc.DOMTokenList;
import io.sf.carte.doc.EmptyIterator;
import io.sf.carte.doc.SingleItemIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.DOMException;

public class DOMTokenSetImpl
implements DOMTokenList,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean multiple = false;
    Object value = "";

    @Override
    public String getValue() {
        if (this.multiple) {
            LinkedList set = (LinkedList)this.value;
            StringBuilder buf = new StringBuilder(32 + 8 * set.size());
            Iterator it = set.iterator();
            buf.append((String)it.next());
            while (it.hasNext()) {
                buf.append(' ').append((String)it.next());
            }
            return buf.toString();
        }
        return (String)this.value;
    }

    @Override
    public String getSortedValue() {
        if (this.multiple) {
            TreeSet set = new TreeSet((LinkedList)this.value);
            StringBuilder buf = new StringBuilder(32 + 8 * set.size());
            Iterator it = set.iterator();
            buf.append((String)it.next());
            while (it.hasNext()) {
                buf.append(' ').append((String)it.next());
            }
            return buf.toString();
        }
        return (String)this.value;
    }

    public void setValue(String value) throws DOMException {
        if (!DOMTokenSetImpl.checkMultipleToken(value)) {
            this.multiple = false;
            this.value = value.trim();
        } else {
            LinkedList<String> set;
            if (this.multiple) {
                set = (LinkedList<String>)this.value;
                set.clear();
            } else {
                this.multiple = true;
                this.value = set = new LinkedList<String>();
            }
            StringTokenizer st = new StringTokenizer(value);
            while (st.hasMoreTokens()) {
                set.add(st.nextToken());
            }
        }
    }

    public static boolean checkMultipleToken(String value) {
        boolean foundChar = false;
        boolean foundWS = false;
        if (value == null) {
            throw new DOMException(12, "Null value");
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (foundChar && (c == ' ' || c == '\n' || c == '\t' || c == '\r' || c == '\f')) {
                foundWS = true;
                continue;
            }
            if (foundWS) {
                return true;
            }
            foundChar = true;
        }
        return false;
    }

    @Override
    public int getLength() {
        if (this.multiple) {
            return ((LinkedList)this.value).size();
        }
        return ((String)this.value).length() == 0 ? 0 : 1;
    }

    @Override
    public String item(int index) {
        if (this.multiple) {
            LinkedList set = (LinkedList)this.value;
            if (index < 0 || index >= set.size()) {
                return null;
            }
            return (String)set.get(index);
        }
        if (index != 0 || ((String)this.value).length() == 0) {
            return null;
        }
        return (String)this.value;
    }

    @Override
    public Iterator<String> iterator() {
        if (this.multiple) {
            LinkedList linkedList = (LinkedList)this.value;
            return linkedList.iterator();
        }
        return ((String)this.value).length() == 0 ? new EmptyIterator() : new SingleItemIterator((String)this.value);
    }

    @Override
    public boolean contains(String token) {
        if (this.multiple) {
            return ((LinkedList)this.value).contains(token);
        }
        return this.value.equals(token);
    }

    @Override
    public boolean containsAll(DOMTokenList otherlist) {
        if (otherlist == null) {
            throw new DOMException(12, "Argument is null.");
        }
        int otherlen = otherlist.getLength();
        if (otherlen == 0) {
            return true;
        }
        if (this.multiple) {
            if (otherlen == 1) {
                return ((LinkedList)this.value).contains(otherlist.item(0));
            }
            for (String element : otherlist) {
                if (this.contains(element)) continue;
                return false;
            }
            return true;
        }
        return otherlen == 1 && this.value.equals(otherlist.item(0));
    }

    @Override
    public boolean containsAll(Collection<String> tokenSet) {
        if (this.multiple) {
            return ((LinkedList)this.value).containsAll(tokenSet);
        }
        int sz = tokenSet.size();
        return sz == 0 || sz == 1 && this.value.equals(tokenSet.iterator().next());
    }

    @Override
    public void add(String token) throws DOMException {
        this.argumentCheckVoidSpaces(token);
        this.addUnchecked(token);
    }

    protected void addUnchecked(String token) throws DOMException {
        if (this.multiple) {
            LinkedList set = (LinkedList)this.value;
            if (!set.contains(token)) {
                set.add(token);
            }
        } else {
            String strValue = (String)this.value;
            if (strValue.length() != 0) {
                if (!strValue.equals(token)) {
                    LinkedList<String> set = new LinkedList<String>();
                    set.add(strValue);
                    set.add(token);
                    this.value = set;
                    this.multiple = true;
                }
            } else {
                this.value = token;
            }
        }
    }

    @Override
    public void remove(String token) throws DOMException {
        this.argumentCheckVoidSpaces(token);
        this.removeUnchecked(token);
    }

    protected void removeUnchecked(String token) throws DOMException {
        if (this.multiple) {
            LinkedList set = (LinkedList)this.value;
            set.remove(token);
            if (set.size() == 1) {
                this.value = set.getFirst();
                this.multiple = false;
            }
        } else if (this.value.equals(token)) {
            this.value = "";
        }
    }

    @Override
    public boolean toggle(String token) throws DOMException {
        this.argumentCheckVoidSpaces(token);
        return this.toggleUnchecked(token);
    }

    protected boolean toggleUnchecked(String token) throws DOMException {
        if (this.multiple) {
            LinkedList set = (LinkedList)this.value;
            if (!set.remove(token)) {
                set.add(token);
                return true;
            }
            if (set.size() == 1) {
                this.value = set.getFirst();
                this.multiple = false;
                set.clear();
            }
        } else if (this.value.equals(token)) {
            this.value = "";
        } else {
            if (((String)this.value).length() == 0) {
                this.value = token;
                return true;
            }
            LinkedList<String> set = new LinkedList<String>();
            set.add((String)this.value);
            set.add(token);
            this.value = set;
            this.multiple = true;
            return true;
        }
        return false;
    }

    @Override
    public void replace(String oldToken, String newToken) throws DOMException {
        this.argumentCheckVoidSpaces(oldToken);
        this.argumentCheckVoidSpaces(newToken);
        this.replaceUnchecked(oldToken, newToken);
    }

    protected void replaceUnchecked(String oldToken, String newToken) throws DOMException {
        if (this.multiple) {
            LinkedList set = (LinkedList)this.value;
            int idx = set.indexOf(oldToken);
            if (idx != -1) {
                if (!set.contains(newToken)) {
                    set.set(idx, newToken);
                } else {
                    set.remove(idx);
                }
            }
        } else if (this.value.equals(oldToken)) {
            this.value = newToken;
        }
    }

    public void clear() {
        if (this.multiple) {
            ((LinkedList)this.value).clear();
            this.multiple = false;
        }
        this.value = "";
    }

    protected void argumentCheckVoidSpaces(String token) throws DOMException {
        if (token == null || token.length() == 0) {
            throw new DOMException(12, "Token cannot be empty");
        }
        if (token.indexOf(32) != -1) {
            throw new DOMException(5, "Token cannot contain spaces");
        }
    }

    public String toString() {
        return this.getValue();
    }
}

