/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bsfv;

import ghidra.bsfv.BSimFeatureType;
import ghidra.bsfv.BsfvFeatureColumnObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.SequenceNumber;
import ghidra.program.model.pcode.Varnode;

public class BsfvRowObject {
    private BsfvFeatureColumnObject feature;
    private SequenceNumber seq;
    private PcodeOpAST definingPcodeOp;
    private PcodeOpAST previousPcodeOp;
    private BSimFeatureType type;
    private Varnode baseVarnode;
    private Address basicBlockStart;
    private Integer blockIndex;

    public BsfvRowObject(int feature, SequenceNumber seq, Varnode baseVarnode, PcodeOpAST definingPcodeOp, PcodeOpAST previousPcodeOp, BSimFeatureType type, Address basicBlockStart, Integer blockIndex) {
        this.feature = new BsfvFeatureColumnObject(feature);
        this.seq = seq;
        this.type = type;
        this.baseVarnode = baseVarnode;
        this.basicBlockStart = basicBlockStart;
        this.definingPcodeOp = definingPcodeOp;
        this.previousPcodeOp = previousPcodeOp;
        this.blockIndex = blockIndex;
    }

    public SequenceNumber getSeq() {
        return this.seq;
    }

    public PcodeOpAST getPcodeOpAST() {
        return this.definingPcodeOp;
    }

    public PcodeOpAST getPreviousPcodeOpAST() {
        return this.previousPcodeOp;
    }

    public String getOpMnemonic() {
        if (this.definingPcodeOp != null) {
            return this.definingPcodeOp.getMnemonic();
        }
        return null;
    }

    public BSimFeatureType getBSimFeatureType() {
        return this.type;
    }

    public Varnode getBaseVarnode() {
        return this.baseVarnode;
    }

    public Address getBasicBlockStart() {
        return this.basicBlockStart;
    }

    public Address getAddress() {
        return this.seq.getTarget();
    }

    public BsfvFeatureColumnObject getFeature() {
        return this.feature;
    }

    public Integer getBlockIndex() {
        return this.blockIndex;
    }
}

