/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.annotproc;

import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annotproc.AbstractDBAnnotationValidator;
import ghidra.util.database.annotproc.ValidationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class DBAnnotatedFieldValidator
extends AbstractDBAnnotationValidator {
    final VariableElement field;
    final Map<TypeMirror, TypeElement> javaToDBTypeMap;
    static final String FACTORY_NAME = "ghidra.util.database.DBCachedObjectStoreFactory";
    static final String BOOLEAN_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.BooleanDBFieldCodec";
    static final String BYTE_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.ByteDBFieldCodec";
    static final String SHORT_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.ShortDBFieldCodec";
    static final String INT_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.IntDBFieldCodec";
    static final String LONG_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.LongDBFieldCodec";
    static final String STRING_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.StringDBFieldCodec";
    static final String BYTE_ARRAY_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.ByteArrayDBFieldCodec";
    static final String LONG_ARRAY_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.LongArrayDBFieldCodec";
    static final String ENUM_CODEC_NAME = "ghidra.util.database.DBCachedObjectStoreFactory.EnumDBByteFieldCodec";
    final TypeElement ENUM_CODEC_ELEM;

    public DBAnnotatedFieldValidator(ValidationContext ctx, VariableElement field) {
        super(ctx);
        this.field = field;
        LinkedHashMap<TypeMirror, TypeElement> typeMap = new LinkedHashMap<TypeMirror, TypeElement>();
        this.putPrimitiveTypeCodec(typeMap, TypeKind.BOOLEAN, BOOLEAN_CODEC_NAME);
        this.putPrimitiveTypeCodec(typeMap, TypeKind.BYTE, BYTE_CODEC_NAME);
        this.putPrimitiveTypeCodec(typeMap, TypeKind.SHORT, SHORT_CODEC_NAME);
        this.putPrimitiveTypeCodec(typeMap, TypeKind.INT, INT_CODEC_NAME);
        this.putPrimitiveTypeCodec(typeMap, TypeKind.LONG, LONG_CODEC_NAME);
        this.putTypeCodec(typeMap, String.class, STRING_CODEC_NAME);
        this.putPrimitiveArrayTypeCodec(typeMap, TypeKind.BYTE, BYTE_ARRAY_CODEC_NAME);
        this.putPrimitiveArrayTypeCodec(typeMap, TypeKind.LONG, LONG_ARRAY_CODEC_NAME);
        this.javaToDBTypeMap = Map.copyOf(typeMap);
        this.ENUM_CODEC_ELEM = ctx.elementUtils.getTypeElement(ENUM_CODEC_NAME);
    }

    protected void putPrimitiveTypeCodec(Map<TypeMirror, TypeElement> map, TypeKind kind, String codecName) {
        PrimitiveType primitive = this.ctx.typeUtils.getPrimitiveType(kind);
        TypeMirror boxed = this.ctx.typeUtils.boxedClass(primitive).asType();
        TypeElement codec = this.ctx.elementUtils.getTypeElement(codecName);
        map.put(primitive, codec);
        map.put(boxed, codec);
    }

    protected void putTypeCodec(Map<TypeMirror, TypeElement> map, Class<?> cls, String codecName) {
        TypeMirror type = this.ctx.elementUtils.getTypeElement(cls.getCanonicalName()).asType();
        TypeElement codec = this.ctx.elementUtils.getTypeElement(codecName);
        map.put(type, codec);
    }

    protected void putPrimitiveArrayTypeCodec(Map<TypeMirror, TypeElement> map, TypeKind kind, String codecName) {
        PrimitiveType primitive = this.ctx.typeUtils.getPrimitiveType(kind);
        ArrayType array = this.ctx.typeUtils.getArrayType(primitive);
        TypeElement codec = this.ctx.elementUtils.getTypeElement(codecName);
        map.put(array, codec);
    }

    public void validate() {
        Set<Modifier> mods = this.field.getModifiers();
        if (mods.contains((Object)Modifier.FINAL)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s cannot be applied to a final field", DBAnnotatedField.class.getSimpleName()), this.field);
        }
        if (mods.contains((Object)Modifier.STATIC)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("@%s cannot be applied to a static field", DBAnnotatedField.class.getSimpleName()), this.field);
        }
        TypeElement type = (TypeElement)this.field.getEnclosingElement();
        this.checkEnclosingType(DBAnnotatedField.class, this.field, type);
        this.checkCodecTypes(type);
    }

    protected TypeElement getDefaultCodecType(TypeMirror javaType) {
        if (this.ctx.isEnumType(javaType)) {
            return this.ENUM_CODEC_ELEM;
        }
        return this.javaToDBTypeMap.get(javaType);
    }

    protected TypeElement getCodecTypeElement() {
        TypeElement codecElem;
        DBAnnotatedField annotation = this.field.getAnnotation(DBAnnotatedField.class);
        try {
            codecElem = this.ctx.elementUtils.getTypeElement(annotation.codec().getCanonicalName());
        }
        catch (MirroredTypeException e) {
            codecElem = (TypeElement)((DeclaredType)e.getTypeMirror()).asElement();
        }
        if (codecElem == this.ctx.DEFAULT_CODEC_ELEM) {
            return this.getDefaultCodecType(this.field.asType());
        }
        return codecElem;
    }

    protected void checkCodecTypes(TypeElement objectType) {
        TypeMirror argFT;
        TypeElement codecType = this.getCodecTypeElement();
        if (codecType == null) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Could not select default codec for %s. @%s.codec must be specified.", this.field.asType(), DBAnnotatedField.class.getSimpleName()), this.field);
            return;
        }
        Map<String, TypeMirror> args = this.ctx.getArguments(codecType, this.ctx.DB_FIELD_CODEC_ELEM);
        TypeMirror argVT = args.get("VT");
        if (!this.ctx.hasType(this.field, argVT)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Codec %s can only be used with fields of type %s", codecType, argVT), this.field);
        }
        TypeMirror argOT = args.get("OT");
        if (!this.ctx.isCapturable(objectType.asType(), argOT)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Codec %s requires the containing object to conform to %s", codecType, this.ctx.format(argOT)), this.field);
        }
        if ((argFT = args.get("FT")).getKind() != TypeKind.DECLARED) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Codec %s must have a non-abstract class for its field type, not %s", codecType, argFT), codecType);
        } else if (((DeclaredType)argFT).asElement().getModifiers().contains((Object)Modifier.ABSTRACT)) {
            this.ctx.messager.printMessage(Diagnostic.Kind.ERROR, String.format("Codec %s must have a non-abstract class for its field type, not %s", codecType, argFT), codecType);
        }
    }
}

