/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.renderers;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.Renderer;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GradientVertexRenderer<V, E>
implements Renderer.Vertex<V, E> {
    private static final Logger log = LoggerFactory.getLogger(GradientVertexRenderer.class);
    Color colorOne;
    Color colorTwo;
    Color pickedColorOne;
    Color pickedColorTwo;
    MutableSelectedState<V> mutablePickedState;
    boolean cyclic;

    public GradientVertexRenderer(Color colorOne, Color colorTwo, boolean cyclic) {
        this.colorOne = colorOne;
        this.colorTwo = colorTwo;
        this.cyclic = cyclic;
    }

    public GradientVertexRenderer(MutableSelectedState<V> mutableSelectedState, Color colorOne, Color colorTwo, Color pickedColorOne, Color pickedColorTwo, boolean cyclic) {
        this.mutablePickedState = mutableSelectedState;
        this.colorOne = colorOne;
        this.colorTwo = colorTwo;
        this.pickedColorOne = pickedColorOne;
        this.pickedColorTwo = pickedColorTwo;
        this.cyclic = cyclic;
    }

    @Override
    public void paintVertex(RenderContext<V, E> renderContext, LayoutModel<V> layoutModel, V v) {
        if (renderContext.getVertexIncludePredicate().test(v)) {
            Shape shape = renderContext.getVertexShapeFunction().apply(v);
            Point p = (Point)layoutModel.apply(v);
            Point2D p2d = renderContext.getMultiLayerTransformer().transform(MultiLayerTransformer.Layer.LAYOUT, p.x, p.y);
            float x = (float)p2d.getX();
            float y = (float)p2d.getY();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            shape = xform.createTransformedShape(shape);
            log.trace("prepared a shape for " + v + " to go at " + p);
            this.paintShapeForVertex(renderContext, v, shape);
        }
    }

    protected void paintShapeForVertex(RenderContext<V, E> renderContext, V v, Shape shape) {
        GraphicsDecorator g = renderContext.getGraphicsContext();
        Paint oldPaint = g.getPaint();
        Rectangle r = shape.getBounds();
        float y2 = (float)r.getMaxY();
        if (this.cyclic) {
            y2 = (float)(r.getMinY() + r.getHeight() / 2.0);
        }
        GradientPaint fillPaint = this.mutablePickedState != null && this.mutablePickedState.isSelected(v) ? new GradientPaint((float)r.getMinX(), (float)r.getMinY(), this.pickedColorOne, (float)r.getMinX(), y2, this.pickedColorTwo, this.cyclic) : new GradientPaint((float)r.getMinX(), (float)r.getMinY(), this.colorOne, (float)r.getMinX(), y2, this.colorTwo, this.cyclic);
        g.setPaint(fillPaint);
        g.fill(shape);
        g.setPaint(oldPaint);
        Paint drawPaint = renderContext.getVertexDrawPaintFunction().apply(v);
        if (drawPaint != null) {
            g.setPaint(drawPaint);
        }
        Stroke oldStroke = g.getStroke();
        Stroke stroke = renderContext.getVertexStrokeFunction().apply(v);
        if (stroke != null) {
            g.setStroke(stroke);
        }
        g.draw(shape);
        g.setPaint(oldPaint);
        g.setStroke(oldStroke);
    }
}

