/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.plugin.core.graph.AddressBasedGraphDisplayListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.service.graph.AttributedVertex;
import ghidra.service.graph.GraphDisplay;
import ghidra.service.graph.GraphDisplayListener;
import java.util.Collections;
import java.util.Set;

class PCodeDfgDisplayListener
extends AddressBasedGraphDisplayListener {
    HighFunction highfunc;

    public PCodeDfgDisplayListener(PluginTool tool, GraphDisplay display, HighFunction high, Program program) {
        super(tool, program, display);
        this.highfunc = high;
    }

    protected Set<AttributedVertex> getVertices(AddressSetView selection) {
        return Collections.emptySet();
    }

    protected AddressSet getAddresses(Set<AttributedVertex> vertices) {
        AddressSet set = new AddressSet();
        for (AttributedVertex vertex : vertices) {
            Address address = this.getAddress(vertex);
            if (address == null) continue;
            set.add(address);
        }
        return set;
    }

    protected Address getAddress(AttributedVertex vertex) {
        if (vertex == null) {
            return null;
        }
        String vertexId = vertex.getId();
        int firstColon = vertexId.indexOf(58);
        if (firstColon == -1) {
            return null;
        }
        int firstSpace = vertexId.indexOf(32);
        String addrString = vertexId.substring(0, firstSpace);
        return this.getAddress(addrString);
    }

    public GraphDisplayListener cloneWith(GraphDisplay display) {
        return new PCodeDfgDisplayListener(this.tool, display, this.highfunc, this.program);
    }
}

