/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractSignedIntegerDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.DecompilerLanguage;

public class SignedByteDataType
extends AbstractSignedIntegerDataType {
    public static final SignedByteDataType dataType = new SignedByteDataType();

    public SignedByteDataType() {
        this(null);
    }

    public SignedByteDataType(DataTypeManager dtm) {
        super("sbyte", dtm);
    }

    @Override
    public String getDescription() {
        return "Signed Byte (sdb)";
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "sdb";
    }

    @Override
    public String getDecompilerDisplayName(DecompilerLanguage language) {
        if (language == DecompilerLanguage.JAVA_LANGUAGE) {
            return "byte";
        }
        return this.name;
    }

    @Override
    public ByteDataType getOppositeSignednessDataType() {
        return ByteDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public SignedByteDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new SignedByteDataType(dtm);
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.getCTypeDeclaration(this, true, dataOrganization, false);
    }
}

