# frozen_string_literal: true

class CreateSbomVulnerabilityScans < Gitlab::Database::Migration[2.3]
  milestone '18.4'

  def change
    create_table :sbom_vulnerability_scans do |t| # rubocop:disable Migration/EnsureFactoryForTable -- false positive
      t.timestamps_with_timezone null: false
      t.bigint :project_id, null: false, index: true
      t.bigint :build_id, null: false, index: true
      t.integer :status, default: 0, limit: 2
      t.integer :sbom_file_store, default: 1, limit: 2
      t.integer :result_file_store, default: 1, limit: 2
      t.text :sbom_file, limit: 255
      t.text :sbom_file_final_path, limit: 1024
      t.text :result_file, limit: 255
      t.text :error_message, limit: 1024
    end

    add_index :sbom_vulnerability_scans, :created_at
  end
end
