---
stage: Plan
group: Product Planning
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: ロードマップ
description: エピックの進捗、タイムライン、マイルストーン、目標
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

開始日または期限日を含むグループ内のエピックは、タイムライン形式で視覚化できます。

GitLabのロードマップは、タイムラインビュー（つまり、ガントチャート）で、計画された作業の概要と、エピックとマイルストーンの進捗状況を大まかに示します。ロードマップを使用して、プロジェクトの戦略的な方向性と依存関係を視覚化および伝達します。

エピックのロードマップには、次の利点があります:

- 共有ビジョンと目標を中心にチームを調整できます。
- 長期的な計画とリソース配分を支援できます。
- 潜在的なブロッカー、依存関係、リスクを早期に特定できます。
- プロジェクトのタイムラインとマイルストーンについて、関係者に明確な理解を提供できます。
- プロジェクトの進捗状況を追跡および更新するのに役立ちます。

## ロードマップを表示する {#view-the-roadmap}

グループでロードマップを表示するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **Plan** > **ロードマップ**を選択します。

ロードマップには、グループ、そのサブグループの1つ、またはグループの1つのプロジェクトにおけるエピックとマイルストーンが表示されます。

エピックバーでは、各エピックのタイトル、進捗状況、および完了したウェイトの割合を確認できます。エピックバーにカーソルを合わせると、エピックのタイトル、開始日、期限、および完了したウェイトを含むポップオーバーが表示されます。

子エピックが含まれたエピックを展開すると、ロードマップに子エピックを表示できます。エピックタイトルの横にあるシェブロン（{{< icon name="chevron-down" >}}）を選択して、子エピックを展開する、および折りたたむことができます。

マイルストーンバーの上部には、それらのタイトルが表示されます。マイルストーンバーまたはタイトルにポインタを合わせると、タイトル、開始日、および期限を含むポップオーバーが表示されます。**マイルストーン**の見出しの横にあるシェブロン（{{< icon name="chevron-down" >}}）を選択して、マイルストーンバーのリストを切り替えることもできます。

![エピックとマイルストーンを含むロードマップの表示](img/roadmap_view_v14_3.png)

エピックから、[このエピックの子孫に絞り込まれたロードマップを表示](../epics/_index.md#roadmap-in-epics)することもできます。

## ロードマップの並べ替えとフィルタリング {#sort-and-filter-the-roadmap}

{{< history >}}

- グループによるフィルタリングは、GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385191)されました。
- タイトル、作成日、および最終更新日による並べ替えは、GitLab 17.0で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/460492)されました。

{{< /history >}}

{{< alert type="note" >}}

マイルストーンによるロードマップのフィルタリングは、利用できない場合があります。詳細については、このセクションの履歴を確認してください。

{{< /alert >}}

ロードマップを探すときは、エピックを並べ替えたり、自分にとって重要なものでフィルタリングしたりするといったいくつかの方法で、簡単に探すことができます。

ロードマップビューでは、エピックを次の順序で並べ替えることができます:

- 開始日
- 期限
- タイトル
- 作成日
- 最終更新日

各オプションには、並べ替え順序を**ascending**（昇順）と**descending**（降順）で切り替えるボタンがあります。並べ替えオプションと順序は、[エピックリストビュー](../epics/_index.md)を含む、エピックの参照時に保持されます。

ロードマップビューでは、エピックの次の項目でフィルタリングすることもできます:

- 作成者
- ラベル
- マイルストーン
- [機密性](../epics/manage_epics.md#make-an-epic-confidential)
- エピック
- 自分のリアクション
- グループ

![週単位のロードマップの日付範囲](img/roadmap_filters_v13_11.png)

エピックから、[このエピックの子孫に絞り込まれたロードマップを表示](../epics/_index.md#roadmap-in-epics)することもできます。

### ロードマップのパフォーマンスを改善する {#improve-the-performance-of-the-roadmap}

グループに多数のエピックが含まれている場合は、フィルターを使用すると、ロードマップの読み込みにかかる時間を短縮できます。ロードマップをフィルタリングすると、ロードマップに含まれるデータ量が減ります。ロードマップ内のデータを減らすと、探している情報を見つけやすくなる場合もあります。

特に、ラベルでフィルタリングすると、パフォーマンスが大幅に向上する可能性があります。

適用するフィルターを設定したら、URLをブラウザにブックマークとして保存できます。今後は、ブックマークを使用して、フィルタリングされたロードマップをすばやく読み込むことができます。

### ロードマップの設定 {#roadmap-settings}

{{< history >}}

- ロードマップに表示されるラベルは、GitLab 15.9で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/385231)されました。

{{< /history >}}

ロードマップ設定サイドバーを有効にすると、それを使用してロードマップに表示されるエピックを絞り込むことができます。

次の設定が可能です:

- 日付範囲を選択します。
- マイルストーンのオンとオフを切り替え、すべて、グループ、サブグループ、またはプロジェクトのマイルストーンを表示するかどうかを選択します。
- すべてのエピック、未解決エピック、または完了エピックを表示します。
- 子イシューの進捗状況の追跡をオンまたはオフにし、イシューのウェイトまたはカウントを使用して進捗状況を計算するかどうかを選択します。
- ラベルのオン/オフを切り替えます。

ロードマップの設定はユーザー設定には保存されませんが、URLパラメータを使用して保存または共有されます。

## タイムラインの期間 {#timeline-duration}

{{< history >}}

- 12.9でGitLab UltimateからGitLab Premiumに[移動](https://gitlab.com/gitlab-org/gitlab/-/issues/198062)しました。

{{< /history >}}

### 日付範囲プリセット {#date-range-presets}

ロードマップには、日付範囲のオプションがあり、それぞれに所定のタイムライン期間があります:

- **今四半期**: 現在の四半期に存在する週が含まれます。
- **今年**: 現在の年に存在する週または月が含まれます。
- **3年以内**: 過去18か月と今後18か月（合計3年間）の両方に存在する週、月、または四半期が含まれます。

### レイアウトプリセット {#layout-presets}

選択した[日付範囲プリセット](#date-range-presets)に応じて、ロードマップは次のレイアウトプリセットをサポートします:

- **Quarters**（四半期）: **3年以内**の日付範囲を選択した場合のみ使用できます。
- **月**: **今年**または**3年以内**の日付範囲を選択した場合に使用できます。
- **週**: すべての日付範囲プリセットで使用できます。

### 四半期 {#quarters}

![四半期単位のロードマップ日付範囲](img/roadmap_timeline_quarters_v11_10.png)

**Quarters**（四半期）プリセットでは、ロードマップは、現在選択されている日付範囲プリセット**falling within**（内にある）開始日または期限を持つエピックとマイルストーンを表示します。ここで、**今日**はタイムラインの垂直の赤い線で示されます。タイムラインヘッダーの四半期名の下にあるサブヘッダーは、四半期の月を表します。

### 月 {#months}

![月単位のロードマップ日付範囲](img/roadmap_timeline_months_v11_10.png)

**月**プリセットでは、ロードマップは、現在選択されている日付範囲プリセット**falling within**（内にある）またはその日付範囲を**going through**（またがる）開始日または期限を持つエピックとマイルストーンを表示します。ここで、**今日**はタイムラインの垂直の赤い線で示されます。タイムラインヘッダーの月名の下にあるサブヘッダーは、週の開始日（日曜日）の日付を表します。デフォルトではこのプリセットが選択されています。

### 週 {#weeks}

![週単位のロードマップの日付範囲](img/roadmap_timeline_weeks_v11_11.png)

**週**プリセットでは、ロードマップは、現在選択されている日付範囲プリセット**falling within**（内にある）またはその日付範囲を**going through**（またがる）開始日または期限を持つエピックとマイルストーンを表示します。ここで、**今日**はタイムラインの垂直の赤い線で示されます。タイムラインヘッダーの週名の下にあるサブヘッダーは、曜日を表します。

## ロードマップタイムラインバー {#roadmap-timeline-bar}

タイムラインバーは、エピックまたはマイルストーンの開始日と期限に基づいて、おおよその位置を示します。

## ブロックされたエピック {#blocked-epics}

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

{{< history >}}

- GitLab 15.5で[導入](https://gitlab.com/gitlab-org/gitlab/-/issues/33587)されました: 「ブロック」アイコンにカーソルを合わせると、ブロックしているエピックが表示されます。

{{< /history >}}

エピックが[別のエピックによってブロックされている](../epics/linked_epics.md#blocking-epics)場合、そのステータスを示すアイコンがタイトルの横に表示されます。

ブロックされたアイコン（{{< icon name="entity-blocked" >}}）の上にカーソルを合わせると、詳細な情報のポップオーバーが表示されます。

![ブロックされたエピック](img/roadmap_blocked_icon_v15_5.png)
