---
stage: Fulfillment
group: Subscription Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: ニーズに合った適切なGitLabサブスクリプションをお選びください。
title: GitLabプラン
---

適切なGitLabサブスクリプションを選択するには、提供形態とティアを選択します。

## 提供形態を選択する {#choose-an-offering}

ニーズに合ったGitLabの提供形態を選択してください:

- GitLab.com: サービスとしてのソフトウェアのGitLabの提供形態です。GitLab.comを使用するためにインストールする必要はありません。[サインアップ](https://gitlab.com/users/sign_up)して、すぐにGitLabの使用を開始するだけです。このサブスクリプションは、トップレベルグループのネームスペースに適用されます。個人のネームスペースにサブスクリプションを適用することはできません。
- [GitLab Dedicated](gitlab_dedicated/_index.md): 高度に規制された大規模企業向けのシングルテナントSaaSサービスです。
- GitLab Self-Managed: ご自身のGitLabインスタンスをインストール、管理、および保守します。このサブスクリプションは、すべてのユーザーに対して同じ機能セットを提供します。

{{< alert type="note" >}}

サブスクリプションは、GitLab.comと自己管理型GitLabの間で譲渡することはできません。別のGitLab提供形態に切り替えたい場合は、新しいサブスクリプションを購入して適用する必要があります。

{{< /alert >}}

## サブスクリプションティアを選択する {#choose-a-subscription-tier}

価格は[ティア制](https://about.gitlab.com/pricing/)で、予算に合った機能を選択できます。

詳細については、[各ティアで利用できる機能の比較](https://about.gitlab.com/pricing/feature-comparison/)を参照してください。

## サブスクリプションアドオンを選択する {#choose-a-subscription-add-on}

アドオンとは、既存のGitLabサブスクリプションに加えて購入できる追加の有料機能またはサービスです。アドオンは、GitLabエクスペリエンスを向上させるための追加機能またはリソースを提供します。

次のアドオンを購入できます:

- [GitLab Duo](subscription-add-ons.md): コード提案、GitLab DuoチャットなどのAIネイティブ機能にアクセスできます。
- [エンタープライズアジャイルプランニング](manage_subscription.md#enterprise-agile-planning): 単一のプラットフォーム上で、技術チームと非技術チーム間のコラボレーションを強化します。エンジニアリング以外のチームメンバーは、計画に参加したり、バリューストリーム分析で影響を測定したり、ソフトウェア開発の開発速度を可視化したりできます。
- [ストレージ](../user/storage_usage_quotas.md#purchase-more-storage): 無料の10 GiBストレージクオータを超えた場合は、ストレージを追加購入してください。
- [コンピューティング時間](gitlab_com/compute_minutes.md): プランが割り当てられた量を超え、自動ビルド、テスト、デプロイを中断することなく継続して実行する必要がある場合は、コンピューティング時間を追加購入してください。

一部のアドオンは、特定のサブスクリプションティアおよび提供形態でのみ利用可能です。

## サポートへのお問い合わせ {#contact-support}

- [GitLabサポート](https://about.gitlab.com/support/)のティアをご覧ください。
- [リクエストを送信](https://support.gitlab.com/hc/en-us/requests/new)するには、サポートポータルをご利用ください。

既知のイシューや既存の機能リクエストについては、[GitLabプロジェクト](https://gitlab.com/gitlab-org/gitlab/-/issues/)のプロジェクトトラッカーで検索してください。

これらのイシューは、特定の製品計画に関する最新情報を入手したり、関連するGitLabチームメンバーと直接やり取りしたりするための最適な手段です。
