---
stage: none
group: Tutorials
info: For assistance with this tutorial, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments-to-other-projects-and-subjects.
title: 'チュートリアル: 組織をセットアップする'
description: セットアップ、設定、オンボーディング、組織構造。
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab Self-Managed

{{< /details >}}

<!-- vale gitlab_base.FutureTense = NO -->

GitLabで、会社のGitLab組織をセットアップおよび管理するには、次の手順を実行します:

- グループ、サブグループ、プロジェクトを作成する。
- これらのグループとプロジェクトで、グループメンバーに異なるロールを割り当てる。

このチュートリアルでは、あなたの役割は小規模ソフトウェア会社のIT管理者です。この会社はGitLabを使用しており、マーケティング部門、営業部門、開発部門があります。

マーケティング組織と営業組織はすでにセットアップ済みです。このチュートリアルでは、ソフトウェア開発組織をセットアップします。この組織には、次の正社員がいます:

- 1人のIT管理者: あなた。
- 1人の製品マネージャー: Alex Smith。
- 1人のエンジニアリングマネージャー: Blake Wang。
- 3人のソフトウェア開発者: Charlie Devi、Devon Ivanov、Evan Kim。
- 1人のユーザーエクスペリエンスデザイナー: Frankie Ali。
- 1人のテクニカルライター: Grayson Garcia。

この組織には、請負業者のコンテンツストラテジストであるHunter Silvaもいます。

ここでは、次の項目を作成します:

1. ソフトウェア開発組織。
1. 作業を管理するためのグループ、サブグループ、プロジェクト。
1. グループとプロジェクトに追加し、ロールを割り当てるためのユーザー。
1. 特定の作業用の組織内のプロジェクト、およびそのプロジェクトへのユーザーの追加。

## はじめる前 {#before-you-begin}

- GitLab Self-Managedへの管理者アクセス権があることを確認してください。

## 組織の親グループとサブグループを作成する {#create-the-organization-parent-group-and-subgroups}

最初に、ソフトウェア開発組織全体の親グループとして機能するグループDevelopmentを作成します。

1. GitLab Self-Managedを開きます。
1. 左側のサイドバーの上部で、**新規作成**（{{< icon name="plus" >}}）を選択し、**新規グループ**を選択します。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このボタンは右上隅にあります。
1. **グループを作成**を選択します。
1. **グループ名**に`Development`と入力します。
1. **グループURL**でグループに対して`development-group`を入力します。「グループパスは使用可能です」というメッセージが表示されます。グループURLは、ネームスペースに使用されます。
1. 表示レベルでは、グループを**プライベート**にします。つまり、このグループのすべてのサブグループも非公開にする必要があります。
1. 次の質問に答えて、GitLabのエクスペリエンスをパーソナライズします:
   - **ロール**で、**Development Team Lead**（開発チームリード）を選択します。このロールは、メンバーの権限に影響を与えるロールとは異なります。
   - **だれがこのグループを使用しますか？**で、**自分の会社やチーム**を選択します。
   - **このグループを何に使う予定ですか？**で、**コードを保存したい**を選択します。
1. ここでは、まだGitLabのメンバーや他のユーザーをグループに招待しないでください。
1. **グループを作成**を選択します。

GitLabでは、ネームスペースは関連するプロジェクトを整理する場所として使用できます。

組織の親グループを作成できました。次に、サブグループを作成します。

## 組織のサブグループを作成する {#create-the-organization-subgroups}

このチュートリアルでは、Developmentは次の作業領域で構成されることを前提としています:

- 製品管理。
- エンジニアリング。
- ユーザーエクスペリエンス。
  - ユーザーエクスペリエンスデザイン。
  - テクニカルライティング。

ここでは、この組織構造を反映したサブグループを作成します。

サブグループとプロジェクトには、親グループの表示レベル設定と同等の表示レベル制限を設定しておく必要があります。たとえば、親グループが非公開の場合、サブグループを公開にすることはできません。

1. 左側のサイドバーで、**検索または移動先**を選択します。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **すべてのグループを表示**を選択します。
1. **開発**を選択します。あなたはオーナーロールを持っているため、グループ名の横に**オーナー**ラベルが表示されます。
1. 親グループの概要ページの右上隅で、**新しいサブグループ**を選択します。
1. **サブグループ名**に`Product Management`と入力します。
1. **サブグループスラグ**には、**product-management**が自動的に入力されます。このフィールドは変更しないでください。
1. **表示レベル**では、親グループDevelopmentが非公開であるため、**プライベート**のみを選択できます。
1. **サブグループを作成**を選択します。
1. 次のサブグループに対して手順を繰り返します:
   - `Engineering`。
   - `User Experience`。
     - `UX Design`。
     - `Technical Writing`。

UX DesignとTechnical Writingは、User Experienceサブグループにネストされたサブグループです。

これで、組織のサブグループを作成できました。次に、組織のユーザーを作成します。

## 組織のユーザーを作成する {#create-the-users-for-your-organization}

組織のユーザーを手動で作成します。これらのユーザーはテストユーザーです。最初のテストユーザーであるAlex Smithを作成するには、次の手順に従います:

1. 左側のサイドバーの下部で、**管理者**を選択します。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合は、右上隅で自分のアバターを選択し、**管理者**を選択します。
1. **概要** > **ユーザー**を選択します。
1. **新規ユーザー**を選択します。
1. 必要なフィールドに入力します:
   - **名前**: `Alex Smith`
   - **ユーザー名**: `alexsmith`
   - **メール**: `alexsmith@example.com`
   - 他のすべてのフィールドはそのままにします。
1. **ユーザーの作成**を選択します。

実際のユーザーの場合、リセットリンクがユーザーのメールアドレスに送信されます。そのユーザーは最初のサインイン時にパスワードを設定するように求められます。ただし、このユーザーは架空のメールアドレスを使用したテストユーザーであるため、確認メールを使用せずにユーザーのパスワードを設定する必要があります。

### テストユーザーのパスワードを設定する {#set-the-test-users-password}

1. ユーザーを選択します。
1. **編集**を選択します。
1. パスワードフィールドとパスワードの確認フィールドに入力します。
1. **変更を保存**を選択します。

最初のテストユーザーを作成できました。他のユーザーに対してこの手順を繰り返します:

| 名前             | ユーザー名        | メール |
|------------------|-----------------|-------|
| `Blake Wang`     | `blakewang`     | `blakewang@example.com` |
| `Charlie Devi`   | `charliedevi`   | `charliedevi@example.com` |
| `Devon Ivanov`   | `devonivanov`   | `devonivanov@example.com` |
| `Evan Kim`       | `evankim`       | `evankim@example.com` |
| `Frankie Ali`    | `frankieali`    | `frankieali@example.com` |
| `Grayson Garcia` | `graysongarcia` | `graysongarcia@example.com` |
| `Hunter Silva`   | `huntersilva`   | `huntersilva@example.com` |

組織のユーザーを作成できました。次に、これらのユーザーを異なるグループとサブグループに追加します。

## ユーザーをグループとサブグループに追加する {#add-users-to-the-group-and-subgroups}

ユーザーをグループに追加することで、グループ内のすべてのプロジェクトへのアクセス権をユーザーに付与できます。

最初に、すべてのユーザーを親グループDevelopmentに追加します。

1. 左側のサイドバーで、**検索または移動先**を選択して、**開発**グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **管理** > **メンバー**を選択します。
1. **メンバーを招待**を選択します。
1. 製品マネージャーのAlex Smithについて、フィールドに入力します。
   - Alexに**オーナー**ロールを付与します。ロールは、グループ内のすべてのサブグループプロジェクトに適用されます。
   - **アクセス有効期限**を空白のままにします。
1. **招待**を選択します。
1. 次のユーザーに対してこのプロセスを繰り返します:

   | ユーザー           | ロール       | アクセス有効期限 |
   |----------------|------------|------------------------|
   | Blake Wang     | メンテナー | 空白のまま            |
   | Charlie Devi   | デベロッパー  | 空白のまま            |
   | Devon Ivanov   | デベロッパー  | 空白のまま            |
   | Evan Kim       | デベロッパー  | 空白のまま            |
   | Frankie Ali    | レポーター   | 空白のまま            |
   | Grayson Garcia | レポーター   | 空白のまま            |
   | Hunter Silva   | ゲスト      | `2025-12-31`           |

   複数のユーザーが同じロールとアクセス有効期を持っている場合は、その複数のユーザーを同時に招待できます。

### すべてが正しく設定されていることを確認する {#confirm-that-everything-is-set-up-correctly}

Developmentグループとすべてのサブグループの**Group Members**（グループのメンバー）ページで、これらのグループのメンバーシップを確認します。

- **ソース**は、このグループのユーザーのメンバーシップの起源です。追加したメンバーは、グループに直接追加したため、直接メンバーになります。
- **最上位のロール**は、追加したメンバーがこのグループで許可される最上位のアクセスレベルです。この列のドロップダウンリストを使用して、このグループに追加したメンバーのロールを変更できます。

親グループのメンバーとして追加したすべてのユーザーは、すべてのサブグループのメンバーにもなり、同じロールを持ちます。

#### メンバーシップの種類でサブグループをフィルタリングする {#filter-a-subgroup-on-membership-type}

サブグループをフィルタリングして、そのサブグループの直接メンバーであるユーザーと、親グループからそのサブグループのメンバーシップを継承したメンバーを表示できます。

1. 左側のサイドバーで、**検索または移動先**を選択して、**開発**グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **User Experience**サブグループを選択します。
1. 左側のサイドバーで、**サブグループ情報** > **メンバー**を選択します。
1. **メンバー**ページで、**メンバーをフィルターする**フィールドを選択します。
1. **メンバーシップ**を選択してから、**継承**を選択し、<kbd>Return</kbd>を押します。

これで、User Experienceサブグループのメンバーシップを継承したUser Experienceサブグループのメンバーのみが表示されます。

各ユーザーは、組織内のロールと関連付けられているサブグループのメンバーのみになる必要があります。あなたは、ユーザーをグループとサブグループから削除することにしました。

## ユーザーをグループとサブグループから削除する {#remove-users-from-the-groups-and-subgroups}

サブグループからメンバーを直接削除することはできません。親グループからのみメンバーを削除できます。

親グループに戻り、Alex Smithを除くすべてのユーザーを削除します:

1. 左側のサイドバーで、**検索または移動先**を選択して、親グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **管理** > **メンバー**を選択します。
1. 削除するメンバーの行で、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択してから、**メンバーを削除**を選択します。
1. **メンバーを削除**確認ボックスで、**サブグループやプロジェクトからも直接ユーザーのメンバーシップを削除する**チェックボックスをオンにします。
1. **メンバーを削除**を選択します。

これで、親グループとサブグループのメンバーは1人のみになりました。そのメンバーにはオーナーロールが割り当てられています。

次に、ユーザーをサブグループに直接追加します。

## ユーザーをサブグループに追加する {#add-users-to-the-subgroups}

ここでは、ユーザーを異なるサブグループに直接追加します。

### ユーザーをProduct Managementサブグループに追加する {#add-users-to-the-product-management-subgroup}

1. 左側のサイドバーで、**検索または移動先**を選択して、**開発**グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Product Management**サブグループを選択します。
1. 左側のサイドバーで、**サブグループ情報** > **メンバー**を選択します。

あなたを除いて、Alexはこのサブグループの唯一のメンバーであり、直接メンバーです。これは正しい設定です。ただし、あなたは、オーナーロールではなく、メンテナーロールを割り当てる必要があると考えています。

#### サブグループでユーザーロールを変更する {#change-user-role-in-the-subgroup}

メンバーページでロールを直接変更することはできません。サブグループでロールを変更するには、メンテナーとしてサブグループに招待します。

1. **メンバーを招待**を選択します。
1. 製品マネージャーのAlex Smithについて、フィールドに入力します。
   - Alexに**メンテナー**ロールを付与します。
   - **アクセス有効期限**を空白のままにします。
1. **招待**を選択します。

次のメッセージが表示されます:

```plaintext
The following member couldn't be invited
Review the invite errors and try again:
- Alex Smith: Access level should be greater than or equal to Owner inherited membership from group Development
```

{{< alert type="note" >}}

Alexは親グループから継承したメンバーシップを持っているため、サブグループの親グループでのロールよりもアクセスレベルが低いサブグループロールをAlexに付与することはできません。

{{< /alert >}}

組織でのロールを考慮して、Alexはこのサブグループのオーナーのままにすることにしました。**キャンセル**を選択して、この招待をキャンセルします。

Product Managementサブグループには、正しいメンバーとロールがあります。次に、ユーザーをEngineeringサブグループに追加します。

### ユーザーをEngineeringサブグループに追加する {#add-users-to-the-engineering-subgroup}

ここでは、一部のユーザーをEngineeringサブグループに招待します。

1. 左側のサイドバーで、**検索または移動先**を選択して、**開発**グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **Engineering**サブグループを選択します。
1. 左側のサイドバーで、**サブグループ情報** > **メンバー**を選択します。メンバーはあなたとAlexのみで、両方ともオーナーロールを持っています。これらは継承されたロールです。
1. **メンバーを招待**を選択します。
1. 次のメンバーについて、フィールドに入力します:

   | ユーザー         | ロール       | アクセス有効期限 |
   |--------------|------------|------------------------|
   | Blake Wang   | メンテナー | 空白のまま            |
   | Charlie Devi | デベロッパー  | 空白のまま            |
   | Devon Ivanov | デベロッパー  | 空白のまま            |
   | Evan Kim     | デベロッパー  | 空白のまま            |

1. **招待**を選択します。

   Blake Wangは、このサブグループでメンテナーロールを持っており、これは、エンジニアリングマネージャーとしての責任に合致しています。3人のデベロッパーは全員デベロッパーロールを持っています。これらは直接ロールです。

1. このサブグループのメンバーページでロールを直接変更できます。Blake Wangをこのサブグループのオーナーに変更します。
1. Developmentグループのメンバーページに戻ります。Engineeringサブグループのメンバーは、親グループのメンバーではないことがわかります。

メンバーにする必要があるグループとサブグループにユーザーを直接追加することで、ユーザーが必要のないグループのメンバーになる問題を回避できます。さまざまなグループやプロジェクトへのアクセスを、より正確な方法で制御できます。

## ユーザーをUser Experienceサブグループに追加する {#add-users-to-the-user-experience-subgroup}

User Experienceサブグループには、さらにネストされた2つのサブグループがあります:

- ユーザーエクスペリエンスデザイン。
- テクニカルライティング。

ユーザーに関しては、UX DesignにはFrankie AliとHunter Silvaのみを追加し、Technical WritingにはGrayson Garciaのみを追加する必要があります。

3人全員をUser Experienceサブグループに追加すると、権限の継承により、ネストされた両方のサブグループにも全員が追加されることになります。

したがって、これらのユーザーは、User Experienceサブグループに追加するのではなく、適切なネストされたサブグループに直接追加します。

1. 左側のサイドバーで、**検索または移動先**を選択して、**開発**グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **User Experience**サブグループを選択してから、**UX Design**サブグループを選択します。
1. 左側のサイドバーで、**サブグループ情報** > **メンバー**を選択します。現在、あなたとAlex Smithのみがメンバーです。これらは継承されたロールです。
1. **メンバーを招待**を選択します。
1. 次のメンバーについて、フィールドに入力し、**招待**を選択します:

   | ユーザー         | ロール       | アクセス有効期限 |
   |--------------|------------|------------------------|
   | Frankie Ali  | メンテナー | 空白のまま            |
   | Hunter Silva | ゲスト      | `2025-12-31`           |

1. **Technical Writing**サブグループに対してこの手順を繰り返します:

   | ユーザー           | ロール       | アクセス有効期限 |
   |----------------|------------|------------------------|
   | Grayson Garcia | メンテナー | 空白のまま            |

ユーザーを適切なネストされたサブグループに追加できました。Grayson Garciaを**User Experience**サブグループにも追加することにします。

### ユーザーを他のサブグループに追加する {#add-users-to-other-subgroups}

Graysonを特定のロールとして**User Experience**サブグループに追加するとともに、**Technical Writing**サブグループでのロールを同じままにすることができます。

1. **User Experience**サブグループに移動します。
1. 左側のサイドバーで、**サブグループ情報** > **メンバー**を選択します。現在、あなたとAlex Smithのみがメンバーです。これらは継承されたロールです。
1. **メンバーを招待**を選択します。
1. Grayson Garciaをデベロッパーとして招待します。これは、**Technical Writing**サブグループでのメンテナーロールよりも権限レベルが低いロールです。

つまり、Grayson Garciaは、User Experienceサブグループで必要以上に高い権限レベルを持つことはありません。

ただし、権限の継承により、Grayson GarciaをUser Experienceサブグループに追加すると、ネストされたUX Designサブグループにもデベロッパーとして追加されます。

{{< alert type="note" >}}

グループとサブグループについては、権限の継承に注意してください。メンバーになる必要のないグループにユーザーを誤って追加する可能性を最小限に抑えるために、ユーザーを最小限の数のグループとサブグループに追加してください。

{{< /alert >}}

1. User Experienceサブグループのメンバーページに移動します。
1. Frankie AliとHunter Silvaを**Reporters**（レポーター）として追加します。Hunterに同じ有効期限を設定します。
1. ネストされたTechnical Writingサブグループに移動します。

Frankie AliとHunter Silvaは、権限の継承により、Technical Writingサブグループのメンバーになりました。

グループ、サブグループ、メンバーを設定し、組織を正常にセットアップできました。

次に、メンバーが取り組むプロジェクトをグループの1つに作成します。

## プロジェクトを作成する {#create-a-project}

ここでは、組織の特定のメンバーが取り組む必要のある作業があり、その作業は組織全体を対象にしているとします。その作業を整理するために、Development親グループにプロジェクトを作成し、そのプロジェクトにさまざまなユーザーを追加します。

1. 左側のサイドバーで、**検索または移動先**を選択して、**開発**グループを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. **新規作成**（{{< icon name="plus" >}}）を選択し、**新規プロジェクト/リポジトリ**を選択します。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このボタンは右上隅にあります。
1. **空のプロジェクトの作成**を選択します。
1. プロジェクトの詳細を入力します:
   - **プロジェクト名**フィールドに、プロジェクトの名前として`Release 2.0`と入力します。
   - **プロジェクトslug**フィールドはそのままにします。プロジェクト名に基づいて自動的に入力されます。
   - ユーザーのプロジェクトの表示権限とアクセス権を変更するには、**表示レベル**を変更します。親グループが非公開であれば、プロジェクトも**プライベート**のみにすることができます。
   - Gitリポジトリを初期化して、デフォルトブランチを用意し、クローンできるようにするために`README`ファイルを作成するには、**リポジトリを初期化しREADMEファイルを生成する**チェックボックスをオンにします。
   - 既知のセキュリティの脆弱性についてプロジェクトのソースコードを分析するには、**静的アプリケーションセキュリティテスト (SAST) を有効にする**チェックボックスをオンにします。
   - 不正なアクセスを防ぐためにソースコードからシークレットと認証情報を分析するには、**シークレット検出を有効にする**チェックボックスを選択します。
1. **プロジェクトを作成**を選択します。

これで、親グループにプロジェクトを作成できました。

このプロジェクトで、**管理** > **メンバー**に移動します。

プロジェクトがグループに属している場合、プロジェクトのメンバーはグループからロールを継承するので、親グループの既存のメンバー（あなたとAlex）はすでにこのプロジェクトのメンバーになっています。

このプロジェクトに含める必要がある他のユーザーがいます。次に、ユーザーをプロジェクトに直接追加します。

## ユーザーをプロジェクトと親グループに追加する {#add-users-to-the-project-and-parent-group}

1. 左側のサイドバーで、**検索または移動先**を選択して、**Release 2.0**プロジェクトを見つけます。[新しいナビゲーションをオン](../../user/interface_redesign.md#turn-new-navigation-on-or-off)にしている場合、このフィールドは上部のバーにあります。
1. 左側のサイドバーで、**管理** > **メンバー**を選択します。
1. **メンバーを招待**を選択します。次のユーザーを招待します:

   | ユーザー           | ロール       | アクセス有効期限 |
   |----------------|------------|------------------------|
   | Charlie Devi   | メンテナー | 空白のまま            |
   | Frankie Ali    | メンテナー | 空白のまま            |
   | Grayson Garcia | メンテナー | 空白のまま            |

1. **招待**を選択します。
1. これらのユーザーをプロジェクトに直接追加したため、必要に応じて、プロジェクトのメンバーページでユーザーのロールを変更できます。Grayson Garciaのロールを**デベロッパー**に変更して、これをテストします。
1. Development親グループのメンバーページに移動します。親グループにプロジェクトがあるにもかかわらず、プロジェクトに追加したユーザーはここに表示されません。
1. 同じユーザーを**ゲスト**ロールで親グループに直接追加します。このページでユーザーのロールを直接変更できます。Frankieのロールを**レポーター**に変更します。
1. Release 2.0プロジェクトのメンバーページに戻ります。メンバーのプロジェクトロールは、メンテナー2人とデベロッパー1人のままです。

これで、サブグループのメンバーである3人のユーザーを親グループのプロジェクトに追加し、プロジェクトと親グループでそれらのユーザーに個別のロールを付与できました。
