---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: '機密性の高いシークレットまたはトークンであるTwitch OAuthクライアントシークレットの公開'
---

## 説明 {#description}

Twitch OAuthクライアントシークレットのパターンに一致するコンテンツが応答bodyに含まれていることが確認されました。OAuthクライアントシークレットは、サービスがTwitchユーザーに代わって機能を実行できるようにするために使用されます。このクライアントシークレットにアクセスできる悪意のある攻撃者は、サービスを偽装し、そのユーザーに代わって機能を実行できます。この値を公開すると、攻撃者がこのトークンによって許可されたすべてのリソースにアクセスできるようになる可能性があります。

## 修正 {#remediation}

セキュリティインシデントにおける、漏洩したキーの取り扱いに関する一般的なガイダンスについては、GitLabドキュメントの[認証情報のインターネットへの公開](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet)を参照してください。

OAuthクライアントシークレットをローテーションするには:

- Twitchアカウントにサインインして、<https://dev.twitch.tv/console>にアクセスします
- 識別されたキーを使用する拡張機能を見つけます
- 「Extensions」セクションで、拡張機能名の横にある「Manage」を選択します
- 右上隅で、「Extension設定」を選択します
- 「Twitch API Client設定」セクションで、「Twitch API Client Secret」の「Generate Secret」を選択します
- プロンプトが表示されたら、ダイアログから「OK」を選択します

詳細については、[TwitchのOAuthに関するデベロッパードキュメント](https://dev.twitch.tv/docs/authentication/getting-tokens-oauth/#authorization-code-grant-flow)を参照してください。

## 詳細 {#details}

| ID | 集約 | CWE | 型 | リスク |
|:---|:-----------|:----|:-----|:-----|
| 798.118 | いいえ | 798 | パッシブ | 高 |

## リンク {#links}

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
