---
stage: AI-powered
group: Workflow Catalog
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: カスタムフロー
---

{{< details >}}

- プラン: Premium、Ultimate
- アドオン: GitLab Duo Core、Pro、またはEnterprise
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated
- ステータス: ベータ版

{{< /details >}}

{{< collapsible title="モデル情報" >}}

- LLM: Anthropic [Claude Sonnet 4](https://www.anthropic.com/claude/sonnet)

{{< /collapsible >}}

{{< history >}}

- GitLab 18.4で`ai_catalog_flows`[フラグ](../../../administration/feature_flags/_index.md)とともに[実験的機能](../../../policy/development_stages_support.md)として導入されました。デフォルトでは無効になっています。
- GitLab 18.7で[ベータ版](../../../policy/development_stages_support.md)に変更されました。
- GitLab 18.7の[GitLab.comで有効](https://gitlab.com/gitlab-org/gitlab/-/issues/569060)になりました。
- GitLab 18.8の[GitLab Self-ManagedおよびGitLab Dedicatedで有効](https://gitlab.com/gitlab-org/gitlab/-/work_items/569060)になりました。

{{< /history >}}

{{< alert type="flag" >}}

この機能の利用可否は、機能フラグによって制御されます。詳細については、履歴を参照してください。

{{< /alert >}}

カスタムフローは、GitLabプロジェクト全体にわたる複雑な複数ステップのタスクを自動化するために作成および設定できる、AIを活用したワークフローです。

## フローの表示レベル {#flow-visibility}

カスタムフローを作成する際は、そのフローを管理するプロジェクトを選択し、フローを公開または非公開のどちらにするかを選択します。

公開フロー:

- インスタンス上の誰でも閲覧でき、前提条件を満たすすべてのプロジェクトで有効にできます。

非公開フロー:

- 管理対象プロジェクトのデベロッパーロール以上を持つメンバー、およびトップレベルグループのオーナーロールを持つユーザーのみが閲覧できます。
- 管理対象プロジェクト以外のプロジェクトや、トップレベルグループ以外のグループでは有効にできません。

フローが現在有効になっている場合、非公開フローを公開フローに変更することはできません。

## プロジェクトのフローを表示する {#view-the-flows-for-your-project}

前提条件: 

- プロジェクトのデベロッパーロール以上が必要です。

プロジェクトに関連付けられたフローの一覧を表示するには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **自動化** > **フロー**を選択します。
   - プロジェクトでフローを有効にするには、**有効**タブを選択します。
   - プロジェクトで管理されているフローを表示するには、**Managed**タブを選択します。

フローを選択して詳細を表示します。

## フローを作成する {#create-a-flow}

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。

フローを作成するには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **自動化** > **フロー**を選択します。
1. **新しいフロー**を選択します。
1. **基本情報**で、次の操作を行います:
   1. **表示名**に、名前を入力します。
   1. **説明**に、説明を入力します。
1. **表示レベルとアクセス**の下にある**表示レベル**で、**非公開**または**公開**を選択します。
1. **設定**で、次の操作を行います:
   1. **フロー**を選択します。
   1. エディタで、フローの設定を入力します。カスタムフローYAMLの記述方法については、[フローレジストリフレームワークに関するドキュメント](https://gitlab.com/gitlab-org/modelops/applied-ml/code-suggestions/ai-assist/-/blob/main/docs/flow_registry/v1.md)を参照してください。
1. **フローを作成**を選択します。

フローがAIカタログに表示されます。

## フローを有効にする {#enable-a-flow}

フローを有効にすると、イシュー、マージリクエスト、またはディスカッションからフローをトリガーできます。フローを有効にするには、次の要件を満たしている必要があります:

1. トップレベルグループで有効になっている。
1. 使用するプロジェクトで有効になっている。

### トップレベルグループで有効にする {#enable-in-a-top-level-group}

前提条件: 

- グループのオーナーロールが必要です。

トップレベルグループでフローを有効にするには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. 有効にするフローを選択します。
1. 右上隅で、**グループで有効にする**を選択します。
1. ドロップダウンリストから、フローを有効にするグループを選択します。
1. **有効化**を選択します。

グループの**自動化** > **フロー**ページにフローが表示されます。

サービスアカウントがグループに作成されます。アカウントの名前は、`ai-<flow>-<group>`という命名規則に従います。

### プロジェクトで有効にする {#enable-in-a-project}

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。
- プロジェクトのトップレベルグループでフローを有効にする必要があります。

プロジェクトでフローを有効にするには:

1. 上部のバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **自動化** > **フロー**を選択します。
1. 右上隅で、**グループからのflowを有効にする**を選択します。
1. ドロップダウンリストから、有効にするフローを選択します。
1. **トリガーを追加**で、フローをトリガーするイベントを選択します:
   - **メンション**: イシューまたはマージリクエストのコメントでサービスアカウントユーザーがメンションされたとき。
   - **アサイン**: サービスアカウントユーザーがイシューまたはマージリクエストにアサインされたとき。
   - **レビュアーをアサインする**: サービスアカウントユーザーがレビュアーとしてマージリクエストにアサインされたとき。
1. **有効化**を選択します。

プロジェクトの**自動化** > **フロー**リストにフローが表示されます。

トップレベルグループのサービスアカウントがプロジェクトに追加されます。このアカウントにはデベロッパーロールが割り当てられます。

### フローを無効にする {#disable-a-flow}

前提条件: 

- グループの場合、オーナーロールが必要です。
- プロジェクトの場合、メンテナーロール以上が必要です。

フローを無効にするには:

1. 上部のバーで、**検索または移動先**を選択し、グループまたはプロジェクトを見つけます。
1. **自動化** > **フロー**を選択します。
1. 削除するフローを見つけて、**アクション**（{{< icon name="ellipsis_v" >}}）> **無効化**を選択します。
1. 確認ダイアログで、**無効化**を選択します。

フローはプロジェクトまたはグループに表示されなくなり、実行できなくなります。フローに関連付けられていたサービスアカウントまたはトリガーもすべて削除されます。

## トリガーを作成する {#create-a-trigger}

次に、フローがいつ実行されるかを定義する[トリガーを作成](../triggers/_index.md)する必要があります。

たとえば、ディスカッションでフローサービスアカウントユーザーにメンションしたとき、またはサービスアカウントをレビュアーとしてアサインしたときに、フローがトリガーされるよう指定できます。

プロジェクトでフローを有効にすると、トリガーも作成されます。

## フローを使用する {#use-a-flow}

前提条件: 

- プロジェクトのデベロッパーロール以上が必要です。
- プロジェクトでフローを有効にする必要があります。

フローを使用するには:

1. プロジェクトで、イシュー、マージリクエスト、またはエピックを開きます。
1. フローをトリガーするには、フローサービスアカウントユーザーに対して、メンション、アサイン、またはレビューのリクエストを行います。デフォルトでは、ユーザーの名前は`ai-<flow>-<group>`です。

   たとえば、`Security scanner`という名前のフローを`GitLab Duo`グループで有効にした場合、サービスアカウントユーザーは`ai-security-scanner-gitlab-duo`です。
1. フローがタスクを完了すると、確認メッセージが表示され、すぐにマージ可能な変更またはインラインコメントが表示されます。

{{< alert type="warning" >}}サービスアカウントは、以下の両方のプロジェクトにアクセスできます:

- アクセスできる。
- フローが追加されている。

{{< /alert >}}

## フローを複製する {#duplicate-a-flow}

元のフローを上書きせずに変更を加えるには、既存のフローのコピーを作成します。

前提条件: 

- プロジェクトのメンテナーロール以上が必要です。

フローを複製するには:

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. 複製するフローを選択します。
1. 右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）> **重複**を選択します。
1. オプション。変更するフィールドを編集します。
1. **フローを作成**を選択します。

## フローを管理する {#manage-flows}

フローの設定を変更するには編集し、AIカタログから削除するにはフローを削除します。

前提条件: 

- 管理対象プロジェクトのメンバーであり、メンテナーロール以上を持っている必要があります。

1. 上部のバーで、**検索または移動先** > **検索**を選択します。
1. **AIカタログ**を選択し、次に**フロー**タブを選択します。
1. 管理するフローを選択します。
   - フローを編集するには:
     1. 右上隅で、**編集**を選択します。
     1. 変更するフィールドを編集し、**変更を保存**を選択します。
   - フローを削除するには:
     1. 右上隅で、**アクション**（{{< icon name="ellipsis_v" >}}）> **削除**を選択します。
     1. 確認ダイアログで、**削除**を選択します。

## グループ共有とフロー {#group-sharing-and-flows}

グループでフローを有効にすると、関連するサービスアカウントが自動的に作成されます。サービスアカウント:

- フローを実行するユーザー以上のアクセス権をフローが持たないように、[複合アイデンティティ認証](../security.md)を使用します。
- フローを有効にするトップレベルグループ配下のすべてのプロジェクトのメンバーとして追加されるため、フローはそのグループ外のリソースにアクセスできません。
- トップレベルグループと共有されている追加のグループへのアクセス権が付与されます。サービスアカウントは、グループ共有のために他のグループメンバーと同様に扱われます。

{{< alert type="note" >}}

複数のトップレベルグループ間でフローのサービスアカウントを共有すると、意図しないアクセス許可やセキュリティ上のリスクが生じる可能性があります。

{{< /alert >}}
