---
stage: AI-powered
group: Custom Models
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: Host your own AI Gateway and language models.
title: Self-hosted models
---

{{< details >}}

- Tier: Premium, Ultimate
- Offering: GitLab Self-Managed

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/12972) in GitLab 17.1 [with a flag](../feature_flags/_index.md) named `ai_custom_model`. Disabled by default.
- [Enabled on GitLab Self-Managed](https://gitlab.com/groups/gitlab-org/-/epics/15176) in GitLab 17.6.
- Changed to require GitLab Duo add-on in GitLab 17.6 and later.
- Feature flag `ai_custom_model` removed in GitLab 17.8.
- Generally available in GitLab 17.9.
- Changed to include Premium in GitLab 18.0.
- Changed to require the GitLab Duo Agent Platform Self-Hosted add-on for offline licenses in GitLab 18.8
- Changed to usage billing of features in GitLab Duo Agent Platform for online licenses in GitLab 18.9

{{< /history >}}

Host your own AI infrastructure to use GitLab Duo features with the LLMs of your choice. Use a
self-hosted AI Gateway to keep all request and response data in your own environment,
avoid external API calls, and manage the full lifecycle of requests to your LLM backends.

## Deployment options

You can use self-hosted models with different deployment options.

### GitLab Duo (Classic)

GitLab Duo Self-Hosted for customers with GitLab Duo Enterprise who are using GitLab Duo (Classic)
features. You can use:

- On-premise models or private cloud-hosted models
- GitLab-managed models in a hybrid deployment

This option uses seat-based pricing.

### GitLab Duo Agent Platform

GitLab Duo Agent Platform Self-Hosted to use on-premise models or private cloud-hosted models in the GitLab Duo Agent Platform.

For customers with an offline license, billing is seat based and you must have the [GitLab Duo Agent Platform Self-Hosted](../../subscriptions/subscription-add-ons.md#gitlab-duo-agent-platform-self-hosted) add-on.

For customers with an online license, billing is usage based. You can also use GitLab-managed models in a hybrid deployment.

### Feature versions and status

The following table lists:

- The GitLab version required to use the feature.
- The feature status. A feature status in the deployment might be different to the status listed in the feature.

To use GitLab Duo (Classic) features with GitLab Duo Self-Hosted, you must have the GitLab
Duo Enterprise add-on. This applies even if you can use these features with GitLab Duo Core
or GitLab Duo Pro when GitLab hosts and connects to those models through the cloud-based [AI Gateway](../../administration/gitlab_duo/gateway.md).

| Feature                                                                                                                                | GitLab version          | Status              |
|----------------------------------------------------------------------------------------------------------------------------------------|-------------------------|---------------------|
| [GitLab Duo Agent Platform](../../user/duo_agent_platform/_index.md)                                                                   | GitLab 18.8 and later   | Generally available |
| **GitLab Duo (Classic)** | | |
| [Code Suggestions (Classic)](../../user/project/repository/code_suggestions/_index.md)                                                 | GitLab 17.9 and later   | Generally available |
| [GitLab Duo Chat (Classic)](../../user/gitlab_duo_chat/_index.md)                                                                      | GitLab 17.9 and later   | Generally available |
| [Code Explanation](../../user/gitlab_duo_chat/examples.md#explain-selected-code)                                                       | GitLab 17.9 and later   | Generally available |
| [Test Generation](../../user/gitlab_duo_chat/examples.md#write-tests-in-the-ide)                                                       | GitLab 17.9 and later   | Generally available |
| [Refactor Code](../../user/gitlab_duo_chat/examples.md#refactor-code-in-the-ide)                                                       | GitLab 17.9 and later   | Generally available |
| [Fix Code](../../user/gitlab_duo_chat/examples.md#fix-code-in-the-ide)                                                                 | GitLab 17.9 and later   | Generally available |
| [Code Review](../../user/project/merge_requests/duo_in_merge_requests.md#use-gitlab-duo-to-review-your-code)                           | GitLab 18.3 and later   | Generally available |
| [Root Cause Analysis](../../user/gitlab_duo_chat/examples.md#troubleshoot-failed-cicd-jobs-with-root-cause-analysis)                   | GitLab 17.10 and later  | Beta                |
| [Vulnerability Explanation](../../user/application_security/analyze/duo.md)                                                            | GitLab 18.1.2 and later | Beta                |
| [Merge Commit Message Generation](../../user/project/merge_requests/duo_in_merge_requests.md#generate-a-merge-commit-message)          | GitLab 18.1.2 and later | Beta                |
| [Merge Request Summary](../../user/project/merge_requests/duo_in_merge_requests.md#generate-a-description-by-summarizing-code-changes) | GitLab 18.1.2 and later | Beta                |
| [Discussion Summary](../../user/discussions/_index.md#summarize-issue-discussions-with-gitlab-duo-chat)                                | GitLab 18.1.2 and later | Beta                |
| [GitLab Duo for the CLI](https://docs.gitlab.com/cli/)                                                                                 | GitLab 18.1.2 and later | Beta                |
| [Vulnerability Resolution](../../user/application_security/vulnerabilities/_index.md#vulnerability-resolution)                         | GitLab 18.1.2 and later | Beta                |
| [GitLab Duo and SDLC trends Dashboard](../../user/analytics/duo_and_sdlc_trends.md)                                                    | GitLab 17.9 and later   | Beta                |
| [Code Review Summary](../../user/project/merge_requests/duo_in_merge_requests.md#summarize-a-code-review)                              | GitLab 18.1.2 and later | Experiment          |

## AI Gateway configurations

After you choose a product option, configure how your AI Gateway connects to LLMs:

- **Self-hosted AI Gateway and LLMs**: Use your own AI Gateway and models for full control over your AI infrastructure.
- **Hybrid AI Gateway and model configuration**: For each feature, use either your self-hosted AI Gateway with self-hosted models, or the GitLab.com AI Gateway with GitLab AI vendor models.
- **GitLab.com AI Gateway with default GitLab external vendor LLMs**: Use GitLab managed AI infrastructure.

| Configuration               | Self-hosted AI Gateway                                                                    | Hybrid AI Gateway and model configuration                                                                                                        | GitLab.com AI Gateway                    |
|-----------------------------|-------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------|
| Infrastructure requirements | Requires hosting your own AI Gateway and models                                           | Requires hosting your own AI Gateway and models                                                                                                  | No additional infrastructure needed      |
| Model options               | Choose from [supported self-hosted models](supported_models_and_hardware_requirements.md) | Choose from [supported self-hosted models](supported_models_and_hardware_requirements.md) or GitLab AI vendor models for each GitLab Duo feature | Uses the default GitLab AI vendor models |
| Network requirements        | Can operate in fully isolated networks                                                    | Requires internet connectivity for GitLab Duo features that use GitLab AI vendor models                                                          | Requires internet connectivity           |
| Responsibilities            | You set up your infrastructure, and do your own maintenance                               | You set up your infrastructure, do your own maintenance, and choose which features use GitLab AI vendor models and AI Gateway                    | GitLab does the set up and maintenance   |

### Self-hosted AI Gateway and LLMs

In a fully self-hosted configuration, you deploy your own AI Gateway and use only [supported LLMs](supported_models_and_hardware_requirements.md) in your infrastructure, without using GitLab infrastructure or AI vendor models. This gives you full control over your data and security.

> [!note]
> This configuration only includes models configured through your self-hosted AI Gateway. If you use [GitLab AI vendor models](configure_duo_features.md#configure-a-feature-to-use-a-gitlab-ai-vendor-model) for any features, those features connect to the GitLab-hosted AI Gateway instead of your self-hosted gateway, making it a hybrid configuration rather than fully self-hosted.

While you deploy your own AI Gateway, you can still use cloud-based LLM services like [AWS Bedrock](https://aws.amazon.com/bedrock/) or [Azure OpenAI](https://azure.microsoft.com/en-us/products/ai-services/openai-service) as your model backend and they will continue to connect through your self-hosted AI Gateway.

If you have an offline environment with physical barriers or security policies that prevent or limit internet access, and comprehensive LLM controls, you should use this fully self-hosted configuration.

For more information, see:

- The [self-hosted AI Gateway configuration diagram](configuration_types.md#self-hosted-ai-gateway).

### Hybrid AI Gateway and model configuration

{{< history >}}

- [Introduced](https://gitlab.com/groups/gitlab-org/-/epics/17192) in GitLab 18.3 as a [beta](../../policy/development_stages_support.md#beta) with a [feature flag](../feature_flags/_index.md) named `ai_self_hosted_vendored_features`. Disabled by default.
- [Enabled by default](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/214030) in GitLab 18.7
- Generally available in GitLab 18.9. Feature flag `ai_self_hosted_vendored_features` [removed](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218595).

{{< /history >}}

In this hybrid configuration, you deploy your own AI Gateway and self-hosted models for most features, but configure specific features to use GitLab AI vendor models. When a feature is configured to use a GitLab AI vendor model, requests for that feature are sent to the GitLab-hosted AI Gateway instead of your self-hosted AI Gateway.

This option provides flexibility by allowing you to:

- Use your own self-hosted models for features where you want full control.
- Use GitLab-managed vendor models for specific features where you prefer the models GitLab has curated.

> [!note]
> When features are configured to use GitLab AI vendor models:
>
> - All calls to those features use the GitLab-hosted AI Gateway, not the self-hosted AI Gateway.
> - Internet connectivity is required for these features.
> - This is not a fully self-hosted or isolated configuration.

For more information, see:

- [Configure GitLab AI vendor models](configure_duo_features.md#configure-a-feature-to-use-a-gitlab-ai-vendor-model)

#### GitLab managed models

Use GitLab managed models to connect to AI models without the need to self-host infrastructure. These models are managed entirely by GitLab.

You can select the default GitLab model to use with an AI-native feature. For the default model, GitLab uses the best model based on availability, quality, and reliability. The model used for a feature can change without notice.

When you select a specific GitLab managed model, all requests for that feature use that model exclusively. If the model becomes unavailable, requests to the AI Gateway fail and users cannot use that feature until another model is selected.

> [!note]
> When you configure a feature to use GitLab managed models:
>
> - Calls to those features use the GitLab-hosted AI Gateway, not the self-hosted AI Gateway.
> - Internet connectivity is required for these features.
> - The configuration is not fully self-hosted or isolated.

### GitLab.com AI Gateway with default GitLab external vendor LLMs

{{< details >}}

- Add-on: GitLab Duo Core, Pro, or Enterprise

{{< /details >}}

If you do not meet the use case criteria for GitLab Duo Self-Hosted, you can use the
GitLab.com AI Gateway with default GitLab external vendor LLMs.

The GitLab.com AI Gateway is the default Enterprise offering and is not self-hosted. In this configuration,
you connect your instance to the GitLab-hosted AI Gateway, which
integrates with external vendor LLM providers, including:

- [Anthropic](https://www.anthropic.com/)
- [Fireworks AI](https://fireworks.ai/)
- [Google Vertex](https://cloud.google.com/vertex-ai/)

These LLMs communicate through the GitLab Cloud Connector,
offering a ready-to-use AI solution without the need for on-premise infrastructure.

For more information, see the [GitLab.com AI Gateway configuration diagram](configuration_types.md#gitlabcom-ai-gateway).

To set up this infrastructure, see [how to configure GitLab Duo on a GitLab Self-Managed instance](../../administration/gitlab_duo/configure/gitlab_self_managed.md).

## Set up a private infrastructure

If you have an offline license, you can set up a fully private infrastructure:

1. Install a Large Language Model (LLM) serving infrastructure.

   - GitLab supports various platforms for serving and hosting your LLMs, such as vLLM, AWS Bedrock,
   and Azure OpenAI. For more information about each platform, see [supported LLM platforms documentation](supported_llm_serving_platforms.md).

   - GitLab provides a matrix of supported models with their specific features and hardware requirements. For more information,
   see the [supported models and hardware requirements documentation](supported_models_and_hardware_requirements.md).

1. [Install the AI Gateway](../../install/install_ai_gateway.md) to access GitLab Duo features.

1. [Configure your GitLab instance](configure_duo_features.md) for features to use self-hosted models.

1. [Enable logging](logging.md) to track and manage your system's performance.

## Related topics

- [Troubleshooting](troubleshooting.md)
- [Install the GitLab AI Gateway](../../install/install_ai_gateway.md)
- [Supported models](supported_models_and_hardware_requirements.md)
- [GitLab Duo Self-Hosted supported platforms](supported_llm_serving_platforms.md)
