---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token SSH (EC) private key'
---

## Description

The response body contains content that matches the pattern of an SSH private key was identified. Private SSH keys are used for authentication and symmetric key exchange. A malicious actor with access to this key can use it to impersonate an application or service.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

To generate a new ECDSA key, use the `ssh-keygen` tool:

```shell
ssh-keygen -t ecdsa
```

Note: Newer versions of SSH may output `-----BEGIN OPENSSH PRIVATE KEY-----` instead of `-----BEGIN EC PRIVATE KEY-----`

For more information, please see the [`ssh-keygen` documentation](https://linux.die.net/man/1/ssh-keygen).

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.174 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
