---
stage: Software Supply Chain Security
group: Compliance
info: "To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments"
title: Audit event types
---

<!--
  This documentation is auto generated by a Rake task.

  Please do not edit this file directly. To update this file, run:
  bundle exec rake gitlab:audit_event_types:compile_docs

  To make changes to the output of the Rake task,
  edit `tooling/audit_events/docs/templates/audit_event_types.md.erb`.
-->

{{< details >}}

- Tier: Premium, Ultimate
- Offering: GitLab.com, GitLab Self-Managed, GitLab Dedicated

{{< /details >}}

{{< history >}}

- [Introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172757) in GitLab 17.7, all audit events can be streamed.

{{< /history >}}

Audit event types are used to filter streamed audit events:

- [For instances](../../administration/compliance/audit_event_streaming.md#update-event-filters).
- [For top-level groups](audit_event_streaming.md#update-event-filters)

Every audit event is associated with an event type. Audit event types can allow:

- Most audit events to be saved to the database. Available in the Premium and Ultimate tier. You can retrieve
  audit events associated with these types by using the audit events dashboard or the
  [audit events API](../../api/audit_events.md).
- All audit events to be streamed to external destinations. Available in the Ultimate tier. You can stream audit events
  associated with these types to external destinations if a destination is set.

An audit event type's scope limits the availability of the audit event type to either:

- [Project, group, or user](audit_events.md) audit events.
- [Instance](../../administration/compliance/audit_event_reports.md) audit events.

## Available audit event types

Audit event types belong to the following product categories.

### Agent foundations

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`feature_access_rules_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/217749) | GitLab Duo feature access rules were updated | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/issues/584380) | Instance |
| [`namespace_feature_access_rules_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/217896) | GitLab Duo namespace feature access rules were updated | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/work_items/584381) | Group |

### Ai framework

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`duo_features_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/145509) | GitLab Duo Features enabled setting on group or project changed | {{< yes >}} | GitLab [16.10](https://gitlab.com/gitlab-org/gitlab/-/issues/442485) | Group, Project |
| [`q_onbarding_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175501) | Amazon Q instance settings changed | {{< yes >}} | GitLab [17.8](https://gitlab.com/gitlab-org/gitlab/-/issues/508250) | Instance |

### Audit events

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`amazon_s3_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132443) | Amazon S3 configuration for audit events streaming is created | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | Group |
| [`amazon_s3_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133695) | Amazon S3 configuration for audit events streaming is deleted | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | Group |
| [`amazon_s3_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/133691) | Amazon S3 configuration for audit events streaming is updated | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423229) | Group |
| [`audit_events_streaming_headers_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | A streaming header for audit events is created | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | Group |
| [`audit_events_streaming_headers_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | A streaming header for audit events is deleted | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | Group |
| [`audit_events_streaming_instance_headers_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125870) | A streaming header for instance level external audit event destination is created | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | Instance |
| [`audit_events_streaming_instance_headers_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127228) | A streaming header for instance level external audit event destination is deleted | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | Instance |
| [`audit_events_streaming_instance_headers_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/127228) | A streaming header for instance level external audit event destination is updated | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/417433) | Instance |
| [`create_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | An external audit event destination is created | {{< yes >}} | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | Group |
| [`create_http_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136047) | A namespace filter for an external audit event destination for a top-level group is created | {{< yes >}} | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/424176) | Group |
| [`create_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123882) | An external audit event destination for an instance is created | {{< yes >}} | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | Instance |
| [`created_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147888) | An external audit event destination for a top-level group is created | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | Group |
| [`created_group_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150712) | A namespace filter for an external audit event destination for a top-level group is created | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/436612) | Group |
| [`created_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148383) | An external audit event destination for an instance is created | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | Instance |
| [`created_instance_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156) | A namespace filter for an external audit event destination for an instance is created | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/436613) | Instance |
| [`delete_http_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136302) | A namespace filter for an external audit event destination for a top-level group is deleted | {{< yes >}} | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/424177) | Group |
| [`deleted_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148738) | An external audit event destination for a top-level group is deleted | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | Group |
| [`deleted_group_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150712) | A namespace filter for an external audit event destination for a top-level group is deleted | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/436612) | Group |
| [`deleted_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/14910) | An external audit event destination for a GitLab instance is deleted | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | Instance |
| [`deleted_instance_namespace_filter`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153156) | A namespace filter for an external audit event destination for a GitLab instance is deleted | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/436613) | Instance |
| [`destroy_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | An external audit event destination is deleted | {{< yes >}} | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | Group |
| [`destroy_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125846) | An instance level external audit event destination is deleted | {{< yes >}} | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | Instance |
| [`event_type_filters_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113081) | A new audit events streaming event type filter is created | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/344848) | Group |
| [`event_type_filters_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113489) | An audit events streaming event type filter is deleted | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/344848) | Group |
| [`google_cloud_logging_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Google Cloud Logging configuration is created | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | Group |
| [`google_cloud_logging_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Google Cloud Logging configuration is deleted | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | Group |
| [`google_cloud_logging_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/122025) | Google Cloud Logging configuration is updated | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/409422) | Group |
| [`instance_amazon_s3_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137651) | Instance Amazon S3 configuration for audit events streaming is created | {{< yes >}} | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | Instance |
| [`instance_amazon_s3_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138318) | Instance-level Amazon S3 configuration for audit events streaming is deleted | {{< yes >}} | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | Instance |
| [`instance_amazon_s3_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138310) | Instance-level Amazon S3 configuration for audit events streaming is updated | {{< yes >}} | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/423235) | Instance |
| [`instance_google_cloud_logging_configuration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130663) | Instance-level Google Cloud Logging configuration is created | {{< yes >}} | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/423038) | Instance |
| [`instance_google_cloud_logging_configuration_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131752) | Instance-level Google Cloud Logging configuration is deleted | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423040) | Instance |
| [`instance_google_cloud_logging_configuration_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131790) | Instance-level Google Cloud Logging configuration is updated | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/423039) | Instance |
| [`update_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74632) | An external audit event destination is updated | {{< yes >}} | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/344664) | Group |
| [`update_instance_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/125846) | An instance level external audit event destination is updated | {{< yes >}} | GitLab [16.2](https://gitlab.com/gitlab-org/gitlab/-/issues/404730) | Instance |
| [`updated_group_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148388) | An external audit event destination for a top-level group is updated | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436610) | Group |
| [`updated_instance_audit_event_streaming_destination`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149104) | An external audit event destination for a GitLab instance is updated | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/436615) | Instance |

### Authorization

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`oauth_application_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194557) | User creates an OAuth application | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/550321) | User |
| [`secure_ci_job_token_policies_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170930) | Permissions are updated for a CI_JOB_TOKEN scope | {{< yes >}} | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/495144) | Project |
| [`user_authorized_oauth_application`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/179187) | User authorized an OAuth application | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/514152) | User |

### Build artifacts

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`job_artifact_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129608) | A user downloads a job artifact from a project | {{< no >}} | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/250663) | Project |

### Ci variables

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`variable_viewed_api`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/197385) | A CI/CD variable is accessed with the API | {{< no >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555960) | Project, Group |
| [`group_ci_cd_settings_accessed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203540) | Log an audit event when a user loads the CI/CD Settings page of a group. | {{< no >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/555959) | Group |
| [`project_ci_cd_settings_accessed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203540) | Log an audit event when a user loads the CI/CD Settings page of a project. | {{< no >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/555959) | Project |

### Code review

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`delete_merge_request`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | A merge request is successfully deleted | {{< no >}} | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Project |
| [`group_merge_request_approval_setting_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/87880) | Merge request approval settings are added to a group | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/356152) | Group |

### Code review workflow

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`merge_request_approval_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92983) | A merge request is approved | {{< no >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/10869) | Project |
| [`merge_request_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | A merge request is closed using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`merge_request_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | A merge request is created using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`merge_request_invalid_approver_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100496) | An invalid rule when merge request is approved | {{< yes >}} | GitLab [15.5](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100496) | Project |
| [`merge_request_merged_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | A merge request is merged using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`merge_request_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | A merge request is reopened using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`project_merge_method_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | A project's merge request method is updated | {{< yes >}} | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`project_merge_requests_author_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's MR author approval setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_merge_requests_disable_committers_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's setting for disabling committers approval on merge requests is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369277) | Project |
| [`project_merge_requests_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | A merge request template for a project is updated | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`project_only_allow_merge_if_all_discussions_are_resolved_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's setting for allowing merge only when all discussions are resolved is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369286) | Project |
| [`project_only_allow_merge_if_pipeline_succeeds_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's only allow merge if pipeline succeeds setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_remove_source_branch_after_merge_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | A project has its setting to remove branches after merges updated | {{< yes >}} | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`project_require_password_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's setting for requiring a user's password for approval of merge request is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369280) | Project |
| [`project_reset_approvals_on_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66234) | A project has its setting on whether approvals are reset on a push is updated | {{< yes >}} | GitLab [14.2](https://gitlab.com/gitlab-org/gitlab/-/issues/336211) | Project |
| [`project_resolve_outdated_diff_discussions_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's resolve outdated diff discussions setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`show_diff_preview_in_email_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Email notification to include diff preview is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group, Project |
| [`selective_code_owner_removals_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/148743) | Selective code owner removal is updated | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/327562) | Project |

### Code suggestions

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_suggestion_commit_message_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | A project has its suggested commit message updated | {{< yes >}} | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |

### Compliance management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`add_gpg_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111744) | A GPG key is added | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373961) | User |
| [`allow_author_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Prevent approval by merge request creator setting is updated | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`allow_committer_approval_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Prevent approvals by users who add commits setting is updated | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`allow_overrides_to_approver_list_per_merge_request_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Prevent editing approval rules in projects and merge requests setting is updated | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`audit_events_streaming_headers_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92068) | A streaming header for audit events is updated | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/366350) | Group |
| [`compliance_control_status_fail`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107) | A compliance control status is updated to fail | {{< yes >}} | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/513425) | Project |
| [`compliance_control_status_pass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180107) | A compliance control status is updated to pass | {{< yes >}} | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/513425) | Project |
| [`compliance_framework_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893) | A compliance framework is applied to a project | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/464160) | Project |
| [`compliance_framework_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65343) | A compliance framework is removed from a project | {{< yes >}} | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/329362) | Project |
| [`compliance_framework_id_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/94711) | A compliance framework is updated for a project | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369310) | Project |
| [`compliance_framework_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/157893) | A compliance framework is removed from a project | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/464160) | Project |
| [`create_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | A compliance framework is successfully created | {{< yes >}} | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | Group |
| [`create_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | An external status check is created | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`created_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485) | A requirement is added to a compliance framework | {{< yes >}} | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | Group |
| [`created_compliance_requirement_control`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557) | A control is added to a compliance requirement. | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/512381) | Group |
| [`delete_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | An external status check is deleted | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`destroy_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | A compliance framework is successfully deleted | {{< yes >}} | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | Group |
| [`destroyed_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/170380) | A compliance framework requirement is destroyed | {{< yes >}} | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | Group |
| [`destroyed_compliance_requirement_control`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177878) | A compliance requirement control is destroyed. | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/512381) | Group |
| [`external_status_check_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106095) | The name of an external status check is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369333) | Project |
| [`external_status_check_url_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | The URL that is used for external status checks for a pipeline is updated | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`group_saml_member_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/202160) | A user was added as a SAML group member | {{< yes >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/560237) | Group |
| [`group_saml_provider_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111227) | A group SAML provider is created | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373964) | Group |
| [`group_saml_provider_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111227) | A group SAML provider is updated | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373964) | Group |
| [`inactive_project_scheduled_for_deletion`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/130699) | An inactive project is scheduled for deletion | {{< yes >}} | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/423263) | Project |
| [`merge_request_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90911) | A merge request is created | {{< no >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/367239) | Project |
| [`merge_request_merged`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164846) | A merge request is merged | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/442279) | Project |
| [`omniauth_login_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123080) | An OmniAuth login fails | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`password_reset_requested`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114548) | A user requests a password reset using a registered email address | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`pending_compliance_external_control_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180016) | A project's compliance external control status is updated to fail because of timeout. | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/513421) | Project |
| [`personal_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108952) | A user creates a personal access token | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374113) | User |
| [`personal_access_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108952) | A personal access token is revoked | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374113) | User |
| [`project_archived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | A project is archived | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117546) | A project is marked for deletion | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Group, Instance |
| [`project_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117546) | A project is destroyed | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Group, Instance |
| [`project_export_file_download_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | A download of a project export file is started | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_feature_security_and_compliance_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's security and compliance access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369302) | Project |
| [`project_group_link_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | A group is invited to a project | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | Group |
| [`project_group_link_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | A project group link is deleted | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | Group |
| [`project_group_link_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108918) | A project group link is updated | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374114) | Project |
| [`project_imported`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | A project is imported | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Group |
| [`project_restored`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | A project is restored | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`protected_branch_allow_force_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68869) | A protected branch has its ability to allow force pushes is updated | {{< yes >}} | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/338873) | Project |
| [`public_repository_download_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/149842) | A Git repository for a public project is downloaded | {{< no >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/383218) | Project |
| [`registration_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/123080) | A user registers for instance access | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`release_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | A release is created | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`release_deleted_audit_event`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | A release is deleted | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`release_milestones_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | A release's associated milestones are updated | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`release_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111080) | A release is updated | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374111) | Project |
| [`remove_gpg_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111744) | A GPG key is deleted | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373961) | User |
| [`repository_download_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/111218) | A Git repository for a private or internal project is downloaded | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374108) | Project |
| [`request_to_compliance_external_control_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010) | Request to compliance external control failed | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/513421) | Project |
| [`request_to_compliance_external_control_successful`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/180010) | Request to compliance external control successful | {{< no >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/513421) | Project |
| [`require_password_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Require user password for approvals from group merge request setting is updated | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`retain_approvals_on_push_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102256) | Require new approvals when new commits are added to an MR from group merge request setting is updated | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/373949) | Group |
| [`saml_group_links_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110525) | A SAML Group Link is created | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373954) | Group |
| [`saml_group_links_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/110525) | A SAML Group Link is removed | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373954) | Group |
| [`smartcard_authentication_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/8120) | A user authenticates with smartcard | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/726) | User |
| [`update_approval_rules`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89939) | Updating a merge approval rule | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363092) | Project |
| [`update_compliance_framework`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/74292) | A compliance framework is updated | {{< yes >}} | GitLab [14.6](https://gitlab.com/gitlab-org/gitlab/-/issues/340649) | Group |
| [`update_compliance_requirement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/169485) | A compliance framework requirement is updated. | {{< yes >}} | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/470695) | Group |
| [`update_project_compliance_violation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195768) | Project compliance violation is updated | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/542343) | Project |
| [`update_status_check`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | An external status check is updated | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/355805) | Project |
| [`updated_compliance_requirement_control`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177557) | Compliance requirement control updated. | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/512381) | Group |

### Consumables cost management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`usage_billing_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216009) | The namespace owner changes GitLab Credits dashboard settings | {{< yes >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/580868) | Group |

### Container registry

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`container_repository_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156037) | A container repository is first pushed to the registry | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`container_repository_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967) | A project's container registry is deleted | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`container_repository_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152967) | A project's container repository is marked for deletion | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`container_repository_tags_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156066) | A project's container repository tag is deleted | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/362290) | Project |
| [`project_feature_container_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's container registry access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369303) | Project |

### Continuous delivery

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`deploy_key_added`](https://gitlab.com/gitlab-org/gitlab/-/commit/08586a616909c7f9efe2210c2b74fd3422d4eb62) | A deploy key is added | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_key_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92219) | A deploy key is removed | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | A deploy token is created | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | A deploy token fails to create | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | A deploy token is destroyed | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deploy_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89391) | A project deploy token is revoked | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`deployment_approved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153375) | A deployment is approved | {{< yes >}} | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/456685) | Project |
| [`deployment_rejected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/153375) | A deployment is rejected | {{< yes >}} | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/456685) | Project |
| [`deployment_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/156111) | A deployment to a protected environment is started | {{< yes >}} | GitLab [17.2](https://gitlab.com/gitlab-org/gitlab/-/issues/456687) | Project |
| [`group_deploy_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | A group deploy token is created | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_deploy_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | Creating a group deploy token failed | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_deploy_token_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | A group deploy token is destroyed | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_deploy_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/93091) | A group deploy token is revoked | {{< yes >}} | GitLab [15.3](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |

### Continuous integration

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`allow_merge_on_skipped_pipeline_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/83922) | Skipped pipelines are considered successful setting is updated | {{< yes >}} | GitLab [14.10](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`ci_group_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | A CI/CD variable is created for a group | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Group |
| [`ci_group_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | A CI/CD variable is deleted for a group | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Group |
| [`ci_group_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | A CI/CD variable is updated for a group | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Group |
| [`ci_instance_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | A CI/CD variable is created for an instance | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | Instance |
| [`ci_instance_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | A CI/CD variable is deleted for an instance | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | Instance |
| [`ci_instance_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131882) | A CI/CD variable is updated for an instance | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/8070) | Instance |
| [`ci_variable_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | A CI/CD variable is created for a project | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Project |
| [`ci_variable_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | A CI/CD variable is deleted for a project | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Project |
| [`ci_variable_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/91983) | A CI/CD variable is updated for a project | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363090) | Project |
| [`destroy_pipeline`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/135255) | A pipeline is deleted | {{< yes >}} | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/339041) | Project |
| [`multi_project_downstream_pipeline_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/168626) | Multi project downstream pipeline is created | {{< no >}} | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/481325) | Project |
| [`project_cicd_merge_pipelines_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107428) | The CI/CD merge pipelines setting for a project is updated | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369317) | Project |

### Delivery

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_releases_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's releases access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369308) | Project |

### Deployment management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`cluster_agent_create_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | A user attempts to create a cluster agent but it failed | {{< yes >}} | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | A user creates a cluster agent | {{< yes >}} | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_delete_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | A user attempts to delete a cluster agent but it failed | {{< yes >}} | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159593) | A user deletes a cluster agent | {{< yes >}} | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/462749) | Project |
| [`cluster_agent_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112036) | A user creates a cluster agent token | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/382133) | Project |
| [`cluster_agent_token_revoked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112036) | A user revokes a cluster agent token | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/382133) | Project |

### Dora metrics

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_metrics_dashboard_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's metrics dashboard access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | Project |

### Duo agent platform

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`duo_session_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216689) | Duo session is created | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/issues/581004) | Project |
| [`duo_session_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216689) | Duo session has failed | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/issues/581004) | Project |
| [`duo_session_finished`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216689) | Duo session is finished | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/issues/581004) | Project |
| [`duo_session_resumed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/222303) | Duo session is resumed | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/issues/581004) | Project |
| [`duo_session_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216689) | Duo session is started | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/issues/581004) | Project |
| [`duo_session_stopped`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/216689) | Duo session is stopped | {{< yes >}} | GitLab [18.8](https://gitlab.com/gitlab-org/gitlab/-/issues/581004) | Project |
| [`api_request_access_with_scope`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/172548) | A subset of API requests authenticated by a token with an audited scope | {{< yes >}} | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/499461) | User |

### Dynamic application security testing

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`dast_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | A dynamic application security testing profile is created | {{< yes >}} | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | A dynamic application security profile is removed | {{< yes >}} | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_profile_schedule_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/68046) | A dynamic application security testing profile schedule is created | {{< yes >}} | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/330308) | Project |
| [`dast_profile_schedule_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/66445) | A dynamic application security testing profile schedule is updated | {{< yes >}} | GitLab [14.3](https://gitlab.com/gitlab-org/gitlab/-/issues/330308) | Project |
| [`dast_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62604) | A dynamic application security profile is updated | {{< yes >}} | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_scanner_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | A dynamic application security testing scanner profile is created | {{< yes >}} | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_scanner_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | A dynamic application security testing scanner profile is removed | {{< yes >}} | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_scanner_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62007) | A dynamic application security testing scanner profile is updated | {{< yes >}} | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_site_profile_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | A dynamic application security testing site profile is created | {{< yes >}} | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_site_profile_destroy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | A dynamic application security testing site profile is removed | {{< yes >}} | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |
| [`dast_site_profile_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/62465) | A dynamic application security testing site profile is updated | {{< yes >}} | GitLab [14.0](https://gitlab.com/gitlab-org/gitlab/-/issues/217872) | Project |

### Environment management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`environment_protected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108247) | A protected environment is created | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/216164) | Group, Project |
| [`environment_unprotected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/108247) | A protected environment is unprotected | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/216164) | Group, Project |
| [`project_feature_environments_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's environments access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369307) | Project |
| [`protected_environment_approval_rule_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | An approval rule is added to a protected environment | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |
| [`protected_environment_approval_rule_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | An approval rule is removed from a protected environment | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Project, Group |
| [`protected_environment_approval_rule_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | An approval rule of a protected environment is updated | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Project, Group |
| [`protected_environment_deploy_access_level_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | A deploy access level is added to a protected environment | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |
| [`protected_environment_deploy_access_level_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | A deploy access level is removed from a protected environment | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |
| [`protected_environment_deploy_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | A deploy access level of a protected environment is updated | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Project |
| [`protected_environment_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/131484) | A protected environment is updated | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/415603) | Group, Project |

### Feature flags

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_feature_flags_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's feature flags access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369306) | Project |
| [`feature_flag_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | A feature flag is created | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | Project |
| [`feature_flag_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | A feature flag is deleted | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | Project |
| [`feature_flag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113453) | A feature flag is updated | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374109) | Project |

### Fleet visibility

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`ci_runner_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173885) | Triggered when a runner is created | {{< yes >}} | GitLab [17.8](https://gitlab.com/gitlab-org/gitlab/-/issues/503315) | Instance, Group, Project |
| [`ci_runner_usage_export`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/139578) | A runner usage report is generated | {{< yes >}} | GitLab [16.8](https://gitlab.com/gitlab-org/gitlab/-/issues/426560) | Instance |
| [`ci_runners_bulk_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173886) | Runners are deleted in bulk | {{< yes >}} | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/503315) | User |

### Fuzz testing

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`coverage_fuzzing_corpus_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/71992) | A corpus action is added | {{< yes >}} | GitLab [14.5](https://gitlab.com/gitlab-org/gitlab/-/issues/341485) | Project |

### Groups and projects

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`create_ssh_certificate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556) | An SSH certificate is created | {{< yes >}} | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/427413) | Group |
| [`delete_ssh_certificate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/134556) | An SSH certificate is deleted | {{< yes >}} | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/427413) | Group |
| [`emails_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Enable email notifications is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`enabled_git_access_protocol_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Enabled Git access protocols is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`enforce_ssh_certificates_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Enforce SSH Certificates is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_archived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199419) | A group is archived | {{< yes >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/520013) | Group |
| [`group_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121005) | A group is created | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/411595) | Group |
| [`group_deletion_marked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | A group is marked for deletion | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | Group |
| [`group_description_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973/) | Group description is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | A group is destroyed | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | Group |
| [`group_lfs_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | LFS enabled for a group is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | Group |
| [`group_membership_lock_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | Membership lock for a group is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | Group |
| [`group_mentions_disabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | A group's setting to notify group members on group mention is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's name is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369320) | Group |
| [`group_path_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's path is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369321) | Group |
| [`group_project_creation_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's project creation level is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369327) | Group |
| [`group_request_access_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's request access enabled is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369323) | Group |
| [`group_restored`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116986) | A group is restored | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374106) | Group |
| [`group_share_with_group_link_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | You invite a group to another group by using the group's membership page | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | Group |
| [`group_share_with_group_link_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | You remove a group from another group by using the group's membership page | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | Group |
| [`group_share_with_group_link_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112719) | You update a group's access settings to another group by using the group's membership page | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/327909) | Group |
| [`group_shared_with_group_lock_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973/) | Group can be shared with other group setting is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_unarchived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199419) | A group is unarchived | {{< yes >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/520013) | Group |
| [`group_visibility_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's visibility level is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369322) | Group |
| [`prevent_sharing_groups_outside_hierarchy_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | A group's setting to Members cannot invite groups outside of group and its subgroup updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`project_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117543) | A project is created | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_description_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/128978) | A project's description is updated | {{< no >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/377769) | Project |
| [`project_feature_operations_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's operation access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369300) | Project |
| [`project_feature_requirements_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's requirements access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369301) | Project |
| [`project_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0b52247e717cf84bc7b248d817f8baa55b18a4) | A project has its name updated | {{< yes >}} | GitLab [10.2](https://gitlab.com/gitlab-org/gitlab/-/commit/8c0b52247e717cf84bc7b248d817f8baa55b18a4) | Project |
| [`project_namespace_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's namespace is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_path_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/100770) | A project's path is updated | {{< yes >}} | GitLab [15.5](https://gitlab.com/gitlab-org/gitlab/-/issues/369271) | Project |
| [`project_topics_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154158) | A project's topics assignments are changed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/343204) | Project |
| [`project_unarchived`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117528) | A project is unarchived | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_visibility_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | A project's visibility level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`remove_dormant_members_period_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Days of inactivity before removal is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`remove_dormant_members_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Dormant members is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |

### Importers

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`direct_transfer_relation_export_batch_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872) | Direct Transfer relation export batch downloaded | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/441977) | Group, Project |
| [`direct_transfer_relation_export_downloaded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872) | Direct Transfer relation export downloaded | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/441977) | Group, Project |
| [`direct_transfer_relations_export_initiated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194872) | Direct Transfer relations export initiated | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/441977) | Group, Project |
| [`group_export_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/TODO) | A group file export is created | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/294168) | Group |
| [`project_export_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/TODO) | A project file export is created | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/294168) | Project |

### Incident management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`incident_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An incident is closed using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`incident_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An incident is created using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`incident_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An incident is reopened using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |

### Merge trains

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_cicd_merge_trains_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107428) | The CI/CD merge trains settings for a project is updated | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369317) | Project |

### MLOps

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_model_experiments_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121027) | A project's model experiments access level is updated | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/412384) | Project |
| [`ml_model_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011) | ML model is created | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`ml_model_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165011) | ML model destroyed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`ml_model_version_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145) | ML model version is created | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`ml_model_version_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165145) | ML model version destroyed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Project |
| [`project_feature_model_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/138399) | Model registry access level was updated | {{< yes >}} | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/412734) | Project |

### Not categorized

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`experiment_features_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118222) | Enabling experiment AI features setting is toggled | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/404856/) | Group |

### Observability

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_monitor_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's monitor access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369304) | Project |

### Package registry

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`package_registry_package_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178181) | A package was deleted from GitLab package registry. Available only when the namespace's package setting `audit_events_enabled` is true. | {{< yes >}} | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/329588) | Project, Group |
| [`package_registry_package_published`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/178181) | A package was published to GitLab package registry. Available only when the namespace's package setting `audit_events_enabled` is true. | {{< yes >}} | GitLab [17.9](https://gitlab.com/gitlab-org/gitlab/-/issues/329588) | Project, Group |
| [`project_feature_package_registry_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's package registry access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369296) | Project |
| [`project_packages_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/7962) | The setting that controls packages for a project is updated | {{< yes >}} | GitLab [11.5](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |

### Pages

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_pages_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's page access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369297) | Project |

### Permissions

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`custom_admin_role_assigned_to_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186570) | A custom admin role is assigned to a user | {{< yes >}} | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/507958) | User |
| [`custom_admin_role_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188367) | A custom admin role is created | {{< yes >}} | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/536131) | Instance |
| [`custom_admin_role_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188367) | A custom admin role is deleted | {{< yes >}} | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/536131) | Instance |
| [`custom_admin_role_unassigned_from_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/186570) | A custom admin role is unassigned from a user | {{< yes >}} | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/507958) | User |
| [`custom_admin_role_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/188367) | A custom admin role is updated | {{< yes >}} | GitLab [18.0](https://gitlab.com/gitlab-org/gitlab/-/issues/536131) | Instance |
| [`member_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | A member is added and assigned a default or custom role | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | Group, Project |
| [`member_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | A member is removed | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | Group, Project |
| [`member_role_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/137087) | A custom role is created | {{< yes >}} | GitLab [16.7](https://gitlab.com/gitlab-org/gitlab/-/issues/388934) | Group, Instance |
| [`member_role_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141630) | A custom role is deleted | {{< yes >}} | GitLab [16.9](https://gitlab.com/gitlab-org/gitlab/-/issues/437672) | Group, Instance |
| [`member_role_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/141630) | A custom role is updated | {{< yes >}} | GitLab [16.9](https://gitlab.com/gitlab-org/gitlab/-/issues/437672) | Group, Instance |
| [`member_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/109711) | A member's default or custom role or expiration date is updated | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/374112) | Group, Project |

### Portfolio management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`delete_epic`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | An epic is successfully deleted | {{< no >}} | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Group |
| [`epic_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An epic is closed by a group access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Group |
| [`epic_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An epic is created by a group access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Group |
| [`epic_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An epic is reopened by a group access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Group |

### Product analytics data management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`product_analytics_settings_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154101) | Product analytics settings are changed | {{< yes >}} | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/463318) | Project |

### Quality management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`test_case_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | A test case is closed using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`test_case_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | A test case is created using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`test_case_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | A test case is reopened using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |

### Runner

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`allow_runner_registration_token_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Allow members of projects and groups to create runners with runner registration tokens is updated | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group, Project |
| [`ci_runner_assigned_to_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81508) | A runner is assigned to a project | {{< yes >}} | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/349542) | Project |
| [`ci_runner_registered`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/77109) | An instance, group, or project runner is registered | {{< yes >}} | GitLab [14.8](https://gitlab.com/gitlab-org/gitlab/-/issues/359958) | Instance, Group, Project |
| [`ci_runner_token_reset`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/85535) | A runner's token is reset | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/355637) | Instance, Group, Project |
| [`ci_runner_unassigned_from_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/81540) | A runner is unassigned from a project | {{< yes >}} | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/349542) | Project |
| [`ci_runner_unregistered`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79754) | An instance, group, or project runner is unregistered | {{< yes >}} | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/349540) | Instance, Group, Project |
| [`group_shared_runners_minutes_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's shared runners minutes limit is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369324) | Group |
| [`runner_registration_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Runner registration is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`set_runner_associated_projects`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/97666) | Associated projects are successfully assigned to a CI/CD runner | {{< yes >}} | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/359958) | Project |

### Seat cost management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`seat_control_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Seat control is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |

### Secret detection

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`group_secret_push_protection_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174412) | Secret push protection is enabled or disabled for a group and its child groups and projects, except those projects specified as excluded | {{< yes >}} | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/502829) | Group |
| [`group_validity_checks_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205405) | Validity checks is enabled or disabled for a group and its child groups and projects, except those projects specified as excluded | {{< yes >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/570740) | Group |
| [`project_security_exclusion_applied`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | A project security exclusion is applied in one of the security scanners | {{< yes >}} | GitLab [17.6](https://gitlab.com/gitlab-org/gitlab/-/issues/492465) | Project |
| [`project_security_exclusion_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | A project security exclusion is created | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | Project |
| [`project_security_exclusion_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | A project security exclusion is deleted | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | Project |
| [`project_security_exclusion_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166511) | A project security exclusion is updated | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/492464) | Project |
| [`project_security_setting_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150767) | A project's security setting is updated | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/457024) | Project |
| [`skip_secret_push_protection`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/147855) | Secret push protection is skipped by the user | {{< yes >}} | GitLab [16.11](https://gitlab.com/gitlab-org/gitlab/-/issues/441185) | Project |

### Secrets management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`user_authenticated_using_job_token`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164546) | A user is authenticated using job token | {{< no >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/481325) | Project |
| [`secrets_manager_create_group_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218603) | This event is triggered when a group level secret is created by a user | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/work_items/573328) | Group |
| [`secrets_manager_create_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | This event is triggered when a project level secret is created by a user | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | Project |
| [`secrets_manager_delete_group_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218603) | This event is triggered when a group level secret is deleted by a user | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/work_items/573328) | Group |
| [`secrets_manager_delete_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | This event is triggered when a project level secret is deleted by a user | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | Project |
| [`secrets_manager_read_group_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218603) | This event is triggered when a CI pipeline job reads the value of a group level secret from Openbao | {{< no >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/work_items/573328) | Group |
| [`secrets_manager_read_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | This event is triggered when a CI pipeline job reads the value of a project level secret from Openbao | {{< no >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | Project |
| [`secrets_manager_update_group_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/218603) | This event is triggered when a group level secret is updated by a user | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/work_items/573328) | Group |
| [`secrets_manager_update_project_secret`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205780) | This event is triggered when a project level secret is updated by a user | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/554056) | Project |

### Security policy management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`policy_project_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102154) | The security policy project is updated for a project | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/377877) | Group, Project |
| [`policy_warn_mode_group_protected_branch_modification_override`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/213392) | A group is affected by a warn mode policy that prevents modification of the group's protected branches if the policy changes from warn mode to strictly enforced. | {{< no >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/580966) | Group |
| [`policy_warn_mode_merge_request_approval`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/210351) | A merge request approval would have been prevented by a security policy in warn mode. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/563867) | Project |
| [`policy_warn_mode_merge_request_approval_settings_overrides`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212756) | A merge request's target branch is affected by a policy in warn mode that sets more restrictive approval settings if the policy changes from warn mode to enforced. | {{< no >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/580797) | Project |
| [`policy_warn_mode_push_settings_overrides`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209501) | Approval settings from a security policy in warn mode will override branch protections | {{< no >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/563867) | Project |
| [`security_policy_access_token_push_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196249) | Branch push that is blocked by a security policy is bypassed for configured access token | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549644) | Project |
| [`security_policy_create`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192797) | A security policy is created | {{< yes >}} | GitLab [18.1](https://gitlab.com/gitlab-org/gitlab/-/issues/539230) | Project |
| [`security_policy_delete`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192797) | A security policy is deleted | {{< yes >}} | GitLab [18.1](https://gitlab.com/gitlab-org/gitlab/-/issues/539230) | Project |
| [`security_policy_limit_exceeded`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196005) | Enabled policies count exceeded the maximum allowed limit for policy type | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/550891) | Project |
| [`security_policy_merge_request_merged_with_policy_violations`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195775) | A merge request merged with security policy violations | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/549813) | Project |
| [`security_policy_pipeline_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196628) | A pipeline with security policy jobs failed | {{< no >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/539232) | Project |
| [`security_policy_pipeline_skipped`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195325) | A security policy pipeline is skipped | {{< no >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/539232) | Project |
| [`security_policy_scheduled_scans_not_enforced`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201822) | A scheduled pipeline with security policy could not be created | {{< no >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/561047) | Project |
| [`security_policy_service_account_push_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196249) | Branch push that is blocked by a security policy is bypassed for configured service account | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549644) | Project |
| [`security_policy_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/192797) | A security policy is updated | {{< yes >}} | GitLab [18.1](https://gitlab.com/gitlab-org/gitlab/-/issues/539230) | Project |
| [`security_policy_user_push_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/201001) | Branch push that is blocked by a security policy is bypassed for configured users | {{< yes >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/549797) | Project |
| [`security_policy_violations_detected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193482) | Security policy violation is detected in the merge request | {{< no >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/549811) | Project |
| [`security_policy_violations_resolved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/193482) | Security policy violations are resolved in the merge request | {{< no >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549812) | Project |
| [`security_policy_yaml_invalidated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/196721) | The policy YAML is invalidated in security policy project | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/work_items/550892) | Project |
| [`status_check_response_update`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/189293) | A user updates external status check response for merge request | {{< no >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/413535) | Project |
| [`merge_request_branch_bypassed_by_security_policy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195942) | The merge request's approval is bypassed by the branches configured in the security policy | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/549646) | Project |
| [`merge_request_merged_with_dismissed_security_policy`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205857) | When a merge request violated a security policy in warn-mode that was dismissed and the MR was merged | {{< yes >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/569628) | Project |
| [`security_policy_merge_request_bypass`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205601) | A security policy is bypassed for a merge request | {{< yes >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/549797) | Project |

### Security risk management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`security_attribute_attached_to_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security attribute is attached to a project | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Project |
| [`security_attribute_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security attribute is created | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Group |
| [`security_attribute_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security attribute is deleted | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Group |
| [`security_attribute_detached_from_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security attribute is detached from a project | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Project |
| [`security_attribute_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security attribute is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Group |
| [`security_category_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security category is created | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Group |
| [`security_category_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security category is deleted | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Group |
| [`security_category_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209118) | A security category is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/568959) | Group |
| [`security_scan_profile_attached_to_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/219378) | A security scan profile is attached to a project | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/issues/582824) | Project |
| [`security_scan_profile_detached_from_project`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/219378) | A security scan profile is detached from a project | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/issues/582824) | Project |

### Security testing configuration

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`vulnerability_severity_override`](https://gitlab.com/gitlab-org/gitlab/-/issues/515327) | When user overrides vulnerability severity | {{< yes >}} | GitLab [17.10](https://gitlab.com/gitlab-org/gitlab/-/issues/515327) | Project |

### Self-hosted models

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`model_selection_feature_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/194862) | A model selection feature had its configuration changed | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/547982) | Instance, Group, Project, User |
| [`self_hosted_model_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165303) | A new self-hosted model configuration was added | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | Instance |
| [`self_hosted_model_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165321) | A new self-hosted model configuration was destroyed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | Instance |
| [`self_hosted_model_feature_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165489) | A self-hosted model feature had its configuration changed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/463215) | Instance |
| [`self_hosted_model_terms_accepted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165480) | Terms for usage of self-hosted models were accepted | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/477999) | Instance |
| [`self_hosted_model_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/165520) | A self-hosted model configuration was updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/483295) | Instance |

### Source code management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`approval_rule_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89939) | A merge request approval rule is created | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363092) | Project |
| [`approval_rule_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/82297) | A merge request approval rule is deleted | {{< yes >}} | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/329514) | Project |
| [`default_branch_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Default branch name for the group repository is changed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`group_push_rules_author_email_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | A group's push rules settings is changed for author email regex | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369343) | Group |
| [`group_push_rules_branch_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | A group's push rules settings is changed for branch name regex | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369340) | Group |
| [`group_push_rules_commit_committer_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | A group's push rule setting is updated for reject unverified users | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_commit_message_negative_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | A group's push rules settings is changed for commit message negative regex | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369342) | Group |
| [`group_push_rules_commit_message_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | A group's push rules settings is changed for commit message regex | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369341) | Group |
| [`group_push_rules_file_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | A group's push rules settings is changed for filename regex | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369344) | Group |
| [`group_push_rules_max_file_size_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/105791) | A group's push rules settings is changed for max file size | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369345) | Group |
| [`group_push_rules_prevent_secrets_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | A group's push rule setting is updated to prevent pushing secret files | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_deny_delete_tag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | A group's push rule setting is updated to deny deletion of tags using Git push | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_member_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | A group's push rule setting is updated to check if commit author is a GitLab user | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_non_dco_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | A group's push rule setting is updated for reject non DCO certified commits | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_push_rules_reject_unsigned_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86046) | A group push's rule setting is updated for reject unsigned commits | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/227629) | Group |
| [`group_repository_size_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's repository size limit is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369322) | Group |
| [`merge_commit_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107533) | Merge commit template is updated | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369314) | Project |
| [`merged_merge_request_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118793) | A merged merge request is deleted | {{< no >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/408288) | Project |
| [`merged_merge_request_deletion_started`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/118793) | A merged merge request's deletion is started | {{< no >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/408288) | Project |
| [`prevent_forking_outside_group_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting for Prevent forking outside current group is changed | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`project_default_branch_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117543) | Default branch of a project's repository is updated | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/374105) | Project |
| [`project_disable_overriding_approvers_per_merge_request_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | The disable overriding approvers per MR setting for a project is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369288) | Project |
| [`project_feature_builds_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's builds access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369294) | Project |
| [`project_feature_forking_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's feature forking access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369290) | Project |
| [`project_feature_merge_requests_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's merge request access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | Project |
| [`project_feature_repository_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's repository access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369295) | Project |
| [`project_feature_snippets_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's snippet access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369293) | Project |
| [`project_fork_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90916) | A project is forked | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/90916) | Project |
| [`project_fork_relationship_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/101017) | A project's fork relationship is successfully removed | {{< yes >}} | GitLab [15.6](https://gitlab.com/gitlab-org/gitlab/-/issues/272532) | Project |
| [`project_printing_merge_request_link_enabled_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | The setting for projects for enabling printing merge request link is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369283) | Project |
| [`project_push_rules_author_email_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for author email regex is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_branch_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for branch name regex is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_commit_committer_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/132157) | A project's push rule setting for reject unverified users is updated | {{< yes >}} | GitLab [16.5](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_commit_message_negative_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for commit message negative regex is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_commit_message_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for commit message regex is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_file_name_regex_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for file name regex is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_max_file_size_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for maximum file size is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_prevent_secrets_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for preventing secrets is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_reject_deny_delete_tag_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for rejecting tag deletion is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_reject_member_check_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for member check is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_reject_non_dco_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for rejecting non-DCO commits is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_push_rules_reject_unsigned_commits_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209932) | A project's push rule setting for rejecting unsigned commits is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/268116) | Project |
| [`project_repository_size_limit_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106652) | The repository size limit of a project is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369274) | Project |
| [`protected_branch_code_owner_approval_required_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107530) | The protected branch code owner approval required setting is updated | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369318) | Project |
| [`protected_branch_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92074) | A protected branch is created | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363091) | Project |
| [`protected_branch_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92074) | A protected branch is removed | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363091) | Project |
| [`protected_branch_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107530) | The setting for protected branches is updated | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369318) | Project |
| [`repository_git_operation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/76719) | Authenticated users push, pull, or clone a project using SSH, HTTP(S), or the UI | {{< no >}} | GitLab [14.9](https://gitlab.com/gitlab-org/gitlab/-/issues/373950) | Project |
| [`require_reauthentication_to_approve_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/150710) | The setting for requiring reauthentication for merge request approvals is updated | {{< yes >}} | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/431346) | Group, Project |
| [`squash_commit_template_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/107533) | The merge request squash commit template for a project is updated | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369314) | Project |
| [`squash_option_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/84624) | Squash option setting is updated | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/301124) | Project |
| [`manually_trigger_housekeeping`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/112095) | Manually triggering housekeeping via API or admin UI | {{< yes >}} | GitLab [15.9](https://gitlab.com/gitlab-org/gitlab/-/issues/390761) | Project |
| [`project_blobs_removal`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152522) | Removing blobs by using the GraphQL API or project settings UI | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/450701) | Project |
| [`project_text_replacement`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/152522) | Replacing text by using the GraphQL API or project settings UI | {{< yes >}} | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/450701) | Project |

### System access

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`allow_mfa_for_subgroups_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting for Subgroups can set up their own two-factor authentication rules updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`allowed_email_domain_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/166105) | Group setting allowed email domain entry is updated | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`application_setting_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124639) | An application setting is updated | {{< yes >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/282428) | Instance |
| [`disable_personal_access_tokens_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Disable personal access tokens is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`disable_ssh_keys_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/205020) | Setting Disable SSH Keys is updated | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/30343) | Group |
| [`email_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114546) | An email is created | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`email_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/114546) | An email is destroyed | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`group_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | A group access token is created | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_access_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Creating a group access token failed | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_access_token_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | A group access token is deleted | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_access_token_deletion_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Deleting a group access token failed | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Group |
| [`group_require_two_factor_authentication_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's require two factor authentication setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369325) | Group |
| [`group_two_factor_grace_period_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106079) | A group's two factor grace period is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369326) | Group |
| [`ip_restrictions_changed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/86037) | Any changes in the IP allowlist | {{< yes >}} | GitLab [15.0](https://gitlab.com/gitlab-org/gitlab/-/issues/358986) | Group |
| [`login_failed_with_otp_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | Sign-in fails because of an incorrect OTP | {{< yes >}} | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | User |
| [`login_failed_with_standard_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | Sign-in to GitLab fails with standard authentication, such as password | {{< yes >}} | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | Instance |
| [`login_failed_with_webauthn_authentication`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129595) | Sign-in fails when using a WebAuthn device | {{< yes >}} | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377758) | User |
| [`new_user_signups_cap_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Number of users for user cap is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`project_access_token_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | A project access token is created | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`project_access_token_creation_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Creating a project access token fails | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`project_access_token_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | A project access token is deleted | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`project_access_token_deletion_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/92225) | Deleting a project access token fails | {{< yes >}} | GitLab [15.2](https://gitlab.com/gitlab-org/gitlab/-/issues/363087) | Project |
| [`resource_access_token_creation_allowed_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting for Users can create project access tokens and group access tokens in this group is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group, Project |
| [`service_access_tokens_expiration_enforced_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164973) | Setting Service account token expiration is updated | {{< yes >}} | GitLab [17.4](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | Group |
| [`update_mismatched_group_saml_extern_uid`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104791) | The external UID is changed on a SAML identity | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/382256) | User |
| [`user_access_locked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124169) | User access to the instance is locked | {{< yes >}} | GitLab [16.2](https://gitlab.com/gitlab-org/modelops/anti-abuse/team-tasks/-/issues/244) | User |
| [`user_access_unlocked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/124973) | User access to the instance is unlocked | {{< yes >}} | GitLab [16.2](https://gitlab.com/gitlab-org/modelops/anti-abuse/team-tasks/-/issues/244) | User |
| [`user_disable_passkey`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/214530) | A user disables passkey. Group scope is only available for enterprise users. | {{< yes >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/569463) | User, Group |
| [`user_disable_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/89598) | A user disables two factor authentication. Group scope was [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/171988) in GitLab 17.6. | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/238177) | User, Group |
| [`user_enable_admin_mode`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/104754) | Admin Mode enabled | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/362101) | User |
| [`user_enable_passkey`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/214530) | A user enables passkey. Group scope is only available for enterprise users. | {{< yes >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/569463) | User, Group |
| [`user_enable_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/204794) | A user enables two factor authentication. Group scope is only available for enterprise users. | {{< yes >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/work_items/549619) | User, Group |
| [`authenticated_with_ldap`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175763) | User successfully signed in with LDAP | {{< yes >}} | GitLab [17.11](https://gitlab.com/gitlab-org/gitlab/-/issues/509377) | User |
| [`authenticated_with_oauth`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/175763) | User successfully signed in with OAuth | {{< yes >}} | GitLab [17.11](https://gitlab.com/gitlab-org/gitlab/-/issues/509377) | User |
| [`authenticated_with_password`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216) | User successfully signed in with password | {{< yes >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555101) | User |
| [`authenticated_with_two_factor`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216) | User successfully signed in with two-factor authentication | {{< yes >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555101) | User |
| [`authenticated_with_webauthn`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/198216) | User successfully signed in with WebAuthn device | {{< yes >}} | GitLab [18.3](https://gitlab.com/gitlab-org/gitlab/-/issues/555101) | User |
| [`step_up_auth_required_oauth_provider_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/199423) | Step-up authentication OAuth provider requirement is updated | {{< yes >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/556943) | Group |

### Team planning

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`comment_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/120927) | A comment is added to an issue or a merge request when using a project access token | {{< no >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`comment_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489) | A comment is added to an issue, merge request, or other objects | {{< no >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/3706) | Project, Group |
| [`comment_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489) | A comment is deleted | {{< no >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/3706) | Project, Group |
| [`comment_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/206489) | A comment is updated | {{< no >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/3706) | Project, Group |
| [`delete_issue`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | An issue is successfully deleted | {{< no >}} | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Project |
| [`delete_work_item`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/96773) | A work item is successfully deleted | {{< no >}} | GitLab [15.4](https://gitlab.com/gitlab-org/gitlab/-/issues/370487) | Project |
| [`issue_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An issue is closed using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`issue_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An issue is created using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`issue_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | An issue is reopened using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`project_feature_issues_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's issues access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369289) | Project |
| [`task_closed_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | A task is closed using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`task_created_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | A task is created using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |
| [`task_reopened_by_project_bot`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121485) | A task is reopened using a project access token | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323299) | Project |

### User management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`authenticated_with_group_saml`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/28575) | Successfully signing in with SAML authentication | {{< yes >}} | GitLab [12.10](https://gitlab.com/gitlab-org/gitlab/-/issues/35710) | Group |
| [`ban_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116103) | A user is banned, unbanned, blocked, or unblocked | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | User |
| [`change_membership_state`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/87924) | A user's membership is updated | {{< yes >}} | GitLab [15.1](https://gitlab.com/gitlab-org/gitlab/-/issues/362200) | Group |
| [`inactive_scim_user_cannot_be_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/173879) | A user cannot be added to a group during SAML authentication when their SCIM identity is inactive | {{< yes >}} | GitLab [17.7](https://gitlab.com/gitlab-org/gitlab/-/issues/422582) | Group |
| [`password_reset_failed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129079) | A password reset fails for a user | {{< no >}} | GitLab [16.4](https://gitlab.com/gitlab-org/gitlab/-/issues/377762) | User |
| [`unban_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/116221) | A user is unbanned | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | User |
| [`unblock_user`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115727) | A user is banned | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/377620) | User |
| [`user_activate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/121708) | A user is activated | {{< yes >}} | GitLab [16.1](https://gitlab.com/gitlab-org/gitlab/-/issues/13473) | User |
| [`user_approved`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | A user is approved for an instance | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_blocked`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | A user is blocked | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | A user is created | {{< yes >}} | GitLab [15.10](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_deactivate`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/117776) | A user is deactivated | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/13473) | User |
| [`user_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | A user is scheduled for removal from the instance. Group and Project scopes were [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167021) in GitLab 17.5. | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User, Group, Project |
| [`user_email_changed_and_user_signed_in`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106090) | User email changed and user signed in | {{< yes >}} | GitLab [15.8](https://gitlab.com/gitlab-org/gitlab/-/issues/369331) | User |
| [`user_impersonation`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/79340) | An instance administrator starts or stops impersonating a user | {{< yes >}} | GitLab [14.8](https://gitlab.com/gitlab-org/gitlab/-/issues/300961) | User, Group |
| [`user_password_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106086) | A user password is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369330) | User |
| [`user_provisioned_by_scim`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/174040) | A user is provisioned by SCIM | {{< yes >}} | GitLab [17.8](https://gitlab.com/gitlab-org/gitlab/-/issues/423322) | Group |
| [`user_records_migrated_to_ghost`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/203756) | Event triggered when user records are migrated to a ghost user during batch processing | {{< yes >}} | GitLab [18.4](https://gitlab.com/gitlab-org/gitlab/-/issues/567635) | User |
| [`user_rejected`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/113784) | A user registration is rejected | {{< yes >}} | GitLab [15.11](https://gitlab.com/gitlab-org/gitlab/-/issues/374107) | User |
| [`user_external_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/207107) | A user is either flagged as external or has the external flag removed. | {{< yes >}} | GitLab [18.5](https://gitlab.com/gitlab-org/gitlab/-/issues/546230) | User |

### User profile

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`add_ssh_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195379) | An SSH key is added to a user's profile. Group scope is only available for enterprise users. | {{< yes >}} | GitLab [18.2](https://gitlab.com/gitlab-org/gitlab/-/issues/361778) | User, Group |
| [`email_confirmation_sent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129261) | Users add or change an email address and it must be confirmed | {{< no >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/issues/377625) | User |
| [`remove_ssh_key`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65615) | An SSH key is removed from a user's profile. Group scope was [introduced](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/195390) for enterprise users in GitLab 18.2. | {{< yes >}} | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/220127) | User, Group |
| [`user_admin_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/65168) | A user is either made an administrator or removed as an administrator | {{< yes >}} | GitLab [14.1](https://gitlab.com/gitlab-org/gitlab/-/issues/323905) | User |
| [`user_auditor_status_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/136456) | A user is either made an auditor or removed as an auditor | {{< yes >}} | GitLab [16.6](https://gitlab.com/gitlab-org/gitlab/-/issues/430235) | User |
| [`user_email_address_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/2103) | A user updates their email address | {{< yes >}} | GitLab [10.1](https://gitlab.com/gitlab-org/gitlab-ee/issues/1370) | User |
| [`user_name_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/167484) | A user's name is updated | {{< yes >}} | GitLab [17.5](https://gitlab.com/gitlab-org/gitlab/-/issues/486532) | User |
| [`user_profile_visibility_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/187207) | User toggles private profile user setting | {{< no >}} | GitLab [17.11](https://gitlab.com/gitlab-org/gitlab/-/issues/474386) | User |
| [`user_profile_visiblity_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129149) | User toggles private profile user setting (DEPRECATED). Use `user_profile_visibility_updated` instead. | {{< no >}} | GitLab [16.3](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/129149) | User |
| [`user_username_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106086) | A user's username is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369329) | User |

### Value stream management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_analytics_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's analytics access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369299) | Project |

### Verify security

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`secure_ci_job_token_group_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754) | Group added to CI_JOB_TOKEN scope | {{< yes >}} | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/467840) | Project |
| [`secure_ci_job_token_group_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/159754) | Group removed from CI_JOB_TOKEN scope | {{< yes >}} | GitLab [17.3](https://gitlab.com/gitlab-org/gitlab/-/issues/467840) | Project |
| [`secure_ci_job_token_inbound_disabled`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | CI_JOB_TOKEN permissions disabled for inbound | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |
| [`secure_ci_job_token_inbound_enabled`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | CI_JOB_TOKEN permissions enabled for inbound | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |
| [`secure_ci_job_token_project_added`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | Project added to inbound CI_JOB_TOKEN scope | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |
| [`secure_ci_job_token_project_removed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/115350) | Project removed from inbound CI_JOB_TOKEN scope | {{< yes >}} | GitLab [16.0](https://gitlab.com/gitlab-org/gitlab/-/issues/338255) | Project |

### Virtual registry

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`virtual_registries_container_cache_remote_entry_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/220483) | A virtual registry container cache remote entry was deleted | {{< yes >}} | GitLab [18.9](https://gitlab.com/gitlab-org/gitlab/-/work_items/583726) | Group |
| [`virtual_registries_packages_maven_cache_remote_entry_deleted`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/209828) | A virtual registry Maven cache remote entry was deleted | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/548566) | Group |

### Vulnerability management

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_infrastructure_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's infrastructure access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369305) | Project |
| [`remove_vulnerability_false_positive_flag`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/213091) | A user removes a false positive flag from a vulnerability. | {{< yes >}} | GitLab [18.7](https://gitlab.com/gitlab-org/gitlab/-/issues/578903) | Project |

### Webhooks

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`webhook_created`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/154046) | A webhook is created | {{< yes >}} | GitLab [17.1](https://gitlab.com/gitlab-org/gitlab/-/issues/8068) | Project, Group, Instance |
| [`webhook_destroyed`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/102342) | A webhook is destroyed | {{< yes >}} | GitLab [17.0](https://gitlab.com/gitlab-org/gitlab/-/issues/458817) | Project, Group, Instance |

### Wiki

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`project_feature_wiki_access_level_updated`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/106919) | A project's wiki access level setting is updated | {{< yes >}} | GitLab [15.7](https://gitlab.com/gitlab-org/gitlab/-/issues/369292) | Project |

### Workflow catalog

| Type name | Event triggered when | Saved to database | Introduced in | Scope |
|:----------|:---------------------|:------------------|:--------------|:------|
| [`create_ai_catalog_agent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212259) | A user creates an AI Catalog agent. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`create_ai_catalog_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212539) | A user creates an AI Catalog flow. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`create_ai_catalog_third_party_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212625) | A user creates an AI Catalog external agent (formerly third-party flow). | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`delete_ai_catalog_agent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212259) | A user deletes an AI Catalog agent. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`delete_ai_catalog_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212539) | A user deletes an AI Catalog flow. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`delete_ai_catalog_third_party_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212625) | A user deletes an AI Catalog external agent (formerly third-party flow). | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`disable_ai_catalog_agent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212259) | A user disables an AI Catalog agent in a project or group. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project, Group |
| [`disable_ai_catalog_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212539) | A user disables an AI Catalog flow in a project or group. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project, Group |
| [`disable_ai_catalog_third_party_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212625) | A user disables an AI Catalog external agent (formerly third-party flow) in a project or group. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project, Group |
| [`enable_ai_catalog_agent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212259) | A user enables an AI Catalog agent in a project or group. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project, Group |
| [`enable_ai_catalog_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212539) | A user enables an AI Catalog flow in a project or group. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project, Group |
| [`enable_ai_catalog_third_party_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212625) | A user enables an AI Catalog external agent (formerly third-party flow) in a project or group. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project, Group |
| [`update_ai_catalog_agent`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212259) | A user updates an AI Catalog agent. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`update_ai_catalog_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212539) | A user updates an AI Catalog flow. | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
| [`update_ai_catalog_third_party_flow`](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/212625) | A user updates an AI Catalog external agent (formerly third-party flow). | {{< yes >}} | GitLab [18.6](https://gitlab.com/gitlab-org/gitlab/-/issues/566901) | Project |
