/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.text;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.reporting.ReportRenderer;

public class DefaultTextReportBuilder
implements TextReportBuilder {
    public static final String SEPARATOR = "------------------------------------------------------------";
    public static final String INDENT = "    ";
    private int depth;
    private boolean hasTitledItems;
    private StyledTextOutput textOutput;
    private final FileResolver fileResolver;

    public DefaultTextReportBuilder(StyledTextOutput textOutput, FileResolver fileResolver) {
        this.textOutput = textOutput;
        this.fileResolver = fileResolver;
    }

    @Override
    public void item(String title, String value) {
        this.hasTitledItems = true;
        LinePrefixingStyledTextOutput itemOutput = new LinePrefixingStyledTextOutput(this.textOutput, (CharSequence)INDENT, false);
        itemOutput.append((CharSequence)title).append((CharSequence)": ");
        itemOutput.append((CharSequence)value).println();
    }

    @Override
    public void item(String title, File value) {
        this.item(title, this.fileResolver.resolveForDisplay((Object)value));
    }

    @Override
    public void item(String value) {
        this.hasTitledItems = true;
        this.textOutput.append((CharSequence)value).println();
    }

    @Override
    public void item(String title, Iterable<String> values) {
        this.item(title, Joiner.on((String)", ").join(values));
    }

    @Override
    public void item(File value) {
        this.item(this.fileResolver.resolveForDisplay((Object)value));
    }

    @Override
    public <T> void item(T value, ReportRenderer<T, TextReportBuilder> renderer) {
        this.renderItem((Action<TextReportBuilder>)((Action)textReportBuilder -> {
            try {
                renderer.render(value, textReportBuilder);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }));
    }

    @Override
    public void heading(String heading) {
        if (this.depth == 0) {
            this.textOutput.println().style(StyledTextOutput.Style.Header);
            this.textOutput.println((Object)SEPARATOR);
            this.textOutput.println((Object)heading);
            this.textOutput.text((Object)SEPARATOR);
            this.textOutput.style(StyledTextOutput.Style.Normal);
            this.textOutput.println().println();
        } else if (this.depth == 1) {
            this.writeSubheading(heading);
        } else {
            this.textOutput.println((Object)heading);
            this.textOutput = new LinePrefixingStyledTextOutput(this.textOutput, (CharSequence)INDENT);
        }
        ++this.depth;
    }

    @Override
    public void subheading(String heading) {
        this.writeSubheading(heading);
        if (this.depth == 0) {
            this.depth = 1;
        }
    }

    private void writeSubheading(String heading) {
        this.textOutput.style(StyledTextOutput.Style.Header).println((Object)heading);
        for (int i = 0; i < heading.length(); ++i) {
            this.textOutput.text((Object)"-");
        }
        this.textOutput.style(StyledTextOutput.Style.Normal).println();
    }

    @Override
    public <T> void collection(String title, Collection<? extends T> items, ReportRenderer<T, TextReportBuilder> renderer, String elementsPlural) {
        if (this.depth <= 1 && !this.hasTitledItems) {
            this.writeSubheading(title);
        } else if (this.depth == 2 && !this.hasTitledItems) {
            this.textOutput.println((Object)title);
        } else {
            this.textOutput.append((CharSequence)title).println((Object)":");
        }
        if (items.isEmpty()) {
            this.textOutput.formatln("    No %s.", new Object[]{elementsPlural});
            return;
        }
        this.collection(items, renderer);
    }

    @Override
    public <T> void collection(Iterable<? extends T> items, ReportRenderer<T, TextReportBuilder> renderer) {
        for (Object t : items) {
            this.nested((Action<TextReportBuilder>)((Action)textReportBuilder -> {
                try {
                    renderer.render(t, textReportBuilder);
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException((Throwable)e);
                }
            }));
        }
    }

    @Override
    public StyledTextOutput getOutput() {
        return this.textOutput;
    }

    private void nested(Action<TextReportBuilder> action) {
        boolean indent = this.depth > 1 || this.hasTitledItems;
        this.renderItem((Action<TextReportBuilder>)((Action)textReportBuilder -> {
            if (indent) {
                this.textOutput = new LinePrefixingStyledTextOutput(this.textOutput, (CharSequence)INDENT);
            }
            ++this.depth;
            action.execute(textReportBuilder);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderItem(Action<TextReportBuilder> action) {
        StyledTextOutput original = this.textOutput;
        int originalDepth = this.depth;
        boolean originalItems = this.hasTitledItems;
        try {
            this.hasTitledItems = false;
            action.execute((Object)this);
        }
        finally {
            this.textOutput = original;
            this.depth = originalDepth;
            this.hasTitledItems = originalItems;
        }
    }
}

