/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.api.logging.LogLevel;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.NoOpBuildEventConsumer;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.daemon.client.execution.ClientBuildRequestContext;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.logging.LoggingManagerFactory;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.impl.IsolatableSerializerRegistry;
import org.gradle.jvm.toolchain.internal.ToolchainConfiguration;
import org.gradle.launcher.cli.converter.BuildLayoutConverter;
import org.gradle.launcher.cli.converter.BuildOptionBackedConverter;
import org.gradle.launcher.cli.converter.InitialPropertiesConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.configuration.AllProperties;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.configuration.InitialProperties;
import org.gradle.launcher.daemon.client.DaemonClient;
import org.gradle.launcher.daemon.client.DaemonClientFactory;
import org.gradle.launcher.daemon.client.NotifyDaemonClientExecuter;
import org.gradle.launcher.daemon.configuration.DaemonBuildOptions;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;
import org.gradle.launcher.daemon.toolchain.ToolchainBuildOptions;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.process.internal.streams.SafeStreams;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.build.DefaultBuildEnvironment;
import org.gradle.tooling.internal.consumer.parameters.FailsafeBuildProgressListenerAdapter;
import org.gradle.tooling.internal.gradle.DefaultBuildIdentifier;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionFailureException;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalBuildCancelledException;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;
import org.gradle.tooling.internal.protocol.InternalPhasedAction;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.PhasedActionResultListener;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionException;
import org.gradle.tooling.internal.provider.ConnectionOperationParameters;
import org.gradle.tooling.internal.provider.DaemonBuildActionExecuter;
import org.gradle.tooling.internal.provider.FailsafePhasedActionResultListener;
import org.gradle.tooling.internal.provider.ForwardStdInToThisProcess;
import org.gradle.tooling.internal.provider.LoggingBridgingBuildActionExecuter;
import org.gradle.tooling.internal.provider.PhasedActionEventConsumer;
import org.gradle.tooling.internal.provider.ProblemAdditionalDataRemapper;
import org.gradle.tooling.internal.provider.ProviderStartParameterConverter;
import org.gradle.tooling.internal.provider.RunInProcess;
import org.gradle.tooling.internal.provider.ShutdownCoordinator;
import org.gradle.tooling.internal.provider.StreamedValueConsumer;
import org.gradle.tooling.internal.provider.SystemPropertySetterExecuter;
import org.gradle.tooling.internal.provider.action.BuildModelAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedBuildAction;
import org.gradle.tooling.internal.provider.action.ClientProvidedPhasedAction;
import org.gradle.tooling.internal.provider.action.TestExecutionRequestAction;
import org.gradle.tooling.internal.provider.connection.ProviderConnectionParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;
import org.gradle.tooling.internal.provider.test.ProviderInternalTestExecutionRequest;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.util.GradleVersion;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceScope(value={Scope.Global.class})
public class ProviderConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProviderConnection.class);
    private final PayloadSerializer payloadSerializer;
    private final BuildLayoutFactory buildLayoutFactory;
    private final DaemonClientFactory daemonClientFactory;
    private final BuildActionExecutor<BuildActionParameters, BuildRequestContext> embeddedExecutor;
    private final ServiceRegistry sharedServices;
    private final FileCollectionFactory fileCollectionFactory;
    private final GlobalUserInputReceiver userInputReceiver;
    private final UserInputReader userInputReader;
    private final ShutdownCoordinator shutdownCoordinator;
    private final NotifyDaemonClientExecuter notifyDaemonClientExecuter;
    private final IsolatableSerializerRegistry isolatableSerializerRegistry;
    private GradleVersion consumerVersion;

    public ProviderConnection(ServiceRegistry sharedServices, BuildLayoutFactory buildLayoutFactory, DaemonClientFactory daemonClientFactory, BuildActionExecutor<BuildActionParameters, BuildRequestContext> embeddedExecutor, PayloadSerializer payloadSerializer, FileCollectionFactory fileCollectionFactory, GlobalUserInputReceiver userInputReceiver, UserInputReader userInputReader, ShutdownCoordinator shutdownCoordinator, NotifyDaemonClientExecuter notifyDaemonClientExecuter, IsolatableSerializerRegistry isolatableSerializerRegistry) {
        this.buildLayoutFactory = buildLayoutFactory;
        this.daemonClientFactory = daemonClientFactory;
        this.embeddedExecutor = embeddedExecutor;
        this.payloadSerializer = payloadSerializer;
        this.sharedServices = sharedServices;
        this.fileCollectionFactory = fileCollectionFactory;
        this.userInputReceiver = userInputReceiver;
        this.userInputReader = userInputReader;
        this.shutdownCoordinator = shutdownCoordinator;
        this.notifyDaemonClientExecuter = notifyDaemonClientExecuter;
        this.isolatableSerializerRegistry = isolatableSerializerRegistry;
    }

    public void configure(ProviderConnectionParameters parameters, GradleVersion consumerVersion) {
        this.consumerVersion = consumerVersion;
        LogLevel providerLogLevel = parameters.getVerboseLogging() ? LogLevel.DEBUG : LogLevel.INFO;
        LOGGER.debug("Configuring logging to level: {}", (Object)providerLogLevel);
        LoggingManagerInternal loggingManager = ((LoggingManagerFactory)this.sharedServices.get(LoggingManagerFactory.class)).createLoggingManager();
        loggingManager.setLevelInternal(providerLogLevel);
        loggingManager.start();
    }

    public Object run(String modelName, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        List<String> tasks = providerParameters.getTasks();
        if (modelName.equals(ModelIdentifier.NULL_MODEL) && tasks == null) {
            throw new IllegalArgumentException("No model type or tasks specified.");
        }
        Parameters params = this.initParams(providerParameters);
        if (BuildEnvironment.class.getName().equals(modelName)) {
            if (tasks != null) {
                throw new IllegalArgumentException("Cannot run tasks and fetch the build environment model.");
            }
            return new DefaultBuildEnvironment(new DefaultBuildIdentifier(providerParameters.getProjectDir()), params.buildLayout.getGradleUserHomeDir(), GradleVersion.current().getVersion(), ProviderConnection.reportableJavaHomeForBuild(params), params.daemonParams.getEffectiveJvmArgs());
        }
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion, this.payloadSerializer, this.isolatableSerializerRegistry);
        BuildModelAction action = new BuildModelAction(params.startParameter, modelName, tasks != null, listenerConfig.clientSubscriptions);
        return this.run(action, cancellationToken, listenerConfig, listenerConfig.buildEventConsumer, providerParameters, params);
    }

    private static File reportableJavaHomeForBuild(Parameters params) {
        DaemonParameters daemonParameters = params.daemonParams;
        DaemonJvmCriteria criteria = daemonParameters.getRequestedJvmCriteria();
        if (criteria instanceof DaemonJvmCriteria.Spec) {
            return Jvm.current().getJavaHome();
        }
        if (criteria instanceof DaemonJvmCriteria.JavaHome) {
            return ((DaemonJvmCriteria.JavaHome)criteria).getJavaHome();
        }
        if (criteria instanceof DaemonJvmCriteria.LauncherJvm) {
            return Jvm.current().getJavaHome();
        }
        throw new IllegalStateException("Unknown DaemonJvmCriteria type: " + criteria.getClass().getName());
    }

    public Object run(InternalBuildAction<?> clientAction, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        return this.runClientAction(clientAction, cancellationToken, providerParameters);
    }

    public Object run(InternalBuildActionVersion2<?> clientAction, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        return this.runClientAction(clientAction, cancellationToken, providerParameters);
    }

    public Object runClientAction(Object clientAction, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        List<String> tasks = providerParameters.getTasks();
        SerializedPayload serializedAction = this.payloadSerializer.serialize(clientAction);
        Parameters params = this.initParams(providerParameters);
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion, this.payloadSerializer, this.isolatableSerializerRegistry);
        ClientProvidedBuildAction action = new ClientProvidedBuildAction(startParameter, serializedAction, tasks != null, listenerConfig.clientSubscriptions);
        return this.run(action, cancellationToken, listenerConfig, listenerConfig.buildEventConsumer, providerParameters, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runPhasedAction(InternalPhasedAction clientPhasedAction, PhasedActionResultListener resultListener, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        List<String> tasks = providerParameters.getTasks();
        SerializedPayload serializedAction = this.payloadSerializer.serialize((Object)clientPhasedAction);
        Parameters params = this.initParams(providerParameters);
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        FailsafePhasedActionResultListener failsafePhasedActionResultListener = new FailsafePhasedActionResultListener(resultListener);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion, this.payloadSerializer, this.isolatableSerializerRegistry);
        ClientProvidedPhasedAction action = new ClientProvidedPhasedAction(startParameter, serializedAction, tasks != null, listenerConfig.clientSubscriptions);
        try {
            Object object = this.run(action, cancellationToken, listenerConfig, new PhasedActionEventConsumer(failsafePhasedActionResultListener, this.payloadSerializer, listenerConfig.buildEventConsumer), providerParameters, params);
            return object;
        }
        finally {
            failsafePhasedActionResultListener.rethrowErrors();
        }
    }

    public Object runTests(ProviderInternalTestExecutionRequest testExecutionRequest, BuildCancellationToken cancellationToken, ProviderOperationParameters providerParameters) {
        Parameters params = this.initParams(providerParameters);
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(providerParameters, params.buildLayout, params.properties);
        ProgressListenerConfiguration listenerConfig = ProgressListenerConfiguration.from(providerParameters, this.consumerVersion, this.payloadSerializer, this.isolatableSerializerRegistry);
        TestExecutionRequestAction action = TestExecutionRequestAction.create(listenerConfig.clientSubscriptions, startParameter, testExecutionRequest);
        return this.run(action, cancellationToken, listenerConfig, listenerConfig.buildEventConsumer, providerParameters, params);
    }

    public void notifyDaemonsAboutChangedPaths(List<String> changedPaths, ProviderOperationParameters providerParameters) {
        ServiceRegistry requestSpecificLoggingServices = LoggingServiceRegistry.newNestedLogging();
        Parameters params = this.initParams(providerParameters);
        this.notifyDaemonClientExecuter.execute(requestSpecificLoggingServices, params.daemonParams.getBaseDir(), client -> client.notifyDaemonsAboutChangedPaths(changedPaths));
    }

    public void stopWhenIdle(ProviderOperationParameters providerParameters) {
        ServiceRegistry requestSpecificLoggingServices = LoggingServiceRegistry.newNestedLogging();
        Parameters params = this.initParams(providerParameters);
        this.shutdownCoordinator.stopStartedDaemons(requestSpecificLoggingServices, params.daemonParams.getBaseDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object run(BuildAction action, BuildCancellationToken cancellationToken, ProgressListenerConfiguration progressListenerConfiguration, BuildEventConsumer buildEventConsumer, ProviderOperationParameters providerParameters, Parameters parameters) {
        try {
            BuildActionExecutor<ConnectionOperationParameters, ClientBuildRequestContext> executor = this.createExecutor(providerParameters, parameters);
            boolean interactive = providerParameters.getStandardInput() != null;
            ClientBuildRequestContext context = new ClientBuildRequestContext(new GradleLauncherMetaData(), providerParameters.getStartTime(), interactive, cancellationToken, buildEventConsumer);
            BuildActionResult result = executor.execute(action, (Object)new ConnectionOperationParameters(parameters.daemonParams, parameters.tapiSystemProperties, providerParameters), (Object)context);
            this.throwFailure(result);
            Object object = this.payloadSerializer.deserialize(result.getResult());
            return object;
        }
        finally {
            progressListenerConfiguration.failsafeWrapper.rethrowErrors();
        }
    }

    private void throwFailure(BuildActionResult result) {
        if (result.getException() != null) {
            throw this.map(result, result.getException());
        }
        if (result.getFailure() != null) {
            throw this.map(result, (RuntimeException)this.payloadSerializer.deserialize(result.getFailure()));
        }
    }

    private RuntimeException map(BuildActionResult result, RuntimeException exception) {
        if (result.wasCancelled()) {
            throw new InternalBuildCancelledException((Throwable)exception);
        }
        if (exception instanceof InternalTestExecutionException || exception instanceof InternalBuildActionFailureException || exception instanceof InternalUnsupportedModelException) {
            return exception;
        }
        throw new BuildExceptionVersion1((Throwable)exception);
    }

    private BuildActionExecutor<ConnectionOperationParameters, ClientBuildRequestContext> createExecutor(ProviderOperationParameters operationParameters, Parameters params) {
        RunInProcess executor;
        LoggingManagerInternal loggingManager;
        InputStream standardInput = operationParameters.getStandardInput();
        if (standardInput == null) {
            standardInput = SafeStreams.emptyInput();
        }
        CompositeStoppable stoppable = new CompositeStoppable();
        if (Boolean.TRUE.equals(operationParameters.isEmbedded())) {
            loggingManager = ((LoggingManagerFactory)this.sharedServices.get(LoggingManagerFactory.class)).createLoggingManager();
            loggingManager.captureSystemSources();
            executor = new RunInProcess(new SystemPropertySetterExecuter(new ForwardStdInToThisProcess(this.userInputReceiver, this.userInputReader, standardInput, this.embeddedExecutor)));
        } else {
            ServiceRegistry requestSpecificLogging = LoggingServiceRegistry.newNestedLogging();
            loggingManager = ((LoggingManagerFactory)requestSpecificLogging.get(LoggingManagerFactory.class)).createLoggingManager();
            ServiceRegistry clientServices = this.daemonClientFactory.createBuildClientServices((ServiceLookup)requestSpecificLogging, params.daemonParams, params.requestContext, standardInput, Optional.ofNullable(operationParameters.getBuildProgressListener()));
            stoppable.add((Object)clientServices);
            stoppable.add((Object)requestSpecificLogging);
            executor = (BuildActionExecutor)clientServices.get(DaemonClient.class);
        }
        return new LoggingBridgingBuildActionExecuter(new DaemonBuildActionExecuter(executor), loggingManager, (Stoppable)stoppable);
    }

    private Parameters initParams(ProviderOperationParameters operationParameters) {
        DaemonParameters daemonParams;
        AllProperties properties;
        BuildLayoutResult buildLayoutResult;
        ParsedCommandLine parsedCommandLine;
        block10: {
            CommandLineParser commandLineParser = new CommandLineParser();
            commandLineParser.allowUnknownOptions();
            commandLineParser.allowMixedSubcommandsAndOptions();
            InitialPropertiesConverter initialPropertiesConverter = new InitialPropertiesConverter();
            BuildLayoutConverter buildLayoutConverter = new BuildLayoutConverter();
            initialPropertiesConverter.configure(commandLineParser);
            buildLayoutConverter.configure(commandLineParser);
            parsedCommandLine = commandLineParser.parse(operationParameters.getArguments() == null ? Collections.emptyList() : operationParameters.getArguments());
            InitialProperties initialProperties = initialPropertiesConverter.convert(parsedCommandLine);
            buildLayoutResult = buildLayoutConverter.convert(initialProperties, parsedCommandLine, operationParameters.getProjectDir(), layout -> {
                if (operationParameters.getGradleUserHomeDir() != null) {
                    layout.setGradleUserHomeDir(operationParameters.getGradleUserHomeDir());
                }
                layout.setProjectDir(operationParameters.getProjectDir());
            });
            properties = new LayoutToPropertiesConverter(this.buildLayoutFactory).convert(initialProperties, buildLayoutResult);
            daemonParams = new DaemonParameters(buildLayoutResult.getGradleUserHomeDir(), this.fileCollectionFactory, Collections.emptyMap(), operationParameters.getEnvironmentVariables(null));
            new DaemonBuildOptions().propertiesConverter().convert(properties.getProperties(), (Object)daemonParams);
            if (operationParameters.getDaemonBaseDir() != null) {
                daemonParams.setBaseDir(operationParameters.getDaemonBaseDir());
            }
            try {
                List<String> additionalJvmArguments;
                List<String> baseJvmArguments = operationParameters.getBaseJvmArguments();
                if (baseJvmArguments != null && !baseJvmArguments.isEmpty()) {
                    daemonParams.setJvmArgs(baseJvmArguments);
                }
                if ((additionalJvmArguments = operationParameters.getAdditionalJvmArguments()) != null) {
                    daemonParams.addJvmArgs(additionalJvmArguments);
                }
            }
            catch (UnsupportedMethodException ex) {
                List<String> legacyJvmArguments = operationParameters.getJvmArguments();
                if (legacyJvmArguments == null) break block10;
                daemonParams.setJvmArgs(legacyJvmArguments);
            }
        }
        daemonParams.setRequestedJvmCriteriaFromMap(properties.getDaemonJvmProperties());
        properties = properties.merge(daemonParams.getSystemProperties());
        File javaHome = operationParameters.getJavaHome();
        if (javaHome != null) {
            daemonParams.setRequestedJvmCriteria((DaemonJvmCriteria)new DaemonJvmCriteria.JavaHome(DaemonJvmCriteria.JavaHome.Source.TOOLING_API_CLIENT, javaHome));
        }
        DaemonRequestContext requestContext = daemonParams.toRequestContext();
        if (operationParameters.getDaemonMaxIdleTimeValue() != null && operationParameters.getDaemonMaxIdleTimeUnits() != null) {
            int idleTimeout = (int)operationParameters.getDaemonMaxIdleTimeUnits().toMillis(operationParameters.getDaemonMaxIdleTimeValue().intValue());
            daemonParams.setIdleTimeout(idleTimeout);
        }
        HashMap<String, String> effectiveSystemProperties = new HashMap<String, String>();
        Map<String, String> operationParametersSystemProperties = operationParameters.getSystemProperties(null);
        if (operationParametersSystemProperties != null) {
            effectiveSystemProperties.putAll(operationParametersSystemProperties);
            effectiveSystemProperties.putAll(daemonParams.getMutableAndImmutableSystemProperties());
        } else {
            GUtil.addToMap(effectiveSystemProperties, (Map)System.getProperties());
            effectiveSystemProperties.putAll(daemonParams.getMutableAndImmutableSystemProperties());
        }
        StartParameterInternal startParameter = new ProviderStartParameterConverter().toStartParameter(operationParameters, buildLayoutResult, properties);
        if (requestContext.getJvmCriteria() instanceof DaemonJvmCriteria.Spec) {
            startParameter.setDaemonJvmCriteriaConfigured(true);
        }
        HashMap<String, String> gradlePropertiesAsSeenByToolchains = new HashMap<String, String>();
        gradlePropertiesAsSeenByToolchains.putAll(properties.getProperties());
        gradlePropertiesAsSeenByToolchains.putAll(startParameter.getProjectProperties());
        new BuildOptionBackedConverter<ToolchainConfiguration>(ToolchainBuildOptions.forToolChainConfiguration()).convert(parsedCommandLine, gradlePropertiesAsSeenByToolchains, daemonParams.getToolchainConfiguration());
        return new Parameters(daemonParams, buildLayoutResult, properties, effectiveSystemProperties, startParameter, requestContext);
    }

    private static class Parameters {
        final DaemonParameters daemonParams;
        final BuildLayoutResult buildLayout;
        final AllProperties properties;
        final Map<String, String> tapiSystemProperties;
        final StartParameterInternal startParameter;
        final DaemonRequestContext requestContext;

        public Parameters(DaemonParameters daemonParams, BuildLayoutResult buildLayout, AllProperties properties, Map<String, String> tapiSystemProperties, StartParameterInternal startParameter, DaemonRequestContext requestContext) {
            this.daemonParams = daemonParams;
            this.buildLayout = buildLayout;
            this.properties = properties;
            this.tapiSystemProperties = tapiSystemProperties;
            this.startParameter = startParameter;
            this.requestContext = requestContext;
        }
    }

    @VisibleForTesting
    static final class ProgressListenerConfiguration {
        private static final Map<String, OperationType> OPERATION_TYPE_MAPPING = ImmutableMap.builderWithExpectedSize((int)OperationType.values().length).put((Object)"TEST_EXECUTION", (Object)OperationType.TEST).put((Object)"TASK_EXECUTION", (Object)OperationType.TASK).put((Object)"WORK_ITEM_EXECUTION", (Object)OperationType.WORK_ITEM).put((Object)"PROJECT_CONFIGURATION_EXECUTION", (Object)OperationType.PROJECT_CONFIGURATION).put((Object)"TRANSFORM_EXECUTION", (Object)OperationType.TRANSFORM).put((Object)"BUILD_EXECUTION", (Object)OperationType.GENERIC).put((Object)"TEST_OUTPUT", (Object)OperationType.TEST_OUTPUT).put((Object)"TEST_METADATA", (Object)OperationType.TEST_METADATA).put((Object)"FILE_DOWNLOAD", (Object)OperationType.FILE_DOWNLOAD).put((Object)"BUILD_PHASE", (Object)OperationType.BUILD_PHASE).put((Object)"PROBLEMS", (Object)OperationType.PROBLEMS).put((Object)"ROOT", (Object)OperationType.ROOT).build();
        private final BuildEventSubscriptions clientSubscriptions;
        private final FailsafeBuildProgressListenerAdapter failsafeWrapper;
        private final BuildEventConsumer buildEventConsumer;

        ProgressListenerConfiguration(BuildEventSubscriptions clientSubscriptions, BuildEventConsumer buildEventConsumer, FailsafeBuildProgressListenerAdapter failsafeWrapper) {
            this.clientSubscriptions = clientSubscriptions;
            this.buildEventConsumer = buildEventConsumer;
            this.failsafeWrapper = failsafeWrapper;
        }

        @VisibleForTesting
        BuildEventSubscriptions getClientSubscriptions() {
            return this.clientSubscriptions;
        }

        @VisibleForTesting
        static ProgressListenerConfiguration from(ProviderOperationParameters providerParameters, GradleVersion consumerVersion, PayloadSerializer payloadSerializer, IsolatableSerializerRegistry isolatableSerializerRegistry) {
            InternalBuildProgressListener buildProgressListener = providerParameters.getBuildProgressListener();
            Set<OperationType> operationTypes = ProgressListenerConfiguration.toOperationTypes(buildProgressListener, consumerVersion);
            BuildEventSubscriptions clientSubscriptions = new BuildEventSubscriptions(operationTypes);
            FailsafeBuildProgressListenerAdapter progressListenerAdapter = new FailsafeBuildProgressListenerAdapter(buildProgressListener);
            Object buildEventConsumer = clientSubscriptions.isAnyOperationTypeRequested() ? new BuildProgressListenerInvokingBuildEventConsumer((InternalBuildProgressListener)progressListenerAdapter) : new NoOpBuildEventConsumer();
            buildEventConsumer = new ProblemAdditionalDataRemapper(payloadSerializer, (BuildEventConsumer)buildEventConsumer, isolatableSerializerRegistry);
            buildEventConsumer = new StreamedValueConsumer(providerParameters, payloadSerializer, (BuildEventConsumer)buildEventConsumer);
            if (Boolean.TRUE.equals(providerParameters.isEmbedded())) {
                buildEventConsumer = new SynchronizedConsumer((BuildEventConsumer)buildEventConsumer);
            }
            return new ProgressListenerConfiguration(clientSubscriptions, (BuildEventConsumer)buildEventConsumer, progressListenerAdapter);
        }

        private static Set<OperationType> toOperationTypes(InternalBuildProgressListener buildProgressListener, GradleVersion consumerVersion) {
            if (buildProgressListener != null) {
                EnumSet<OperationType> operationTypes = EnumSet.noneOf(OperationType.class);
                for (String operation : buildProgressListener.getSubscribedOperations()) {
                    if (!OPERATION_TYPE_MAPPING.containsKey(operation)) continue;
                    operationTypes.add(OPERATION_TYPE_MAPPING.get(operation));
                }
                if (consumerVersion.compareTo(GradleVersion.version((String)"5.1")) < 0 && operationTypes.contains(OperationType.GENERIC)) {
                    operationTypes.add(OperationType.PROJECT_CONFIGURATION);
                    operationTypes.add(OperationType.TRANSFORM);
                    operationTypes.add(OperationType.WORK_ITEM);
                }
                if (consumerVersion.compareTo(GradleVersion.version((String)"7.3")) < 0 && operationTypes.contains(OperationType.GENERIC)) {
                    operationTypes.add(OperationType.FILE_DOWNLOAD);
                }
                if (consumerVersion.compareTo(GradleVersion.version((String)"8.12")) < 0 && operationTypes.contains(OperationType.GENERIC)) {
                    operationTypes.add(OperationType.ROOT);
                }
                return operationTypes;
            }
            return Collections.emptySet();
        }

        private static class SynchronizedConsumer
        implements BuildEventConsumer {
            private final BuildEventConsumer delegate;

            public SynchronizedConsumer(BuildEventConsumer delegate) {
                this.delegate = delegate;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispatch(Object message) {
                SynchronizedConsumer synchronizedConsumer = this;
                synchronized (synchronizedConsumer) {
                    this.delegate.dispatch(message);
                }
            }
        }
    }

    private static final class BuildProgressListenerInvokingBuildEventConsumer
    implements BuildEventConsumer {
        private final InternalBuildProgressListener buildProgressListener;

        private BuildProgressListenerInvokingBuildEventConsumer(InternalBuildProgressListener buildProgressListener) {
            this.buildProgressListener = buildProgressListener;
        }

        public void dispatch(Object event) {
            if (event instanceof InternalProgressEvent) {
                this.buildProgressListener.onEvent(event);
            }
        }
    }
}

