/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.rt.execution.junit.ComparisonFailureData;
import com.intellij.rt.execution.testFrameworks.AbstractExpectedPatterns;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class ExpectedPatterns
extends AbstractExpectedPatterns {
    private static final List<Pattern> PATTERNS = new ArrayList<Pattern>();
    private static final String[] PATTERN_STRINGS = new String[]{"\nexpected: is \"(.*)\"\n\\s*got: \"(.*)\"\n", "\nexpected: is \"(.*)\"\n\\s*but:\\s+was \"(.*)\"", "\nexpected: (.*)\n\\s*got: (.*)", "expected same:<(.*)> was not:<(.*)>", "\nexpected: \"(.*)\"\n\\s*but: was \"(.*)\"", "expected: (.*)\n\\s*but: was (.*)", "expected: (.*)\\s+but was: (.*)", "expecting:\\s+<(.*)> to be equal to:\\s+<(.*)>\\s+but was not"};

    public static ComparisonFailureData createExceptionNotification(String message) {
        return ExpectedPatterns.createExceptionNotification((String)message, PATTERNS);
    }

    public static ComparisonFailureData createExceptionNotification(Throwable assertion) {
        if (ExpectedPatterns.isComparisonFailure(assertion)) {
            return ComparisonFailureData.create((Throwable)assertion);
        }
        try {
            Throwable cause = assertion.getCause();
            if (ExpectedPatterns.isComparisonFailure(cause)) {
                return ComparisonFailureData.create((Throwable)cause);
            }
        }
        catch (Throwable cause) {
            // empty catch block
        }
        String message = assertion.getMessage();
        if (message != null) {
            return ExpectedPatterns.createExceptionNotification(message);
        }
        return null;
    }

    private static boolean isComparisonFailure(Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        return ComparisonFailureData.isComparisonFailure(throwable.getClass());
    }

    static {
        ExpectedPatterns.registerPatterns((String[])PATTERN_STRINGS, PATTERNS);
    }
}

