/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.HtmlFormInputWithoutLabelInspection;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateNewLabelAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public final class CreateLabelFromTextAction
implements LocalQuickFix,
HighPriorityAction {
    private final String myBundleKey;
    private final boolean myTextBeforeTag;
    private final String myName;

    public CreateLabelFromTextAction(@NonNls @PropertyKey(resourceBundle="messages.HtmlToolsBundle") @NonNls @PropertyKey(resourceBundle="messages.HtmlToolsBundle") String bundleKey, boolean textBeforeTag, String name) {
        this.myBundleKey = bundleKey;
        this.myTextBeforeTag = textBeforeTag;
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = HtmlToolsBundle.message(this.myBundleKey, this.myName);
        if (string == null) {
            CreateLabelFromTextAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement e;
        if (project == null) {
            CreateLabelFromTextAction.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            CreateLabelFromTextAction.$$$reportNull$$$0(2);
        }
        if ((e = descriptor.getPsiElement()) == null) {
            return;
        }
        XmlTag myTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)e, XmlTag.class);
        if (myTag == null) {
            return;
        }
        Pair<PsiElement, PsiElement> pair = HtmlFormInputWithoutLabelInspection.getNearestText((PsiElement)myTag, this.myTextBeforeTag ? new HtmlFormInputWithoutLabelInspection.BackwardIterator() : new HtmlFormInputWithoutLabelInspection.ForwardIterator());
        if (pair == null) {
            return;
        }
        PsiElement myLeft = (PsiElement)pair.first;
        PsiElement myRight = (PsiElement)pair.second;
        StringBuilder sb = new StringBuilder("<a>");
        if (this.myTextBeforeTag) {
            for (element = myLeft.getParent().getFirstChild(); element != null && element != myLeft; element = element.getNextSibling()) {
                sb.append(element.getText());
            }
        } else {
            for (element = myRight.getNextSibling(); element != null; element = element.getNextSibling()) {
                sb.append(element.getText());
                if (element != element.getParent().getLastChild()) {
                    continue;
                }
                break;
            }
        }
        XmlTag tmpTag = CreateNewLabelAction.createElementFromText(project, myTag, sb.toString());
        PsiElement anchor = null;
        for (PsiElement element : tmpTag.getChildren()) {
            if (!(element instanceof XmlText) && !(element instanceof PsiComment)) continue;
            anchor = anchor == null ? myLeft.getParent().replace(element) : myLeft.addAfter(element, anchor);
        }
        String id = CreateNewLabelAction.getId(myTag);
        if (id != null) {
            StringBuilder builder = new StringBuilder("\n<label for=\"").append(id).append("\">");
            for (PsiElement element = myLeft; element != null; element = element.getNextSibling()) {
                builder.append(element.getText());
                if (element == myRight) break;
            }
            builder.append("</label>");
            XmlTag labelTag = CreateNewLabelAction.createElementFromText(project, myTag, builder.toString());
            if (this.myTextBeforeTag) {
                myTag.getParent().addBefore((PsiElement)labelTag, (PsiElement)myTag);
            } else {
                myTag.getParent().addAfter((PsiElement)labelTag, (PsiElement)myTag);
            }
        } else {
            StringBuilder builder = new StringBuilder("\n<label>\n");
            if (!this.myTextBeforeTag) {
                builder.append(myTag.getText());
                builder.append("\n");
            }
            for (PsiElement element = myLeft; element != null; element = element.getNextSibling()) {
                builder.append(element.getText());
                if (element == myRight) break;
            }
            if (this.myTextBeforeTag) {
                builder.append("\n");
                builder.append(myTag.getText());
            }
            builder.append("\n</label>");
            XmlTag tag = CreateNewLabelAction.createElementFromText(project, myTag, builder.toString());
            myTag.replace((PsiElement)tag);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/codeInspection/htmlInspections/htmlAddLabelToForm/CreateLabelFromTextAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/codeInspection/htmlInspections/htmlAddLabelToForm/CreateLabelFromTextAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

