/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.function.Function;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;

final class ConfigureGroovyLibraryNotificationProvider
implements EditorNotificationProvider {
    ConfigureGroovyLibraryNotificationProvider() {
    }

    @Nullable
    public @Nullable Function<? super @NotNull FileEditor, ? extends @Nullable JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(1);
        }
        try {
            if (!file.getFileType().equals((Object)GroovyFileType.GROOVY_FILE_TYPE)) {
                return null;
            }
            if (StringUtil.endsWith((CharSequence)file.getName(), (CharSequence)".gradle") || CompilerManager.getInstance((Project)project).isExcludedFromCompilation(file)) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null || ConfigureGroovyLibraryNotificationProvider.isMavenModule(module)) {
                return null;
            }
            for (GroovyFrameworkConfigNotification configNotification : (GroovyFrameworkConfigNotification[])GroovyFrameworkConfigNotification.EP_NAME.getExtensions()) {
                if (!configNotification.hasFrameworkStructure(module)) continue;
                return configNotification.hasFrameworkLibrary(module) ? null : fileEditor -> ConfigureGroovyLibraryNotificationProvider.createConfigureNotificationPanel(module, fileEditor);
            }
            return null;
        }
        catch (ProcessCanceledException | IndexNotReadyException ignored) {
            return null;
        }
    }

    @RequiresEdt
    @NotNull
    private static EditorNotificationPanel createConfigureNotificationPanel(@NotNull Module module, @NotNull FileEditor fileEditor) {
        if (module == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(3);
        }
        EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor, EditorNotificationPanel.Status.Warning);
        panel2.setText(GroovyBundle.message("groovy.library.is.not.configured.for.module", module.getName()));
        panel2.createActionLabel(GroovyBundle.message("configure.groovy.library", new Object[0]), () -> AddCustomLibraryDialog.createDialog((CustomLibraryDescription)new GroovyLibraryDescription(), (Module)module, null).show());
        EditorNotificationPanel editorNotificationPanel = panel2;
        if (editorNotificationPanel == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(4);
        }
        return editorNotificationPanel;
    }

    private static boolean isMavenModule(@NotNull Module module) {
        if (module == null) {
            ConfigureGroovyLibraryNotificationProvider.$$$reportNull$$$0(5);
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            if (root.findChild("pom.xml") == null) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/config/ConfigureGroovyLibraryNotificationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/config/ConfigureGroovyLibraryNotificationProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigureNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNotificationData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createConfigureNotificationPanel";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isMavenModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

