/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PortField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnConfigurationState;
import org.jetbrains.idea.svn.commandLine.SshTunnelRuntimeModule;

public class SshSettingsPanel
implements ConfigurableUi<SvnConfiguration>,
Disposable {
    private JBRadioButton myPasswordChoice;
    private JBRadioButton myPrivateKeyChoice;
    private JBRadioButton mySubversionConfigChoice;
    private JPanel myMainPanel;
    private JBTextField myUserNameField;
    private JBTextField mySshTunnelField;
    private JButton myUpdateTunnelButton;
    private JBTextField mySvnSshVariableField;
    private JPanel mySubversionConfigOptions;
    private JPanel myPrivateKeyOptions;
    private JPanel myCommonOptions;
    private JBLabel mySvnSshVariableLabel;
    private JBTextField myExecutablePathTextField;
    private TextFieldWithBrowseButton myExecutablePathField;
    private PortField myPortField;
    private TextFieldWithBrowseButton myPrivateKeyPathField;
    private String mySshTunnelFromConfig;
    private final SvnConfiguration mySvnConfiguration;

    public SshSettingsPanel(@NotNull Project project) {
        if (project == null) {
            SshSettingsPanel.$$$reportNull$$$0(0);
        }
        this.$$$setupUI$$$();
        this.mySvnConfiguration = SvnConfiguration.getInstance(project);
        this.init();
    }

    private void init() {
        SshSettingsPanel.register(this.myPasswordChoice, SvnConfiguration.SshConnectionType.PASSWORD);
        SshSettingsPanel.register(this.myPrivateKeyChoice, SvnConfiguration.SshConnectionType.PRIVATE_KEY);
        SshSettingsPanel.register(this.mySubversionConfigChoice, SvnConfiguration.SshConnectionType.SUBVERSION_CONFIG);
        ItemListener connectionTypeChangedListener = e -> {
            if (e.getStateChange() == 1) {
                this.enableOptions(e.getSource());
            }
        };
        this.myPasswordChoice.addItemListener(connectionTypeChangedListener);
        this.myPrivateKeyChoice.addItemListener(connectionTypeChangedListener);
        this.mySubversionConfigChoice.addItemListener(connectionTypeChangedListener);
        this.enableOptions(this.mySubversionConfigChoice);
        this.registerBrowseDialog(this.myExecutablePathField, SvnBundle.message("dialog.title.ssh.settings.browse.executable", new Object[0]));
        this.registerBrowseDialog(this.myPrivateKeyPathField, SvnBundle.message("dialog.title.ssh.settings.browse.private.key", new Object[0]));
        this.mySshTunnelField.getEmptyText().setText("$SVN_SSH ssh -q");
        this.mySshTunnelField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                SshSettingsPanel.this.updateSshTunnelDependentValues(SshSettingsPanel.this.mySshTunnelField.getText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/dialogs/SshSettingsPanel$1", "textChanged"));
            }
        });
        this.myUpdateTunnelButton.addActionListener(e -> {
            String tunnel = this.mySshTunnelField.getText();
            this.mySvnConfiguration.setSshTunnelSetting(StringUtil.nullize((String)tunnel));
            this.setSshTunnelSetting(this.mySvnConfiguration.getSshTunnelSetting());
        });
    }

    private void registerBrowseDialog(@NotNull TextFieldWithBrowseButton component, @NlsContexts.DialogTitle @NotNull String dialogTitle) {
        if (component == null) {
            SshSettingsPanel.$$$reportNull$$$0(1);
        }
        if (dialogTitle == null) {
            SshSettingsPanel.$$$reportNull$$$0(2);
        }
        component.addBrowseFolderListener(this.mySvnConfiguration.getProject(), FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(dialogTitle));
    }

    private void enableOptions(Object source) {
        UIUtil.setEnabled((Component)this.myCommonOptions, (!this.mySubversionConfigChoice.equals(source) ? 1 : 0) != 0, (boolean)true);
        UIUtil.setEnabled((Component)this.myPrivateKeyOptions, (boolean)this.myPrivateKeyChoice.equals(source), (boolean)true);
        UIUtil.setEnabled((Component)this.mySubversionConfigOptions, (boolean)this.mySubversionConfigChoice.equals(source), (boolean)true);
        this.mySvnSshVariableField.setEditable(false);
        this.setUpdateTunnelButtonEnabled(this.mySshTunnelField.getText());
    }

    public void reset(@NotNull SvnConfiguration settings) {
        if (settings == null) {
            SshSettingsPanel.$$$reportNull$$$0(3);
        }
        SvnConfigurationState state = settings.getState();
        this.setConnectionChoice(state.sshConnectionType);
        this.myExecutablePathField.setText(state.sshExecutablePath);
        this.myUserNameField.setText(state.sshUserName);
        this.myPortField.setNumber(state.sshPort);
        this.myPrivateKeyPathField.setText(state.sshPrivateKeyPath);
        this.setSshTunnelSetting(settings.getSshTunnelSetting());
    }

    public boolean isModified(@NotNull SvnConfiguration settings) {
        if (settings == null) {
            SshSettingsPanel.$$$reportNull$$$0(4);
        }
        SvnConfigurationState state = settings.getState();
        return !state.sshConnectionType.equals((Object)this.getConnectionChoice()) || !StringUtil.equals((CharSequence)state.sshExecutablePath, (CharSequence)this.myExecutablePathField.getText()) || !StringUtil.equals((CharSequence)state.sshUserName, (CharSequence)this.myUserNameField.getText()) || state.sshPort != this.myPortField.getNumber() || !StringUtil.equals((CharSequence)state.sshPrivateKeyPath, (CharSequence)this.myPrivateKeyPathField.getText());
    }

    public void apply(@NotNull SvnConfiguration settings) {
        if (settings == null) {
            SshSettingsPanel.$$$reportNull$$$0(5);
        }
        SvnConfigurationState state = settings.getState();
        state.sshConnectionType = this.getConnectionChoice();
        state.sshExecutablePath = this.myExecutablePathField.getText();
        state.sshUserName = this.myUserNameField.getText();
        state.sshPort = this.myPortField.getNumber();
        state.sshPrivateKeyPath = this.myPrivateKeyPathField.getText();
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            SshSettingsPanel.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    public void dispose() {
    }

    private void setConnectionChoice(@NotNull SvnConfiguration.SshConnectionType value) {
        if (value == null) {
            SshSettingsPanel.$$$reportNull$$$0(7);
        }
        SshSettingsPanel.setSelected(this.myPasswordChoice, value);
        SshSettingsPanel.setSelected(this.myPrivateKeyChoice, value);
        SshSettingsPanel.setSelected(this.mySubversionConfigChoice, value);
    }

    @NotNull
    private SvnConfiguration.SshConnectionType getConnectionChoice() {
        JBRadioButton selected;
        Object object = this.myPasswordChoice.isSelected() ? this.myPasswordChoice : (this.myPrivateKeyChoice.isSelected() ? this.myPrivateKeyChoice : (selected = this.mySubversionConfigChoice.isSelected() ? this.mySubversionConfigChoice : null));
        assert (selected != null);
        SvnConfiguration.SshConnectionType sshConnectionType = (SvnConfiguration.SshConnectionType)((Object)selected.getClientProperty((Object)"value"));
        if (sshConnectionType == null) {
            SshSettingsPanel.$$$reportNull$$$0(8);
        }
        return sshConnectionType;
    }

    private void setSshTunnelSetting(@NotNull String tunnelSetting) {
        if (tunnelSetting == null) {
            SshSettingsPanel.$$$reportNull$$$0(9);
        }
        this.mySshTunnelFromConfig = tunnelSetting;
        this.mySshTunnelField.setText(tunnelSetting);
        this.updateSshTunnelDependentValues(tunnelSetting);
    }

    private void updateSshTunnelDependentValues(@NlsSafe @Nullable String tunnelSetting) {
        String svnSshVariableName = SshTunnelRuntimeModule.getSvnSshVariableName(!StringUtil.isEmpty((String)tunnelSetting) ? tunnelSetting : "$SVN_SSH ssh -q");
        String svnSshVariableValue = StringUtil.notNullize((String)EnvironmentUtil.getValue((String)svnSshVariableName));
        this.mySvnSshVariableLabel.setText(svnSshVariableName + ":");
        this.mySvnSshVariableField.setText(svnSshVariableValue);
        boolean isSvnSshVariableNameInTunnel = !StringUtil.isEmpty((String)svnSshVariableName);
        this.mySvnSshVariableLabel.setVisible(isSvnSshVariableNameInTunnel);
        this.mySvnSshVariableField.setVisible(isSvnSshVariableNameInTunnel);
        this.myExecutablePathTextField.getEmptyText().setText(SshTunnelRuntimeModule.getExecutablePath(tunnelSetting));
        this.setUpdateTunnelButtonEnabled(tunnelSetting);
    }

    private void setUpdateTunnelButtonEnabled(@Nullable String tunnelSetting) {
        this.myUpdateTunnelButton.setEnabled(!StringUtil.equals((CharSequence)tunnelSetting, (CharSequence)this.mySshTunnelFromConfig));
    }

    private static void register(@NotNull JBRadioButton choice, @NotNull SvnConfiguration.SshConnectionType value) {
        if (choice == null) {
            SshSettingsPanel.$$$reportNull$$$0(10);
        }
        if (value == null) {
            SshSettingsPanel.$$$reportNull$$$0(11);
        }
        choice.putClientProperty((Object)"value", (Object)value);
    }

    private static void setSelected(@NotNull JBRadioButton choice, @NotNull SvnConfiguration.SshConnectionType value) {
        if (choice == null) {
            SshSettingsPanel.$$$reportNull$$$0(12);
        }
        if (value == null) {
            SshSettingsPanel.$$$reportNull$$$0(13);
        }
        choice.setSelected(value.equals(choice.getClientProperty((Object)"value")));
    }

    private void createUIComponents() {
        this.myExecutablePathTextField = new JBTextField();
        this.myExecutablePathField = new TextFieldWithBrowseButton((JTextField)this.myExecutablePathTextField, null, (Disposable)this);
        this.myPrivateKeyPathField = new TextFieldWithBrowseButton(null, (Disposable)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/dialogs/SshSettingsPanel";
                break;
            }
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tunnelSetting";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "choice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/dialogs/SshSettingsPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConnectionChoice";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerBrowseDialog";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setConnectionChoice";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setSshTunnelSetting";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 8 -> new IllegalStateException(string);
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBLabel jBLabel;
        JButton jButton;
        JBTextField jBTextField2;
        JPanel jPanel;
        JPanel jPanel2;
        PortField portField;
        JBTextField jBTextField3;
        JPanel jPanel3;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPasswordChoice = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setMargin(new Insets(2, -2, 2, 3));
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.password.choice.title"));
        jPanel4.add((Component)jBRadioButton3, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        this.myPrivateKeyChoice = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setMargin(new Insets(2, -2, 2, 3));
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.private.key.choice.title"));
        jPanel4.add((Component)jBRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySubversionConfigChoice = jBRadioButton = new JBRadioButton();
        jBRadioButton.setMargin(new Insets(2, -2, 2, 3));
        jBRadioButton.setSelected(true);
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.subversion.config.choice.title"));
        jPanel4.add((Component)jBRadioButton, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCommonOptions = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.executable.label"));
        jPanel3.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.user.name.label"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUserNameField = jBTextField3 = new JBTextField();
        jPanel3.add((Component)jBTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel4 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel4, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.port.label"));
        jPanel3.add((Component)jBLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = portField = new PortField();
        jPanel3.add((Component)portField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.myExecutablePathField;
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPrivateKeyOptions = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        JBLabel jBLabel5 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel5, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.private.key.path.label"));
        jPanel2.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = this.myPrivateKeyPathField;
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.mySubversionConfigOptions = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        JBLabel jBLabel6 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel6, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.tunnel.label"));
        jPanel.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySshTunnelField = jBTextField2 = new JBTextField();
        jPanel.add((Component)jBTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myUpdateTunnelButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/SvnBundle", SshSettingsPanel.class).getString("ssh.settings.update.tunnel.title"));
        jPanel.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.mySvnSshVariableLabel = jBLabel = new JBLabel();
        jBLabel.setText("");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySvnSshVariableField = jBTextField = new JBTextField();
        jBTextField.setEnabled(false);
        jPanel.add((Component)jBTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
        jBLabel3.setLabelFor((Component)jBTextField3);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton3);
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

