/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator.rules.impl;

import com.intellij.internal.statistic.eventLog.validator.IEventContext;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.RecorderDataValidationError;
import com.intellij.internal.statistic.eventLog.validator.rules.StorageError;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRevision;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.RecorderDataValidationRule;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.beans.EventDataField;
import com.jetbrains.fus.reporting.MetadataStorage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0002J \u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002JJ\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u000b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J:\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ6\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eJ:\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidator;", "", "validationRulesStorage", "Lcom/jetbrains/fus/reporting/MetadataStorage;", "(Lcom/jetbrains/fus/reporting/MetadataStorage;)V", "collectMissedRequiredKeys", "", "", "validationRules", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRevision;", "data", "", "getValidationRulesForVersion", "recorderVersion", "", "revisions", "", "validate", "context", "Lcom/intellij/internal/statistic/eventLog/validator/IEventContext;", "jsonPath", "validationRule", "Lcom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidationRule;", "validateClientData", "clientData", "validateIds", "ids", "validateSystemData", "systemData", "ap-validation"})
@SourceDebugExtension(value={"SMAP\nRecorderDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecorderDataValidator.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n453#2:138\n403#2:139\n1238#3,4:140\n1#4:144\n*S KotlinDebug\n*F\n+ 1 RecorderDataValidator.kt\ncom/intellij/internal/statistic/eventLog/validator/rules/impl/RecorderDataValidator\n*L\n22#1:138\n22#1:139\n22#1:140,4\n*E\n"})
public final class RecorderDataValidator {
    @NotNull
    private final MetadataStorage<?> validationRulesStorage;

    public RecorderDataValidator(@NotNull MetadataStorage<?> validationRulesStorage) {
        Intrinsics.checkNotNullParameter(validationRulesStorage, (String)"validationRulesStorage");
        this.validationRulesStorage = validationRulesStorage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> validateIds(@NotNull Map<String, String> ids, @NotNull IEventContext context, int recorderVersion) {
        void $this$mapValuesTo$iv$iv;
        Map<String, Object> validatedIds;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, Object> $this$mapValues$iv = validatedIds = this.validate(ids, context, recorderVersion, "ids", this.validationRulesStorage.getIdsRulesRevisions());
        boolean $i$f$mapValues = false;
        Map<String, Object> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String string2 = it.getValue().toString();
            map4.put(k, string2);
        }
        return destination$iv$iv;
    }

    @Nullable
    public final Map<String, Object> validateSystemData(@Nullable Map<String, ? extends Object> systemData, @NotNull IEventContext context, int recorderVersion) {
        Map<String, Object> map2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, Object> map3 = this.validate(systemData, context, recorderVersion, "system_data", this.validationRulesStorage.getSystemDataRulesRevisions());
        if (map3.isEmpty()) {
            boolean bl = false;
            map2 = null;
        } else {
            map2 = map3;
        }
        return map2;
    }

    @Nullable
    public final Map<String, Object> validateClientData(@Nullable Map<String, ? extends Object> clientData, @NotNull IEventContext context, int recorderVersion) {
        Map<String, Object> map2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Map<String, Object> map3 = this.validate(clientData, context, recorderVersion, "client_data", this.validationRulesStorage.getClientDataRulesRevisions());
        if (map3.isEmpty()) {
            boolean bl = false;
            map2 = null;
        } else {
            map2 = map3;
        }
        return map2;
    }

    private final Map<String, Object> validate(Map<String, ? extends Object> data, IEventContext context, int recorderVersion, String jsonPath, RecorderDataValidationRule validationRule) {
        if (this.validationRulesStorage.isUnreachable()) {
            context.addError(new StorageError(ValidationResultType.UNREACHABLE_METADATA, "Unreachable metadata"));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ValidationResultType.UNREACHABLE_METADATA.getDescription(), (Object)ValidationResultType.UNREACHABLE_METADATA.getDescription())};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        if (!validationRule.requiredValidation()) {
            Map map2 = data;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            return map2;
        }
        List<RecorderDataValidationRevision> rulesRevisions = validationRule.getRevisions();
        if (rulesRevisions.isEmpty()) {
            context.addError(new RecorderDataValidationError(ValidationResultType.UNDEFINED_RULE, jsonPath, "Rules are undefined"));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ValidationResultType.UNDEFINED_RULE.getDescription(), (Object)ValidationResultType.UNDEFINED_RULE.getDescription())};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        RecorderDataValidationRevision validationRules = this.getValidationRulesForVersion(recorderVersion, rulesRevisions);
        if (validationRules == null) {
            context.addError(new RecorderDataValidationError(ValidationResultType.UNDEFINED_RULE, jsonPath, "Undefined " + jsonPath + " for recorder version " + recorderVersion));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)ValidationResultType.UNDEFINED_RULE.getDescription(), (Object)ValidationResultType.UNDEFINED_RULE.getDescription())};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        HashMap validatedData = new HashMap();
        Map map3 = data;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        for (Map.Entry entry : map3.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            EventDataField eventDataField = validationRules.getRules().validateData(key, value, context, jsonPath);
            String validatedKey = eventDataField.component1();
            Object validatedValue = eventDataField.component2();
            ((Map)validatedData).put(validatedKey, validatedValue);
        }
        Set<String> missedKeys = this.collectMissedRequiredKeys(validationRules, data);
        if (!((Collection)missedKeys).isEmpty()) {
            context.addError(new RecorderDataValidationError(ValidationResultType.REQUIRED_FIELD_MISSED, jsonPath, "Missed required fields: " + CollectionsKt.joinToString$default((Iterable)missedKeys, null, null, null, (int)0, null, null, (int)63, null)));
            ((Map)validatedData).put(ValidationResultType.REQUIRED_FIELD_MISSED.getDescription(), missedKeys);
        }
        return validatedData;
    }

    private final Set<String> collectMissedRequiredKeys(RecorderDataValidationRevision validationRules, Map<String, ? extends Object> data) {
        if (data == null) {
            return validationRules.getRequiredKeys();
        }
        HashSet<String> missedKeys = new HashSet<String>();
        for (String requiredKey : validationRules.getRequiredKeys()) {
            if (data.keySet().contains(requiredKey)) continue;
            missedKeys.add(requiredKey);
        }
        return missedKeys;
    }

    private final RecorderDataValidationRevision getValidationRulesForVersion(int recorderVersion, List<RecorderDataValidationRevision> revisions) {
        for (RecorderDataValidationRevision revision : revisions) {
            Integer to = revision.getTo();
            if (revision.getFrom() > recorderVersion || to != null && recorderVersion >= to) continue;
            return revision;
        }
        return null;
    }
}

