/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Collection;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.jetbrains.jps.builders.java.JavaSourceTransformer;

final class TransformableJavaFileObject
implements JavaFileObject {
    private final JavaFileObject myOriginal;
    private final Collection<? extends JavaSourceTransformer> myTransformers;

    TransformableJavaFileObject(JavaFileObject original, Collection<? extends JavaSourceTransformer> transformers) {
        this.myOriginal = original;
        this.myTransformers = transformers;
    }

    public JavaFileObject getOriginal() {
        return this.myOriginal;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        File file = new File(this.myOriginal.toUri());
        CharSequence content = this.myOriginal.getCharContent(ignoreEncodingErrors);
        for (JavaSourceTransformer javaSourceTransformer : this.myTransformers) {
            content = javaSourceTransformer.transform(file, content);
        }
        return content;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.myOriginal.openInputStream();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.myOriginal.getKind();
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return this.myOriginal.isNameCompatible(simpleName, kind);
    }

    @Override
    public NestingKind getNestingKind() {
        return this.myOriginal.getNestingKind();
    }

    @Override
    public Modifier getAccessLevel() {
        return this.myOriginal.getAccessLevel();
    }

    @Override
    public URI toUri() {
        return this.myOriginal.toUri();
    }

    @Override
    public String getName() {
        return this.myOriginal.getName();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return this.myOriginal.openOutputStream();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return this.myOriginal.openReader(ignoreEncodingErrors);
    }

    @Override
    public Writer openWriter() throws IOException {
        return this.myOriginal.openWriter();
    }

    @Override
    public long getLastModified() {
        return this.myOriginal.getLastModified();
    }

    @Override
    public boolean delete() {
        return this.myOriginal.delete();
    }

    public String toString() {
        return this.getName();
    }
}

