/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import sun.jvm.hotspot.ui.FrameWrapper;

public class JInternalFrameWrapper
implements FrameWrapper {
    private JInternalFrame frame;
    private boolean hasWindowListener;
    private ActionListener closingActionListener;
    private ActionListener activatedActionListener;

    public JInternalFrameWrapper(JInternalFrame frame) {
        this.frame = frame;
    }

    @Override
    public Component getComponent() {
        return this.frame;
    }

    @Override
    public Container getContentPane() {
        return this.frame.getContentPane();
    }

    @Override
    public void setVisible(boolean visible) {
        this.frame.setVisible(visible);
    }

    @Override
    public void setSize(int x, int y) {
        this.frame.setSize(x, y);
    }

    @Override
    public void pack() {
        this.frame.pack();
    }

    public void show() {
        this.frame.show();
    }

    @Override
    public void dispose() {
        this.frame.dispose();
    }

    @Override
    public void setBackground(Color color) {
        this.frame.setBackground(color);
    }

    @Override
    public void setResizable(boolean resizable) {
        this.frame.setResizable(resizable);
    }

    @Override
    public void setClosable(boolean closable) {
        this.frame.setClosable(closable);
    }

    @Override
    public void setClosingActionListener(ActionListener l) {
        this.closingActionListener = l;
        this.maybeInstallWindowListener();
    }

    @Override
    public void setActivatedActionListener(ActionListener l) {
        this.activatedActionListener = l;
        this.maybeInstallWindowListener();
    }

    @Override
    public void toFront() {
        this.frame.toFront();
        try {
            this.frame.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void maybeInstallWindowListener() {
        if (!this.hasWindowListener) {
            this.frame.addInternalFrameListener(new InternalFrameAdapter(){

                @Override
                public void internalFrameClosing(InternalFrameEvent e) {
                    if (JInternalFrameWrapper.this.closingActionListener != null) {
                        JInternalFrameWrapper.this.closingActionListener.actionPerformed(null);
                    }
                }

                @Override
                public void internalFrameActivated(InternalFrameEvent e) {
                    if (JInternalFrameWrapper.this.activatedActionListener != null) {
                        JInternalFrameWrapper.this.activatedActionListener.actionPerformed(null);
                    }
                }
            });
            this.hasWindowListener = true;
        }
    }
}

