/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime;

import java.io.PrintStream;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.utilities.Assert;

public class StackValue {
    private int type;
    private OopHandle handleValue;
    private long integerValue;

    public StackValue() {
        this.type = BasicType.getTConflict();
    }

    public StackValue(OopHandle h, long scalar_replaced) {
        this.handleValue = h;
        this.type = BasicType.getTObject();
        this.integerValue = scalar_replaced;
        Assert.that(this.integerValue == 0L || this.handleValue == null, "not null object should not be marked as scalar replaced");
    }

    public StackValue(long i) {
        this.integerValue = i;
        this.type = BasicType.getTInt();
    }

    public int getType() {
        return this.type;
    }

    public OopHandle getObject() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.type == BasicType.getTObject(), "type check");
        }
        return this.handleValue;
    }

    boolean objIsScalarReplaced() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.type == BasicType.getTObject(), "type check");
        }
        return this.integerValue != 0L;
    }

    public long getInteger() {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.type == BasicType.getTInt(), "type check");
        }
        return this.integerValue;
    }

    public boolean equals(Object arg) {
        if (arg == null) {
            return false;
        }
        if (!arg.getClass().equals(this.getClass())) {
            return false;
        }
        StackValue sv = (StackValue)arg;
        if (this.type != sv.type) {
            return false;
        }
        if (this.type == BasicType.getTObject()) {
            return this.handleValue.equals(sv.handleValue);
        }
        if (this.type == BasicType.getTInt()) {
            return this.integerValue == sv.integerValue;
        }
        return true;
    }

    public int hashCode() {
        if (this.type == BasicType.getTObject()) {
            return this.handleValue != null ? this.handleValue.hashCode() : 5;
        }
        return (int)this.integerValue;
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        if (this.type == BasicType.getTInt()) {
            tty.print(this.integerValue + " (long) " + (int)this.integerValue + " (int)");
        } else if (this.type == BasicType.getTObject()) {
            tty.print("<" + this.handleValue + ">");
        } else if (this.type == BasicType.getTConflict()) {
            tty.print("conflict");
        } else {
            throw new RuntimeException("should not reach here");
        }
    }
}

