/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.impl.Item;
import io.smallrye.common.constraint.Assert;

public final class Node {
    private Node next;
    private Node prev;
    private Item item;

    private Node(Node next, Node prev, Item item) {
        this.next = next;
        this.prev = prev;
        this.item = item;
    }

    public static Node newList(Item head, Item tail) {
        Node b;
        Assert.checkNotNullParam((String)"head", (Object)head);
        Assert.checkNotNullParam((String)"tail", (Object)tail);
        Node a = new Node(null, null, head);
        a.next = b = new Node(null, null, tail);
        b.prev = a;
        return a;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Node next() {
        return this.next;
    }

    public boolean hasPrev() {
        return this.prev != null;
    }

    public Node prev() {
        return this.prev;
    }

    public Item item() {
        return this.item;
    }

    public Item set(Item item) {
        Item old = this.item;
        this.item = item;
        return old;
    }

    public Node insertPrev(Item item) {
        Node oldPrev = this.prev;
        if (oldPrev == null) {
            throw new IllegalStateException();
        }
        oldPrev.next = this.prev = new Node(this, oldPrev, item);
        return this.prev;
    }

    public Node insertNext(Item item) {
        Node oldNext = this.next;
        if (oldNext == null) {
            throw new IllegalStateException();
        }
        oldNext.prev = this.next = new Node(oldNext, this, item);
        return this.next;
    }

    public void splicePrev(Node prev) {
        this.prev = prev;
        prev.next = this;
    }

    public void spliceNext(Node next) {
        this.next = next;
        next.prev = this;
    }

    public Item remove() {
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        this.next = null;
        this.prev = null;
        return this.item;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        if (this.prev == null) {
            sb.append("x ");
        } else {
            sb.append("->");
        }
        this.item.toShortString(sb);
        if (this.next == null) {
            sb.append(" x");
        } else {
            sb.append("->");
        }
        return sb.toString();
    }

    public String debugFind(Item item) {
        Node current;
        if (this.item().equals(item)) {
            return "Found at this node";
        }
        int cnt = 1;
        for (current = this.next(); current != null; current = current.next()) {
            if (current.item().equals(item)) {
                return "Found at +" + cnt;
            }
            ++cnt;
        }
        cnt = 1;
        for (current = this.prev(); current != null; current = current.prev()) {
            if (current.item().equals(item)) {
                return "Found at -" + cnt;
            }
            ++cnt;
        }
        return "Not found";
    }

    public String debugList() {
        Node first = this;
        while (first.prev() != null) {
            first = first.prev();
        }
        StringBuilder sb = new StringBuilder();
        for (Node current = first; current != null; current = current.next()) {
            if (current == this) {
                sb.append('|');
            }
            current.item.toShortString(sb);
            if (current == this) {
                sb.append('|');
            }
            if (current.next == null) continue;
            sb.append(" -> ");
        }
        return sb.toString();
    }
}

