/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.List;
import org.keycloak.authentication.RequiredActionProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionConfigModel;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.userprofile.ValidationException;
import org.keycloak.validate.ValidationError;

public interface RequiredActionFactory
extends ProviderFactory<RequiredActionProvider> {
    public static final List<ProviderConfigProperty> MAX_AUTH_AGE_CONFIG_PROPERTIES = RequiredActionFactory.getMaxAuthAgePropertyConfig();

    public static List<ProviderConfigProperty> getMaxAuthAgePropertyConfig() {
        return ProviderConfigurationBuilder.create().property().name("max_auth_age").label("Maximum Age of Authentication").helpText("Configures the duration in seconds this action can be used after the last authentication before the user is required to re-authenticate. This parameter is used just in the context of AIA when the kc_action parameter is available in the request, which is for instance when user himself updates his password in the account console.").type("String").defaultValue((Object)300).add().build();
    }

    public String getDisplayText();

    default public boolean isOneTimeAction() {
        return false;
    }

    default public boolean isConfigurable() {
        List<ProviderConfigProperty> configMetadata = this.getConfigMetadata();
        return configMetadata != null && !configMetadata.isEmpty();
    }

    default public List<ProviderConfigProperty> getConfigMetadata() {
        return List.copyOf(MAX_AUTH_AGE_CONFIG_PROPERTIES);
    }

    default public void validateConfig(KeycloakSession session, RealmModel realm, RequiredActionConfigModel model) {
        int parsedMaxAuthAge;
        if (model.getConfigValue("max_auth_age") == null) {
            return;
        }
        try {
            parsedMaxAuthAge = RequiredActionFactory.parseMaxAuthAge(model);
        }
        catch (NumberFormatException ex) {
            throw new ValidationException(new ValidationError(this.getId(), "max_auth_age", "error-invalid-value"));
        }
        if (parsedMaxAuthAge < 0) {
            throw new ValidationException(new ValidationError(this.getId(), "max_auth_age", "error-number-out-of-range-too-small", new Object[]{0}));
        }
    }

    public static int parseMaxAuthAge(RequiredActionConfigModel model) throws NumberFormatException {
        return Integer.parseInt(model.getConfigValue("max_auth_age"));
    }
}

