/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opensearch.index.query.InnerHitBuilder;
import org.opensearch.protobufs.InnerHits;
import org.opensearch.protobufs.ScriptField;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FieldAndFormat;
import org.opensearch.transport.grpc.proto.request.common.FetchSourceContextProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.CollapseBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.FieldAndFormatProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.HighlightBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.SearchSourceBuilderProtoUtils;
import org.opensearch.transport.grpc.proto.request.search.sort.SortBuilderProtoUtils;
import org.opensearch.transport.grpc.spi.QueryBuilderProtoConverterRegistry;

public class InnerHitsBuilderProtoUtils {
    private InnerHitsBuilderProtoUtils() {
    }

    public static InnerHitBuilder fromProto(InnerHits innerHits, QueryBuilderProtoConverterRegistry registry) throws IOException {
        if (innerHits == null) {
            throw new IllegalArgumentException("InnerHits cannot be null");
        }
        InnerHitBuilder innerHitBuilder = new InnerHitBuilder();
        if (innerHits.hasName()) {
            innerHitBuilder.setName(innerHits.getName());
        }
        if (innerHits.hasIgnoreUnmapped()) {
            innerHitBuilder.setIgnoreUnmapped(innerHits.getIgnoreUnmapped());
        }
        if (innerHits.hasFrom()) {
            innerHitBuilder.setFrom(innerHits.getFrom());
        }
        if (innerHits.hasSize()) {
            innerHitBuilder.setSize(innerHits.getSize());
        }
        if (innerHits.hasExplain()) {
            innerHitBuilder.setExplain(innerHits.getExplain());
        }
        if (innerHits.hasVersion()) {
            innerHitBuilder.setVersion(innerHits.getVersion());
        }
        if (innerHits.hasSeqNoPrimaryTerm()) {
            innerHitBuilder.setSeqNoAndPrimaryTerm(innerHits.getSeqNoPrimaryTerm());
        }
        if (innerHits.hasTrackScores()) {
            innerHitBuilder.setTrackScores(innerHits.getTrackScores());
        }
        if (innerHits.getStoredFieldsCount() > 0) {
            innerHitBuilder.setStoredFieldNames((List)innerHits.getStoredFieldsList());
        }
        if (innerHits.getDocvalueFieldsCount() > 0) {
            ArrayList<FieldAndFormat> docvalueFieldsList = new ArrayList<FieldAndFormat>();
            for (org.opensearch.protobufs.FieldAndFormat fieldAndFormat : innerHits.getDocvalueFieldsList()) {
                docvalueFieldsList.add(FieldAndFormatProtoUtils.fromProto(fieldAndFormat));
            }
            innerHitBuilder.setDocValueFields(docvalueFieldsList);
        }
        if (innerHits.getFieldsCount() > 0) {
            ArrayList<FieldAndFormat> fieldsList = new ArrayList<FieldAndFormat>();
            for (org.opensearch.protobufs.FieldAndFormat fieldAndFormat : innerHits.getFieldsList()) {
                fieldsList.add(FieldAndFormatProtoUtils.fromProto(fieldAndFormat));
            }
            innerHitBuilder.setFetchFields(fieldsList);
        }
        if (innerHits.getScriptFieldsCount() > 0) {
            HashSet<SearchSourceBuilder.ScriptField> scriptFields = new HashSet<SearchSourceBuilder.ScriptField>();
            for (Map.Entry entry : innerHits.getScriptFieldsMap().entrySet()) {
                String name = (String)entry.getKey();
                ScriptField scriptFieldProto = (ScriptField)entry.getValue();
                SearchSourceBuilder.ScriptField scriptField = SearchSourceBuilderProtoUtils.ScriptFieldProtoUtils.fromProto(name, scriptFieldProto);
                scriptFields.add(scriptField);
            }
            innerHitBuilder.setScriptFields(scriptFields);
        }
        if (innerHits.getSortCount() > 0) {
            innerHitBuilder.setSorts(SortBuilderProtoUtils.fromProto(innerHits.getSortList(), registry));
        }
        if (innerHits.hasXSource()) {
            innerHitBuilder.setFetchSourceContext(FetchSourceContextProtoUtils.fromProto(innerHits.getXSource()));
        }
        if (innerHits.hasHighlight()) {
            innerHitBuilder.setHighlightBuilder(HighlightBuilderProtoUtils.fromProto(innerHits.getHighlight(), registry));
        }
        if (innerHits.hasCollapse()) {
            innerHitBuilder.setInnerCollapse(CollapseBuilderProtoUtils.fromProto(innerHits.getCollapse(), registry));
        }
        return innerHitBuilder;
    }
}

