/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.replication.action.status;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.broadcast.node.TransportBroadcastByNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.routing.PlainShardsIterator;
import org.opensearch.cluster.routing.RecoverySource;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardsIterator;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexService;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.replication.common.ReplicationLuceneIndex;
import org.opensearch.replication.action.status.ReplayDetails;
import org.opensearch.replication.action.status.ReplicationStatusResponse;
import org.opensearch.replication.action.status.RestoreDetails;
import org.opensearch.replication.action.status.ShardInfoRequest;
import org.opensearch.replication.action.status.ShardInfoResponse;
import org.opensearch.transport.TransportService;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0001/B3\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0014JL\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010 \u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010!\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#H\u0014J3\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0010\u0010&\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010'H\u0014\u00a2\u0006\u0002\u0010)J3\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0010\u0010&\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010(\u0018\u00010'H\u0014\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/opensearch/replication/action/status/TranportShardsInfoAction;", "Lorg/opensearch/action/support/broadcast/node/TransportBroadcastByNodeAction;", "Lorg/opensearch/replication/action/status/ShardInfoRequest;", "Lorg/opensearch/replication/action/status/ReplicationStatusResponse;", "Lorg/opensearch/replication/action/status/ShardInfoResponse;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "transportService", "Lorg/opensearch/transport/TransportService;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "indexNameExpressionResolver", "Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;", "indicesService", "Lorg/opensearch/indices/IndicesService;", "<init>", "(Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/transport/TransportService;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/metadata/IndexNameExpressionResolver;Lorg/opensearch/indices/IndicesService;)V", "readShardResult", "si", "Lorg/opensearch/core/common/io/stream/StreamInput;", "newResponse", "request", "totalShards", "", "successfulShards", "failedShards", "shardInfoRespons", "", "shardFailures", "Lorg/opensearch/core/action/support/DefaultShardOperationFailedException;", "clusterState", "Lorg/opensearch/cluster/ClusterState;", "readRequestFrom", "shardOperation", "shardRouting", "Lorg/opensearch/cluster/routing/ShardRouting;", "shards", "Lorg/opensearch/cluster/routing/ShardsIterator;", "concreteIndices", "", "", "(Lorg/opensearch/cluster/ClusterState;Lorg/opensearch/replication/action/status/ShardInfoRequest;[Ljava/lang/String;)Lorg/opensearch/cluster/routing/ShardsIterator;", "checkRequestBlock", "Lorg/opensearch/cluster/block/ClusterBlockException;", "state", "(Lorg/opensearch/cluster/ClusterState;Lorg/opensearch/replication/action/status/ShardInfoRequest;[Ljava/lang/String;)Lorg/opensearch/cluster/block/ClusterBlockException;", "checkGlobalBlock", "Companion", "opensearch-cross-cluster-replication"})
@SourceDebugExtension(value={"SMAP\nTranportShardsInfoAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TranportShardsInfoAction.kt\norg/opensearch/replication/action/status/TranportShardsInfoAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1869#2,2:113\n*S KotlinDebug\n*F\n+ 1 TranportShardsInfoAction.kt\norg/opensearch/replication/action/status/TranportShardsInfoAction\n*L\n95#1:113,2\n*E\n"})
public final class TranportShardsInfoAction
extends TransportBroadcastByNodeAction<ShardInfoRequest, ReplicationStatusResponse, ShardInfoResponse> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndicesService indicesService;
    private static final Logger log = LogManager.getLogger(TranportShardsInfoAction.class);

    @Inject
    public TranportShardsInfoAction(@NotNull ClusterService clusterService, @NotNull TransportService transportService, @NotNull ActionFilters actionFilters, @Nullable IndexNameExpressionResolver indexNameExpressionResolver, @NotNull IndicesService indicesService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)indicesService, (String)"indicesService");
        super("indices:admin/plugins/replication/index/all-shards", clusterService, transportService, actionFilters, indexNameExpressionResolver, TranportShardsInfoAction::_init_$lambda$0, "management");
        this.indicesService = indicesService;
    }

    @Nullable
    protected ShardInfoResponse readShardResult(@NotNull StreamInput si) throws IOException {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return new ShardInfoResponse(si);
    }

    @NotNull
    protected ReplicationStatusResponse newResponse(@NotNull ShardInfoRequest request, int totalShards, int successfulShards, int failedShards, @NotNull List<ShardInfoResponse> shardInfoRespons, @NotNull List<? extends DefaultShardOperationFailedException> shardFailures, @NotNull ClusterState clusterState) {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter(shardInfoRespons, (String)"shardInfoRespons");
        Intrinsics.checkNotNullParameter(shardFailures, (String)"shardFailures");
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        return new ReplicationStatusResponse(totalShards, successfulShards, failedShards, shardFailures, shardInfoRespons);
    }

    @NotNull
    protected ShardInfoRequest readRequestFrom(@NotNull StreamInput si) throws IOException {
        Intrinsics.checkNotNullParameter((Object)si, (String)"si");
        return new ShardInfoRequest(si);
    }

    @NotNull
    protected ShardInfoResponse shardOperation(@NotNull ShardInfoRequest request, @NotNull ShardRouting shardRouting) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)request), (String)"request");
        Intrinsics.checkNotNullParameter((Object)shardRouting, (String)"shardRouting");
        IndexService indexService = this.indicesService.indexServiceSafe(shardRouting.shardId().getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)indexService, (String)"indexServiceSafe(...)");
        IndexService indexService2 = indexService;
        IndexShard indexShard = indexService2.getShard(shardRouting.shardId().id());
        ReplicationLuceneIndex indexState = indexShard.recoveryState().getIndex();
        if (indexShard.recoveryState().getRecoverySource().getType().equals((Object)RecoverySource.Type.SNAPSHOT) & indexState.recoveredBytesPercent() < 100.0f) {
            ShardId shardId = shardRouting.shardId();
            Intrinsics.checkNotNullExpressionValue((Object)shardId, (String)"shardId(...)");
            return new ShardInfoResponse(shardId, "BOOTSTRAPPING", new RestoreDetails(indexState.totalBytes(), indexState.recoveredBytes(), indexState.recoveredBytesPercent(), indexState.totalFileCount(), indexState.recoveredFileCount(), indexState.recoveredFilesPercent(), indexState.startTime(), indexState.time()));
        }
        long seqNo = indexShard.getLocalCheckpoint() + 1L;
        ShardId shardId = shardRouting.shardId();
        Intrinsics.checkNotNullExpressionValue((Object)shardId, (String)"shardId(...)");
        return new ShardInfoResponse(shardId, "SYNCING", new ReplayDetails(indexShard.getLastKnownGlobalCheckpoint(), indexShard.getLastSyncedGlobalCheckpoint(), seqNo));
    }

    @Nullable
    protected ShardsIterator shards(@NotNull ClusterState clusterState, @Nullable ShardInfoRequest request, @Nullable String[] concreteIndices) {
        Intrinsics.checkNotNullParameter((Object)clusterState, (String)"clusterState");
        RoutingTable routingTable = clusterState.routingTable();
        ShardInfoRequest shardInfoRequest = request;
        Intrinsics.checkNotNull((Object)((Object)shardInfoRequest));
        List shardRoutingList = routingTable.allShards(shardInfoRequest.getIndexName());
        List shards = new ArrayList();
        List list = shardRoutingList;
        Intrinsics.checkNotNull((Object)list);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ShardRouting it = (ShardRouting)element$iv;
            boolean bl = false;
            if (!it.primary()) continue;
            Intrinsics.checkNotNull((Object)it);
            shards.add(it);
        }
        return (ShardsIterator)new PlainShardsIterator(shards);
    }

    @Nullable
    protected ClusterBlockException checkRequestBlock(@NotNull ClusterState state, @Nullable ShardInfoRequest request, @Nullable String[] concreteIndices) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return null;
    }

    @Nullable
    protected ClusterBlockException checkGlobalBlock(@Nullable ClusterState state, @Nullable ShardInfoRequest request) {
        return null;
    }

    private static final ShardInfoRequest _init_$lambda$0(StreamInput X) {
        Intrinsics.checkNotNull((Object)X);
        return new ShardInfoRequest(X);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/opensearch/replication/action/status/TranportShardsInfoAction$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "opensearch-cross-cluster-replication"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

