"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertingPlugin = void 0;
var _operators = require("rxjs/operators");
var _clusters = require("./clusters");
var _services = require("./services");
var _routes = require("../server/routes");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AlertingPlugin {
  constructor(initializerContext) {
    this.logger = initializerContext.logger.get();
    this.globalConfig$ = initializerContext.config.legacy.globalConfig$;
  }
  async setup(core, {
    dataSource
  }) {
    // Get the global configuration settings of the cluster
    const globalConfig = await this.globalConfig$.pipe((0, _operators.first)()).toPromise();
    const dataSourceEnabled = !!dataSource;

    // Create clusters
    const alertingESClient = (0, _clusters.createAlertingCluster)(core, globalConfig, dataSourceEnabled, dataSource);
    const adESClient = (0, _clusters.createAlertingADCluster)(core, globalConfig, dataSourceEnabled, dataSource);

    // Initialize services
    const alertService = new _services.AlertService(alertingESClient, dataSourceEnabled);
    const opensearchService = new _services.OpensearchService(alertingESClient, dataSourceEnabled);
    const monitorService = new _services.MonitorService(alertingESClient, dataSourceEnabled);
    const destinationsService = new _services.DestinationsService(alertingESClient, dataSourceEnabled);
    const anomalyDetectorService = new _services.AnomalyDetectorService(adESClient, dataSourceEnabled);
    const findingService = new _services.FindingService(alertingESClient, dataSourceEnabled);
    const crossClusterService = new _services.CrossClusterService(alertingESClient, dataSourceEnabled);
    const commentsService = new _services.CommentsService(alertingESClient, dataSourceEnabled);
    const services = {
      alertService,
      destinationsService,
      opensearchService,
      monitorService,
      anomalyDetectorService,
      findingService,
      crossClusterService,
      commentsService
    };

    // Create router
    const router = core.http.createRouter();
    // Add server routes
    (0, _routes.alerts)(services, router, dataSourceEnabled);
    (0, _routes.destinations)(services, router, dataSourceEnabled);
    (0, _routes.opensearch)(services, router, dataSourceEnabled);
    (0, _routes.monitors)(services, router, dataSourceEnabled);
    (0, _routes.detectors)(services, router, dataSourceEnabled);
    (0, _routes.findings)(services, router, dataSourceEnabled);
    (0, _routes.crossCluster)(services, router, dataSourceEnabled);
    (0, _routes.comments)(services, router, dataSourceEnabled);
    return {};
  }
  async start(core) {
    return {};
  }
}
exports.AlertingPlugin = AlertingPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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