/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.config;

import lombok.Generated;
import org.opensearch.cluster.ClusterName;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.spark.asyncquery.model.AsyncQueryRequestContext;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfig;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigClusterSettingLoader;
import org.opensearch.sql.spark.config.SparkExecutionEngineConfigSupplier;

public class SparkExecutionEngineConfigSupplierImpl
implements SparkExecutionEngineConfigSupplier {
    private final Settings settings;
    private final SparkExecutionEngineConfigClusterSettingLoader settingLoader;

    public SparkExecutionEngineConfig getSparkExecutionEngineConfig(AsyncQueryRequestContext asyncQueryRequestContext) {
        ClusterName clusterName = (ClusterName)this.settings.getSettingValue(Settings.Key.CLUSTER_NAME);
        return this.getBuilderFromSettingsIfAvailable().clusterName(clusterName.value()).build();
    }

    private SparkExecutionEngineConfig.SparkExecutionEngineConfigBuilder getBuilderFromSettingsIfAvailable() {
        return this.settingLoader.load().map(setting -> SparkExecutionEngineConfig.builder().applicationId(setting.getApplicationId()).executionRoleARN(setting.getExecutionRoleARN()).region(setting.getRegion())).orElse(SparkExecutionEngineConfig.builder());
    }

    @Generated
    public SparkExecutionEngineConfigSupplierImpl(Settings settings, SparkExecutionEngineConfigClusterSettingLoader settingLoader) {
        this.settings = settings;
        this.settingLoader = settingLoader;
    }
}

