/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.licensing;

import java.io.IOException;
import java.io.OutputStream;

public class BooleanOutputStream
implements AutoCloseable {
    private final OutputStream os;
    private int currentByte = 0;
    private int bitCount = 0;

    public BooleanOutputStream(OutputStream os) {
        this.os = os;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.currentByte |= 1 << this.bitCount;
        }
        ++this.bitCount;
        if (this.bitCount == 8) {
            this.flushCurrentByte();
        }
    }

    private void flushCurrentByte() throws IOException {
        this.os.write(this.currentByte);
        this.currentByte = 0;
        this.bitCount = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.bitCount > 0) {
            this.flushCurrentByte();
        }
        this.os.close();
    }
}

