/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browserCache.Expander;
import org.jetbrains.idea.svn.dialogs.browserCache.KeepingExpandedExpander;

public abstract class AbstractOpeningExpander
implements Expander {
    private final RepositoryBrowserComponent myBrowser;
    private final KeepingExpandedExpander myKeepingExpander;
    @NotNull
    private final Url mySelectionPath;

    protected AbstractOpeningExpander(RepositoryBrowserComponent browser, @NotNull Url selectionPath) {
        if (selectionPath == null) {
            AbstractOpeningExpander.$$$reportNull$$$0(0);
        }
        this.myBrowser = browser;
        this.myKeepingExpander = new KeepingExpandedExpander(browser);
        this.mySelectionPath = selectionPath;
    }

    @Override
    public void onBeforeRefresh(RepositoryTreeNode node) {
        this.myKeepingExpander.onBeforeRefresh(node);
    }

    protected abstract ExpandVariants expandNode(@NotNull Url var1);

    protected abstract boolean checkChild(@NotNull Url var1);

    @Override
    public void onAfterRefresh(RepositoryTreeNode node) {
        this.myKeepingExpander.onAfterRefresh(node);
        if (node.isLeaf()) {
            return;
        }
        ExpandVariants expandVariant = this.expandNode(node.getURL());
        if (ExpandVariants.DO_NOTHING.equals((Object)expandVariant)) {
            return;
        }
        this.myBrowser.expandNode(node);
        if (!ExpandVariants.EXPAND_AND_EXIT.equals((Object)expandVariant)) {
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                RepositoryTreeNode repositoryTreeNode;
                Url childUrl;
                TreeNode treeNode = (TreeNode)children.nextElement();
                if (!(treeNode instanceof RepositoryTreeNode) || !this.checkChild(childUrl = (repositoryTreeNode = (RepositoryTreeNode)treeNode).getURL())) continue;
                if (this.mySelectionPath.equals(childUrl)) {
                    this.myBrowser.setSelectedNode(repositoryTreeNode);
                }
                repositoryTreeNode.reload(this, false);
                return;
            }
        }
        this.removeSelf();
    }

    private void removeSelf() {
        this.myBrowser.setLazyLoadingExpander(new KeepingExpandedExpander.Factory());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionPath", "org/jetbrains/idea/svn/dialogs/browser/AbstractOpeningExpander", "<init>"));
    }

    protected static enum ExpandVariants {
        DO_NOTHING,
        EXPAND_AND_EXIT,
        EXPAND_CONTINUE;

    }
}

