/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.repository.serialization.impl;

import com.intellij.platform.runtime.repository.MalformedRepositoryException;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.serialization.RawRuntimeModuleRepositoryData;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompactFileReader {
    public static final int FORMAT_VERSION = 2;

    public static RawRuntimeModuleRepositoryData loadFromFile(@NotNull Path filePath) throws IOException {
        if (filePath == null) {
            CompactFileReader.$$$reportNull$$$0(0);
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0])));){
            int i;
            boolean hasMainPluginModule;
            int formatVersion = in.readInt();
            if (formatVersion != 2) {
                throw new MalformedRepositoryException("'" + String.valueOf(filePath) + "' has unsupported format '" + formatVersion + "'");
            }
            in.readInt();
            boolean hasBootstrapClasspath = in.readBoolean();
            if (hasBootstrapClasspath) {
                in.readUTF();
                int size = in.readInt();
                for (int i2 = 0; i2 < size; ++i2) {
                    in.readUTF();
                }
            }
            String mainPluginModuleName = (hasMainPluginModule = in.readBoolean()) ? in.readUTF() : null;
            HashMap<String, RawRuntimeModuleDescriptor> descriptors = new HashMap<String, RawRuntimeModuleDescriptor>();
            int descriptorsCount = in.readInt();
            int unresolvedDependenciesCount = in.readInt();
            int totalIdCount = descriptorsCount + unresolvedDependenciesCount;
            String[] descriptorIds = new String[totalIdCount];
            for (i = 0; i < totalIdCount; ++i) {
                descriptorIds[i] = in.readUTF();
            }
            for (i = 0; i < descriptorsCount; ++i) {
                String descriptorId = descriptorIds[i];
                int dependenciesCount = in.readInt();
                ArrayList<String> dependencies = new ArrayList<String>(dependenciesCount);
                for (int j = 0; j < dependenciesCount; ++j) {
                    int dependencyIndex = in.readInt();
                    if (dependencyIndex < 0 || dependencyIndex >= totalIdCount) {
                        throw new MalformedRepositoryException("Invalid dependency index '" + dependencyIndex + "' in '" + descriptorId + "'");
                    }
                    dependencies.add(descriptorIds[dependencyIndex]);
                }
                int resourcePathsCount = in.readInt();
                ArrayList<String> resourcePaths = new ArrayList<String>(resourcePathsCount);
                for (int j = 0; j < resourcePathsCount; ++j) {
                    resourcePaths.add(in.readUTF());
                }
                descriptors.put(descriptorId, RawRuntimeModuleDescriptor.create(descriptorId, resourcePaths, dependencies));
            }
            RawRuntimeModuleRepositoryData rawRuntimeModuleRepositoryData = new RawRuntimeModuleRepositoryData(descriptors, filePath.getParent(), mainPluginModuleName);
            return rawRuntimeModuleRepositoryData;
        }
    }

    public static @NotNull String @Nullable [] loadBootstrapClasspath(@NotNull Path binaryFile, @NotNull String bootstrapModuleName) throws IOException {
        if (binaryFile == null) {
            CompactFileReader.$$$reportNull$$$0(1);
        }
        if (bootstrapModuleName == null) {
            CompactFileReader.$$$reportNull$$$0(2);
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(binaryFile, new OpenOption[0])));){
            int formatVersion = in.readInt();
            if (formatVersion != 2) {
                String[] stringArray = null;
                return stringArray;
            }
            in.readInt();
            boolean hasBootstrap = in.readBoolean();
            if (!hasBootstrap) {
                String[] stringArray = null;
                return stringArray;
            }
            String actualBootstrapModuleName = in.readUTF();
            if (!actualBootstrapModuleName.equals(bootstrapModuleName)) {
                String[] stringArray = null;
                return stringArray;
            }
            int size = in.readInt();
            String[] classpath = new String[size];
            for (int i = 0; i < size; ++i) {
                classpath[i] = in.readUTF();
            }
            String[] stringArray = classpath;
            return stringArray;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bootstrapModuleName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/runtime/repository/serialization/impl/CompactFileReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "loadFromFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadBootstrapClasspath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

