from collections.abc import Sequence
from typing import Any

from django.apps.config import AppConfig
from django.core.checks.messages import Error, Warning

CROSS_ORIGIN_OPENER_POLICY_VALUES: set[str]
REFERRER_POLICY_VALUES: set[str]
SECRET_KEY_INSECURE_PREFIX: str
SECRET_KEY_MIN_LENGTH: int
SECRET_KEY_MIN_UNIQUE_CHARACTERS: int
SECRET_KEY_WARNING_MSG: str
W001: Warning
W002: Warning
W004: Warning
W005: Warning
W006: Warning
W008: Warning
W009: Warning
W018: Warning
W019: Warning
W020: Warning
W021: Warning
W022: Warning
E023: Error
E024: Error
W025: Warning

def check_security_middleware(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_xframe_options_middleware(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_sts(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_sts_include_subdomains(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_sts_preload(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_content_type_nosniff(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_ssl_redirect(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_secret_key(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_secret_key_fallbacks(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_debug(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_xframe_deny(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_allowed_hosts(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning]: ...
def check_referrer_policy(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Warning | Error]: ...
def check_cross_origin_opener_policy(app_configs: Sequence[AppConfig] | None, **kwargs: Any) -> Sequence[Error]: ...
