\name{LabelContourImageFilter}
\alias{LabelContourImageFilter}
\title{LabelContourImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Labels the pixels on the border of the objects in a labeled image.
LabelContourImageFilter}
\details{
LabelContourImageFilter takes a labeled image as input, where the pixels in the objects are
the pixels with a value different of the BackgroundValue. Only the
pixels on the contours of the objects are kept. The pixels not on the
border are changed to BackgroundValue. The labels of the object are
the same in the input and in the output image.
The connectivity can be changed to minimum or maximum connectivity
with SetFullyConnected() . Full connectivity produces thicker contours.
https://www.insight-journal.org/browse/publication/217
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
BinaryContourImageFilter
LabelContour for the procedural interface
itk::LabelContourImageFilter for the Doxygen on the original ITK class.
LabelContourImageFilter}
%C++ includes: sitkLabelContourImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetBackgroundValue() const:}{
Set/Get the background value used to identify the objects and mark the
pixels not on the border of the objects.
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff.
For objects that are 1 pixel wide, use FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ LabelContourImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the background value used to identify the objects and mark the
pixels not on the border of the objects.
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff.
For objects that are 1 pixel wide, use FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~LabelContourImageFilter():}{
Destructor
}
}
}
