/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBaseBounds;
import org.apache.lucene.spatial3d.geom.GeoBasePath;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.SerializableObject;
import org.apache.lucene.spatial3d.geom.SidedPlane;
import org.apache.lucene.spatial3d.geom.Vector;
import org.apache.lucene.spatial3d.geom.XYZBounds;

class GeoStandardPath
extends GeoBasePath {
    protected final double cutoffAngle;
    protected final double sinAngle;
    protected final double cosAngle;
    protected final List<GeoPoint> points = new ArrayList<GeoPoint>();
    protected PathComponent rootComponent;
    protected GeoPoint[] edgePoints;
    protected boolean isDone = false;

    public GeoStandardPath(PlanetModel planetModel, double maxCutoffAngle, GeoPoint[] pathPoints) {
        this(planetModel, maxCutoffAngle);
        Collections.addAll(this.points, pathPoints);
        this.done();
    }

    public GeoStandardPath(PlanetModel planetModel, double maxCutoffAngle) {
        super(planetModel);
        if (maxCutoffAngle <= 0.0 || maxCutoffAngle > 1.5707963267948966) {
            throw new IllegalArgumentException("Cutoff angle out of bounds");
        }
        this.cutoffAngle = maxCutoffAngle;
        this.cosAngle = Math.cos(maxCutoffAngle);
        this.sinAngle = Math.sin(maxCutoffAngle);
    }

    public void addPoint(double lat, double lon) {
        if (this.isDone) {
            throw new IllegalStateException("Can't call addPoint() if done() already called");
        }
        this.points.add(new GeoPoint(this.planetModel, lat, lon));
    }

    public void done() {
        if (this.isDone) {
            throw new IllegalStateException("Can't call done() twice");
        }
        if (this.points.size() == 0) {
            throw new IllegalArgumentException("Path must have at least one point");
        }
        this.isDone = true;
        ArrayList<BaseSegmentEndpoint> endPoints = new ArrayList<BaseSegmentEndpoint>(this.points.size());
        ArrayList<PathSegment> segments = new ArrayList<PathSegment>(this.points.size());
        double cutoffOffset = this.sinAngle * this.planetModel.getMinimumMagnitude();
        GeoPoint lastPoint = null;
        PathSegment lastComponent = null;
        for (GeoPoint end : this.points) {
            if (lastPoint != null) {
                Plane normalizedConnectingPlane = new Plane((Vector)lastPoint, end);
                PathSegment newComponent = new PathSegment(this.planetModel, lastComponent, lastPoint, end, normalizedConnectingPlane, cutoffOffset);
                segments.add(newComponent);
                lastComponent = newComponent;
            }
            lastPoint = end;
        }
        if (segments.size() == 0) {
            double lat = this.points.get(0).getLatitude();
            double lon = this.points.get(0).getLongitude();
            double upperLat = lat + this.cutoffAngle;
            double upperLon = lon;
            if (upperLat > 1.5707963267948966) {
                if ((upperLon += Math.PI) > Math.PI) {
                    upperLon -= Math.PI * 2;
                }
                upperLat = Math.PI - upperLat;
            }
            double lowerLat = lat - this.cutoffAngle;
            double lowerLon = lon;
            if (lowerLat < -1.5707963267948966) {
                if ((lowerLon += Math.PI) > Math.PI) {
                    lowerLon -= Math.PI * 2;
                }
                lowerLat = -Math.PI - lowerLat;
            }
            GeoPoint upperPoint = new GeoPoint(this.planetModel, upperLat, upperLon);
            GeoPoint lowerPoint = new GeoPoint(this.planetModel, lowerLat, lowerLon);
            GeoPoint point = this.points.get(0);
            Plane normalPlane = Plane.constructNormalizedZPlane(upperPoint, lowerPoint, point);
            CircleSegmentEndpoint onlyEndpoint = new CircleSegmentEndpoint(this.planetModel, null, point, normalPlane, upperPoint, lowerPoint);
            endPoints.add(onlyEndpoint);
            this.edgePoints = new GeoPoint[]{onlyEndpoint.circlePlane.getSampleIntersectionPoint(this.planetModel, normalPlane)};
        } else {
            for (int i = 0; i < segments.size(); ++i) {
                PathSegment currentSegment = (PathSegment)segments.get(i);
                if (i == 0) {
                    CutoffSingleCircleSegmentEndpoint startEndpoint = new CutoffSingleCircleSegmentEndpoint(this.planetModel, null, currentSegment.start, currentSegment.startCutoffPlane, currentSegment.ULHC, currentSegment.LLHC);
                    endPoints.add(startEndpoint);
                    this.edgePoints = new GeoPoint[]{currentSegment.ULHC};
                    continue;
                }
                PathSegment prevSegment = (PathSegment)segments.get(i - 1);
                endPoints.add(new CutoffDualCircleSegmentEndpoint(this.planetModel, prevSegment, currentSegment.start, prevSegment.endCutoffPlane, currentSegment.startCutoffPlane, prevSegment.URHC, prevSegment.LRHC, currentSegment.ULHC, currentSegment.LLHC));
            }
            PathSegment lastSegment = (PathSegment)segments.get(segments.size() - 1);
            endPoints.add(new CutoffSingleCircleSegmentEndpoint(this.planetModel, (PathComponent)lastSegment, lastSegment.end, lastSegment.endCutoffPlane, lastSegment.URHC, lastSegment.LRHC));
        }
        TreeBuilder treeBuilder = new TreeBuilder(segments.size() + endPoints.size());
        treeBuilder.addComponent((PathComponent)endPoints.get(0));
        for (int i = 0; i < segments.size(); ++i) {
            treeBuilder.addComponent((PathComponent)segments.get(i));
            treeBuilder.addComponent((PathComponent)endPoints.get(i + 1));
        }
        this.rootComponent = treeBuilder.getRoot();
    }

    public GeoStandardPath(PlanetModel planetModel, InputStream inputStream) throws IOException {
        this(planetModel, SerializableObject.readDouble(inputStream), SerializableObject.readPointArray(planetModel, inputStream));
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        SerializableObject.writeDouble(outputStream, this.cutoffAngle);
        SerializableObject.writePointArray(outputStream, this.points);
    }

    @Override
    public double computePathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.rootComponent == null) {
            return Double.POSITIVE_INFINITY;
        }
        return distanceStyle.fromAggregationForm(this.rootComponent.pathCenterDistance(distanceStyle, x, y, z));
    }

    @Override
    public double computeNearestDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.rootComponent == null) {
            return Double.POSITIVE_INFINITY;
        }
        DistancePair distancePair = this.rootComponent.nearestDistance(distanceStyle, x, y, z);
        if (distancePair == null) {
            return Double.POSITIVE_INFINITY;
        }
        return distanceStyle.fromAggregationForm(distancePair.distanceAlongPath);
    }

    @Override
    protected double distance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.rootComponent == null) {
            return Double.POSITIVE_INFINITY;
        }
        return distanceStyle.fromAggregationForm(this.rootComponent.distance(distanceStyle, x, y, z));
    }

    @Override
    protected double deltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.rootComponent == null) {
            return Double.POSITIVE_INFINITY;
        }
        return distanceStyle.fromAggregationForm(this.rootComponent.pathDeltaDistance(distanceStyle, x, y, z));
    }

    @Override
    protected void distanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        this.getBounds(bounds);
    }

    @Override
    protected double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (this.rootComponent == null) {
            return Double.POSITIVE_INFINITY;
        }
        return distanceStyle.fromAggregationForm(this.rootComponent.outsideDistance(distanceStyle, x, y, z));
    }

    @Override
    public boolean isWithin(double x, double y, double z) {
        if (this.rootComponent == null) {
            return false;
        }
        return this.rootComponent.isWithin(x, y, z);
    }

    @Override
    public GeoPoint[] getEdgePoints() {
        return this.edgePoints;
    }

    @Override
    public boolean intersects(Plane plane, GeoPoint[] notablePoints, Membership ... bounds) {
        if (this.rootComponent == null) {
            return false;
        }
        XYZBounds planeBounds = null;
        return this.rootComponent.intersects(plane, planeBounds, notablePoints, bounds);
    }

    @Override
    public boolean intersects(GeoShape geoShape) {
        if (this.rootComponent == null) {
            return false;
        }
        return this.rootComponent.intersects(geoShape);
    }

    @Override
    public void getBounds(Bounds bounds) {
        super.getBounds(bounds);
        if (this.rootComponent != null) {
            this.rootComponent.getBounds(bounds);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GeoStandardPath)) {
            return false;
        }
        GeoStandardPath p = (GeoStandardPath)o;
        if (!super.equals(p)) {
            return false;
        }
        if (this.cutoffAngle != p.cutoffAngle) {
            return false;
        }
        return this.points.equals(p.points);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.cutoffAngle);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        return "GeoStandardPath: {planetmodel=" + String.valueOf(this.planetModel) + ", width=" + this.cutoffAngle + "(" + this.cutoffAngle * 180.0 / Math.PI + "), points={" + String.valueOf(this.points) + "}}";
    }

    private static class TreeBuilder {
        private final List<PathComponent> componentStack;
        private final IntArrayList depthStack;

        public TreeBuilder(int max) {
            this.componentStack = new ArrayList<PathComponent>(max);
            this.depthStack = new IntArrayList(max);
        }

        public void addComponent(PathComponent component) {
            this.componentStack.add(component);
            this.depthStack.add(0);
            while (this.depthStack.size() >= 2 && this.depthStack.get(this.depthStack.size() - 1) == this.depthStack.get(this.depthStack.size() - 2)) {
                this.mergeTop();
            }
        }

        public PathComponent getRoot() {
            if (this.componentStack.size() == 0) {
                return null;
            }
            while (this.componentStack.size() > 1) {
                this.mergeTop();
            }
            return this.componentStack.get(0);
        }

        private void mergeTop() {
            this.depthStack.removeAt(this.depthStack.size() - 1);
            PathComponent secondComponent = this.componentStack.remove(this.componentStack.size() - 1);
            int newDepth = this.depthStack.removeAt(this.depthStack.size() - 1) + 1;
            PathComponent firstComponent = this.componentStack.remove(this.componentStack.size() - 1);
            this.depthStack.add(newDepth);
            this.componentStack.add(new PathNode(firstComponent, secondComponent));
        }
    }

    private static class PathSegment
    extends GeoBaseBounds
    implements PathComponent {
        public final PathComponent previous;
        public final GeoPoint start;
        public final GeoPoint end;
        public final Map<DistanceStyle, Double> startDistanceCache = new ConcurrentHashMap<DistanceStyle, Double>(1);
        public final Plane normalizedConnectingPlane;
        public final SidedPlane upperConnectingPlane;
        public final SidedPlane lowerConnectingPlane;
        public final SidedPlane startCutoffPlane;
        public final SidedPlane endCutoffPlane;
        public final GeoPoint URHC;
        public final GeoPoint LRHC;
        public final GeoPoint ULHC;
        public final GeoPoint LLHC;
        public final GeoPoint[] upperConnectingPlanePoints;
        public final GeoPoint[] lowerConnectingPlanePoints;

        public PathSegment(PlanetModel planetModel, PathComponent previous, GeoPoint start, GeoPoint end, Plane normalizedConnectingPlane, double planeBoundingOffset) {
            super(planetModel);
            this.previous = previous;
            this.start = start;
            this.end = end;
            this.normalizedConnectingPlane = normalizedConnectingPlane;
            this.upperConnectingPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, -planeBoundingOffset);
            this.lowerConnectingPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, planeBoundingOffset);
            assert (this.upperConnectingPlane.isWithin(start));
            assert (this.upperConnectingPlane.isWithin(end));
            assert (this.lowerConnectingPlane.isWithin(start));
            assert (this.lowerConnectingPlane.isWithin(end));
            this.startCutoffPlane = new SidedPlane((Vector)end, (Vector)normalizedConnectingPlane, start);
            assert (this.startCutoffPlane.isWithin(end));
            assert (this.startCutoffPlane.isWithin(start));
            this.endCutoffPlane = new SidedPlane((Vector)start, (Vector)normalizedConnectingPlane, end);
            assert (this.endCutoffPlane.isWithin(start));
            assert (this.endCutoffPlane.isWithin(end));
            Membership[] upperSide = new Membership[]{this.upperConnectingPlane};
            Membership[] lowerSide = new Membership[]{this.lowerConnectingPlane};
            Membership[] startSide = new Membership[]{this.startCutoffPlane};
            Membership[] endSide = new Membership[]{this.endCutoffPlane};
            GeoPoint[] points = this.upperConnectingPlane.findIntersections(planetModel, (Plane)this.startCutoffPlane, lowerSide, endSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.ULHC = points[0];
            points = this.upperConnectingPlane.findIntersections(planetModel, (Plane)this.endCutoffPlane, lowerSide, startSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.URHC = points[0];
            points = this.lowerConnectingPlane.findIntersections(planetModel, (Plane)this.startCutoffPlane, upperSide, endSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.LLHC = points[0];
            points = this.lowerConnectingPlane.findIntersections(planetModel, (Plane)this.endCutoffPlane, upperSide, startSide);
            if (points.length == 0) {
                throw new IllegalArgumentException("Some segment boundary points are off the ellipsoid; path too wide");
            }
            if (points.length > 1) {
                throw new IllegalArgumentException("Ambiguous boundary points; path too short");
            }
            this.LRHC = points[0];
            this.upperConnectingPlanePoints = new GeoPoint[]{this.ULHC, this.URHC};
            this.lowerConnectingPlanePoints = new GeoPoint[]{this.LLHC, this.LRHC};
        }

        @Override
        public double fullPathDistance(DistanceStyle distanceStyle) {
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, this.end.x, this.end.y, this.end.z));
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.startCutoffPlane.isWithin(x, y, z) && this.endCutoffPlane.isWithin(x, y, z) && this.upperConnectingPlane.isWithin(x, y, z) && this.lowerConnectingPlane.isWithin(x, y, z);
        }

        @Override
        public boolean isWithin(Vector v) {
            return this.isWithin(v.x, v.y, v.z);
        }

        @Override
        public boolean isWithinSection(Vector point) {
            return this.startCutoffPlane.isWithin(point) && this.endCutoffPlane.isWithin(point);
        }

        @Override
        public boolean isWithinSection(double x, double y, double z) {
            return this.startCutoffPlane.isWithin(x, y, z) && this.endCutoffPlane.isWithin(x, y, z);
        }

        @Override
        public double getStartingDistance(DistanceStyle distanceStyle) {
            Double dist = this.startDistanceCache.get(distanceStyle);
            if (dist == null) {
                dist = this.computeStartingDistance(distanceStyle);
                this.startDistanceCache.put(distanceStyle, dist);
            }
            return dist;
        }

        @Override
        public double distance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double startingDistance = this.getStartingDistance(distanceStyle);
            double pathDistance = this.pathDistance(distanceStyle, x, y, z);
            return distanceStyle.fromAggregationForm(distanceStyle.aggregateDistances(startingDistance, pathDistance));
        }

        @Override
        public DistancePair nearestDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return null;
            }
            DistancePair rval = new DistancePair(this.pathCenterDistance(distanceStyle, x, y, z), distanceStyle.aggregateDistances(this.getStartingDistance(distanceStyle), this.nearestPathDistance(distanceStyle, x, y, z)));
            return rval;
        }

        private double computeStartingDistance(DistanceStyle distanceStyle) {
            if (this.previous == null) {
                return 0.0;
            }
            return distanceStyle.aggregateDistances(this.previous.getStartingDistance(distanceStyle), this.previous.fullPathDistance(distanceStyle));
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.computeDistance(this.start, x, y, z);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(this.planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(thePoint, x, y, z));
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.toAggregationForm(0.0);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(this.planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z));
        }

        @Override
        public double pathDeltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                double theDistance = distanceStyle.computeDistance(this.start, x, y, z);
                return distanceStyle.aggregateDistances(theDistance, theDistance);
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(this.planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            double theDistance = distanceStyle.toAggregationForm(distanceStyle.computeDistance(thePoint, x, y, z));
            return distanceStyle.aggregateDistances(theDistance, theDistance);
        }

        @Override
        public double pathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            GeoPoint thePoint;
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double perpX = this.normalizedConnectingPlane.y * z - this.normalizedConnectingPlane.z * y;
            double perpY = this.normalizedConnectingPlane.z * x - this.normalizedConnectingPlane.x * z;
            double perpZ = this.normalizedConnectingPlane.x * y - this.normalizedConnectingPlane.y * x;
            double magnitude = Math.sqrt(perpX * perpX + perpY * perpY + perpZ * perpZ);
            if (Math.abs(magnitude) < 1.0E-12) {
                return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, x, y, z));
            }
            double normFactor = 1.0 / magnitude;
            Plane normalizedPerpPlane = new Plane(perpX * normFactor, perpY * normFactor, perpZ * normFactor, 0.0);
            GeoPoint[] intersectionPoints = this.normalizedConnectingPlane.findIntersections(this.planetModel, normalizedPerpPlane, new Membership[0]);
            if (intersectionPoints.length == 0) {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            if (intersectionPoints.length == 1) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[0]) && this.endCutoffPlane.isWithin(intersectionPoints[0])) {
                thePoint = intersectionPoints[0];
            } else if (this.startCutoffPlane.isWithin(intersectionPoints[1]) && this.endCutoffPlane.isWithin(intersectionPoints[1])) {
                thePoint = intersectionPoints[1];
            } else {
                throw new RuntimeException("Can't find world intersection for point x=" + x + " y=" + y + " z=" + z);
            }
            return distanceStyle.aggregateDistances(distanceStyle.toAggregationForm(distanceStyle.computeDistance(thePoint, x, y, z)), distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.start, thePoint.x, thePoint.y, thePoint.z)));
        }

        @Override
        public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            double upperDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.upperConnectingPlane, x, y, z, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            double lowerDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.lowerConnectingPlane, x, y, z, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
            double startDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.startCutoffPlane, x, y, z, this.endCutoffPlane, this.lowerConnectingPlane, this.upperConnectingPlane);
            double endDistance = distanceStyle.computeDistance(this.planetModel, (Plane)this.endCutoffPlane, x, y, z, this.startCutoffPlane, this.lowerConnectingPlane, this.upperConnectingPlane);
            double ULHCDistance = distanceStyle.computeDistance(this.ULHC, x, y, z);
            double URHCDistance = distanceStyle.computeDistance(this.URHC, x, y, z);
            double LLHCDistance = distanceStyle.computeDistance(this.LLHC, x, y, z);
            double LRHCDistance = distanceStyle.computeDistance(this.LRHC, x, y, z);
            return distanceStyle.toAggregationForm(Math.min(Math.min(Math.min(upperDistance, lowerDistance), Math.min(startDistance, endDistance)), Math.min(Math.min(ULHCDistance, URHCDistance), Math.min(LLHCDistance, LRHCDistance))));
        }

        @Override
        public boolean intersects(Plane p, XYZBounds planeBounds, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.upperConnectingPlane.intersects(this.planetModel, p, notablePoints, this.upperConnectingPlanePoints, bounds, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane) || this.lowerConnectingPlane.intersects(this.planetModel, p, notablePoints, this.lowerConnectingPlanePoints, bounds, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.upperConnectingPlane, this.upperConnectingPlanePoints, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane) || geoShape.intersects(this.lowerConnectingPlane, this.lowerConnectingPlanePoints, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane);
        }

        @Override
        public void getBounds(Bounds bounds) {
            super.getBounds(bounds);
            bounds.addPoint(this.start).addPoint(this.end).addPoint(this.ULHC).addPoint(this.URHC).addPoint(this.LRHC).addPoint(this.LLHC).addPlane(this.planetModel, this.upperConnectingPlane, this.lowerConnectingPlane, this.startCutoffPlane, this.endCutoffPlane).addPlane(this.planetModel, this.lowerConnectingPlane, this.upperConnectingPlane, this.startCutoffPlane, this.endCutoffPlane).addPlane(this.planetModel, this.startCutoffPlane, this.endCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane).addPlane(this.planetModel, this.endCutoffPlane, this.startCutoffPlane, this.upperConnectingPlane, this.lowerConnectingPlane).addIntersection(this.planetModel, this.upperConnectingPlane, this.startCutoffPlane, this.lowerConnectingPlane, this.endCutoffPlane).addIntersection(this.planetModel, this.startCutoffPlane, this.lowerConnectingPlane, this.endCutoffPlane, this.upperConnectingPlane).addIntersection(this.planetModel, this.lowerConnectingPlane, this.endCutoffPlane, this.upperConnectingPlane, this.startCutoffPlane).addIntersection(this.planetModel, this.endCutoffPlane, this.upperConnectingPlane, this.startCutoffPlane, this.lowerConnectingPlane);
        }

        public String toString() {
            return "PathSegment (" + String.valueOf(this.ULHC) + ", " + String.valueOf(this.URHC) + ", " + String.valueOf(this.LRHC) + ", " + String.valueOf(this.LLHC) + ")";
        }
    }

    private static class CutoffDualCircleSegmentEndpoint
    extends BaseSegmentEndpoint {
        protected final SidedPlane circlePlane1;
        protected final SidedPlane circlePlane2;
        protected final GeoPoint[] notablePoints1;
        protected final GeoPoint[] notablePoints2;
        protected final Membership[] cutoffPlanes;
        protected final SidedPlane boundaryPlane1;
        protected final SidedPlane boundaryPlane2;

        public CutoffDualCircleSegmentEndpoint(PlanetModel planetModel, PathComponent previous, GeoPoint point, SidedPlane prevCutoffPlane, SidedPlane nextCutoffPlane, GeoPoint prevURHC, GeoPoint prevLRHC, GeoPoint currentULHC, GeoPoint currentLLHC) {
            super(planetModel, previous, point);
            if (!prevCutoffPlane.isWithin(currentULHC)) {
                this.circlePlane1 = SidedPlane.constructNormalizedThreePointSidedPlane(point, prevURHC, prevLRHC, currentULHC);
                this.notablePoints1 = new GeoPoint[]{prevURHC, prevLRHC, currentULHC};
            } else if (!prevCutoffPlane.isWithin(currentLLHC)) {
                this.circlePlane1 = SidedPlane.constructNormalizedThreePointSidedPlane(point, prevURHC, prevLRHC, currentLLHC);
                this.notablePoints1 = new GeoPoint[]{prevURHC, prevLRHC, currentLLHC};
            } else {
                this.circlePlane1 = SidedPlane.constructSidedPlaneFromTwoPoints(point, prevURHC, prevLRHC);
                this.notablePoints1 = new GeoPoint[]{prevURHC, prevLRHC};
            }
            if (!nextCutoffPlane.isWithin(prevURHC)) {
                this.circlePlane2 = SidedPlane.constructNormalizedThreePointSidedPlane(point, currentULHC, currentLLHC, prevURHC);
                this.notablePoints2 = new GeoPoint[]{currentULHC, currentLLHC, prevURHC};
            } else if (!nextCutoffPlane.isWithin(prevLRHC)) {
                this.circlePlane2 = SidedPlane.constructNormalizedThreePointSidedPlane(point, currentULHC, currentLLHC, prevLRHC);
                this.notablePoints2 = new GeoPoint[]{currentULHC, currentLLHC, prevLRHC};
            } else {
                this.circlePlane2 = SidedPlane.constructSidedPlaneFromTwoPoints(point, currentULHC, currentLLHC);
                this.notablePoints2 = new GeoPoint[]{currentULHC, currentLLHC};
            }
            this.boundaryPlane1 = new SidedPlane(prevCutoffPlane);
            this.boundaryPlane2 = new SidedPlane(nextCutoffPlane);
            this.cutoffPlanes = new Membership[]{this.boundaryPlane1, this.boundaryPlane2};
        }

        @Override
        public boolean isWithin(Vector point) {
            for (Membership m : this.cutoffPlanes) {
                if (m.isWithin(point)) continue;
                return false;
            }
            return this.circlePlane1.isWithin(point) || this.circlePlane2.isWithin(point);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            for (Membership m : this.cutoffPlanes) {
                if (m.isWithin(x, y, z)) continue;
                return false;
            }
            return this.circlePlane1.isWithin(x, y, z) || this.circlePlane2.isWithin(x, y, z);
        }

        @Override
        public boolean isWithinSection(Vector point) {
            for (Membership m : this.cutoffPlanes) {
                if (m.isWithin(point)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isWithinSection(double x, double y, double z) {
            for (Membership m : this.cutoffPlanes) {
                if (m.isWithin(x, y, z)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean intersects(Plane p, XYZBounds planeBounds, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane1.intersects(this.planetModel, p, notablePoints, this.notablePoints1, bounds, this.cutoffPlanes) || this.circlePlane2.intersects(this.planetModel, p, notablePoints, this.notablePoints2, bounds, this.cutoffPlanes);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.circlePlane1, this.notablePoints1, this.cutoffPlanes) || geoShape.intersects(this.circlePlane2, this.notablePoints2, this.cutoffPlanes);
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return super.nearestPathDistance(distanceStyle, x, y, z);
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return super.pathCenterDistance(distanceStyle, x, y, z);
        }

        @Override
        public void getBounds(Bounds bounds) {
            super.getBounds(bounds);
            bounds.addPlane(this.planetModel, this.circlePlane1, this.boundaryPlane1, this.boundaryPlane2);
            bounds.addPlane(this.planetModel, this.circlePlane2, this.boundaryPlane1, this.boundaryPlane2);
            bounds.addPlane(this.planetModel, this.boundaryPlane1, this.circlePlane1, this.boundaryPlane2);
            bounds.addPlane(this.planetModel, this.boundaryPlane1, this.circlePlane2, this.boundaryPlane2);
            bounds.addPlane(this.planetModel, this.boundaryPlane2, this.circlePlane1, this.boundaryPlane1);
            bounds.addPlane(this.planetModel, this.boundaryPlane2, this.circlePlane2, this.boundaryPlane1);
            bounds.addIntersection(this.planetModel, this.circlePlane1, this.boundaryPlane1, this.boundaryPlane2);
            bounds.addIntersection(this.planetModel, this.circlePlane1, this.boundaryPlane2, this.boundaryPlane1);
            bounds.addIntersection(this.planetModel, this.circlePlane2, this.boundaryPlane1, this.boundaryPlane2);
            bounds.addIntersection(this.planetModel, this.circlePlane2, this.boundaryPlane2, this.boundaryPlane1);
        }

        @Override
        public String toString() {
            return "CutoffDualCircleSegmentEndpoint: " + super.toString();
        }
    }

    private static class CutoffSingleCircleSegmentEndpoint
    extends CircleSegmentEndpoint {
        protected final Membership[] cutoffPlanes;
        private final GeoPoint[] notablePoints;
        private final SidedPlane cutoffPlane;

        public CutoffSingleCircleSegmentEndpoint(PlanetModel planetModel, PathComponent previous, GeoPoint point, SidedPlane cutoffPlane, GeoPoint topEdgePoint, GeoPoint bottomEdgePoint) {
            super(planetModel, previous, point, topEdgePoint, bottomEdgePoint);
            this.cutoffPlane = new SidedPlane(cutoffPlane);
            this.cutoffPlanes = new Membership[]{this.cutoffPlane};
            this.notablePoints = new GeoPoint[]{topEdgePoint, bottomEdgePoint};
        }

        @Override
        public boolean isWithin(Vector point) {
            return this.cutoffPlane.isWithin(point) && super.isWithin(point);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.cutoffPlane.isWithin(x, y, z) && super.isWithin(x, y, z);
        }

        @Override
        public boolean isWithinSection(Vector point) {
            return this.cutoffPlane.isWithin(point);
        }

        @Override
        public boolean isWithinSection(double x, double y, double z) {
            return this.cutoffPlane.isWithin(x, y, z);
        }

        @Override
        public boolean intersects(Plane p, XYZBounds planeBounds, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane.intersects(this.planetModel, p, notablePoints, this.notablePoints, bounds, this.cutoffPlanes);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.circlePlane, this.notablePoints, this.cutoffPlanes);
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return super.nearestPathDistance(distanceStyle, x, y, z);
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return super.pathCenterDistance(distanceStyle, x, y, z);
        }

        @Override
        public void getBounds(Bounds bounds) {
            super.getBounds(bounds);
            bounds.addPlane(this.planetModel, this.circlePlane, this.cutoffPlane);
            bounds.addPlane(this.planetModel, this.cutoffPlane, this.circlePlane);
            bounds.addIntersection(this.planetModel, this.circlePlane, this.cutoffPlane, new Membership[0]);
            bounds.addIntersection(this.planetModel, this.cutoffPlane, this.circlePlane, new Membership[0]);
        }

        @Override
        public String toString() {
            return "CutoffSingleCircleSegmentEndpoint: " + super.toString();
        }
    }

    private static class CircleSegmentEndpoint
    extends BaseSegmentEndpoint {
        protected final SidedPlane circlePlane;
        protected static final GeoPoint[] circlePoints = new GeoPoint[0];

        public CircleSegmentEndpoint(PlanetModel planetModel, PathComponent previous, GeoPoint point, GeoPoint upperPoint, GeoPoint lowerPoint) {
            super(planetModel, previous, point);
            this.circlePlane = SidedPlane.constructSidedPlaneFromTwoPoints(point, upperPoint, lowerPoint);
            assert (this.circlePlane.isWithin(point));
        }

        public CircleSegmentEndpoint(PlanetModel planetModel, PathComponent previous, GeoPoint point, Plane normalPlane, GeoPoint upperPoint, GeoPoint lowerPoint) {
            super(planetModel, previous, point);
            this.circlePlane = SidedPlane.constructNormalizedPerpendicularSidedPlane(point, normalPlane, upperPoint, lowerPoint);
            assert (this.circlePlane.isWithin(point));
        }

        protected CircleSegmentEndpoint(PlanetModel planetModel, PathComponent previous, GeoPoint point, SidedPlane circlePlane) {
            super(planetModel, previous, point);
            this.circlePlane = circlePlane;
        }

        @Override
        public boolean isWithin(Vector point) {
            return this.circlePlane.isWithin(point);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return this.circlePlane.isWithin(x, y, z);
        }

        @Override
        public boolean intersects(Plane p, XYZBounds planeBounds, GeoPoint[] notablePoints, Membership[] bounds) {
            return this.circlePlane.intersects(this.planetModel, p, notablePoints, circlePoints, bounds, new Membership[0]);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return geoShape.intersects(this.circlePlane, circlePoints, NO_MEMBERSHIP);
        }

        @Override
        public void getBounds(Bounds bounds) {
            super.getBounds(bounds);
            bounds.addPlane(this.planetModel, this.circlePlane, new Membership[0]);
        }

        @Override
        public String toString() {
            return "CircleSegmentEndpoint: " + super.toString();
        }
    }

    private static class BaseSegmentEndpoint
    extends GeoBaseBounds
    implements SegmentEndpoint {
        protected final PathComponent previous;
        protected final GeoPoint point;
        protected static final Membership[] NO_MEMBERSHIP = new Membership[0];

        public BaseSegmentEndpoint(PlanetModel planetModel, PathComponent previous, GeoPoint point) {
            super(planetModel);
            this.previous = previous;
            this.point = point;
        }

        @Override
        public boolean isWithin(Vector point) {
            return false;
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            return false;
        }

        @Override
        public boolean isWithinSection(double x, double y, double z) {
            return true;
        }

        @Override
        public boolean isWithinSection(Vector point) {
            return true;
        }

        @Override
        public double getStartingDistance(DistanceStyle distanceStyle) {
            if (this.previous == null) {
                return distanceStyle.toAggregationForm(0.0);
            }
            return distanceStyle.aggregateDistances(this.previous.getStartingDistance(distanceStyle), this.previous.fullPathDistance(distanceStyle));
        }

        @Override
        public double distance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double startingDistance = this.getStartingDistance(distanceStyle);
            double pathDistance = this.pathDistance(distanceStyle, x, y, z);
            return distanceStyle.aggregateDistances(startingDistance, pathDistance);
        }

        @Override
        public DistancePair nearestDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return null;
            }
            DistancePair rval = new DistancePair(this.pathCenterDistance(distanceStyle, x, y, z), distanceStyle.aggregateDistances(this.getStartingDistance(distanceStyle), this.nearestPathDistance(distanceStyle, x, y, z)));
            return rval;
        }

        @Override
        public double fullPathDistance(DistanceStyle distanceStyle) {
            return distanceStyle.toAggregationForm(0.0);
        }

        @Override
        public double pathDeltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double theDistance = distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
            return distanceStyle.aggregateDistances(theDistance, theDistance);
        }

        @Override
        public double pathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return distanceStyle.toAggregationForm(0.0);
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithinSection(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
        }

        @Override
        public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return distanceStyle.toAggregationForm(distanceStyle.computeDistance(this.point, x, y, z));
        }

        @Override
        public boolean intersects(Plane p, XYZBounds planeBounds, GeoPoint[] notablePoints, Membership[] bounds) {
            return false;
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return false;
        }

        @Override
        public void getBounds(Bounds bounds) {
            super.getBounds(bounds);
            bounds.addPoint(this.point);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof BaseSegmentEndpoint)) {
                return false;
            }
            BaseSegmentEndpoint other = (BaseSegmentEndpoint)o;
            return this.point.equals(other.point) && this.planetModel.equals(other.planetModel);
        }

        @Override
        public int hashCode() {
            return this.point.hashCode() + this.planetModel.hashCode();
        }

        public String toString() {
            return "SegmentEndpoint (" + String.valueOf(this.point) + ")";
        }
    }

    private static interface SegmentEndpoint
    extends PathComponent {
    }

    private static class PathNode
    implements PathComponent {
        protected final PathComponent child1;
        protected final PathComponent child2;
        protected final XYZBounds bounds;

        public PathNode(PathComponent child1, PathComponent child2) {
            this.child1 = child1;
            this.child2 = child2;
            this.bounds = new XYZBounds();
            child1.getBounds(this.bounds);
            child2.getBounds(this.bounds);
        }

        @Override
        public boolean isWithin(Vector point) {
            return this.isWithin(point.x, point.y, point.z);
        }

        @Override
        public boolean isWithin(double x, double y, double z) {
            if (x < this.bounds.getMinimumX() || x > this.bounds.getMaximumX() || y < this.bounds.getMinimumY() || y > this.bounds.getMaximumY() || z < this.bounds.getMinimumZ() || z > this.bounds.getMaximumZ()) {
                return false;
            }
            return this.child1.isWithin(x, y, z) || this.child2.isWithin(x, y, z);
        }

        @Override
        public boolean isWithinSection(Vector point) {
            return this.child1.isWithinSection(point) || this.child2.isWithinSection(point);
        }

        @Override
        public boolean isWithinSection(double x, double y, double z) {
            return this.child1.isWithinSection(x, y, z) || this.child2.isWithinSection(x, y, z);
        }

        @Override
        public double getStartingDistance(DistanceStyle distanceStyle) {
            return this.child1.getStartingDistance(distanceStyle);
        }

        @Override
        public double distance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            double child1Distance = this.child1.distance(distanceStyle, x, y, z);
            double child2Distance = this.child2.distance(distanceStyle, x, y, z);
            return Math.min(child1Distance, child2Distance);
        }

        @Override
        public DistancePair nearestDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            DistancePair firstChildDistance = this.child1.nearestDistance(distanceStyle, x, y, z);
            DistancePair secondChildDistance = this.child2.nearestDistance(distanceStyle, x, y, z);
            if (firstChildDistance == null) {
                return secondChildDistance;
            }
            if (secondChildDistance == null) {
                return firstChildDistance;
            }
            if (firstChildDistance.pathCenterDistance < secondChildDistance.pathCenterDistance) {
                return firstChildDistance;
            }
            if (secondChildDistance.pathCenterDistance < firstChildDistance.pathCenterDistance) {
                return secondChildDistance;
            }
            if (firstChildDistance.distanceAlongPath < secondChildDistance.distanceAlongPath) {
                return firstChildDistance;
            }
            return secondChildDistance;
        }

        @Override
        public double fullPathDistance(DistanceStyle distanceStyle) {
            return distanceStyle.aggregateDistances(this.child1.fullPathDistance(distanceStyle), this.child2.fullPathDistance(distanceStyle));
        }

        @Override
        public double pathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.min(this.child1.pathDistance(distanceStyle, x, y, z), distanceStyle.aggregateDistances(this.child1.fullPathDistance(distanceStyle), this.child2.pathDistance(distanceStyle, x, y, z)));
        }

        @Override
        public double pathDeltaDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            if (!this.isWithin(x, y, z)) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.min(this.child1.pathDeltaDistance(distanceStyle, x, y, z), this.child2.pathDeltaDistance(distanceStyle, x, y, z));
        }

        @Override
        public double nearestPathDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return Math.min(this.child1.nearestPathDistance(distanceStyle, x, y, z), this.child2.nearestPathDistance(distanceStyle, x, y, z));
        }

        @Override
        public double pathCenterDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return Math.min(this.child1.pathCenterDistance(distanceStyle, x, y, z), this.child2.pathCenterDistance(distanceStyle, x, y, z));
        }

        @Override
        public double outsideDistance(DistanceStyle distanceStyle, double x, double y, double z) {
            return Math.min(this.child1.outsideDistance(distanceStyle, x, y, z), this.child2.outsideDistance(distanceStyle, x, y, z));
        }

        @Override
        public boolean intersects(Plane p, XYZBounds planeBounds, GeoPoint[] notablePoints, Membership[] bounds) {
            if (planeBounds != null && !planeBounds.overlaps(this.bounds)) {
                return false;
            }
            return this.child1.intersects(p, planeBounds, notablePoints, bounds) || this.child2.intersects(p, planeBounds, notablePoints, bounds);
        }

        @Override
        public boolean intersects(GeoShape geoShape) {
            return this.child1.intersects(geoShape) || this.child2.intersects(geoShape);
        }

        @Override
        public void getBounds(Bounds bounds) {
            if (bounds instanceof XYZBounds) {
                this.bounds.addBounds((XYZBounds)bounds);
            } else {
                this.child1.getBounds(bounds);
                this.child2.getBounds(bounds);
            }
        }

        public String toString() {
            return "PathNode (" + String.valueOf(this.child1) + ") (" + String.valueOf(this.child2) + ")";
        }
    }

    private static interface PathComponent {
        public boolean isWithin(Vector var1);

        public boolean isWithin(double var1, double var3, double var5);

        public boolean isWithinSection(Vector var1);

        public boolean isWithinSection(double var1, double var3, double var5);

        public double getStartingDistance(DistanceStyle var1);

        public double fullPathDistance(DistanceStyle var1);

        public double distance(DistanceStyle var1, double var2, double var4, double var6);

        public DistancePair nearestDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double pathDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double pathDeltaDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double nearestPathDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double pathCenterDistance(DistanceStyle var1, double var2, double var4, double var6);

        public double outsideDistance(DistanceStyle var1, double var2, double var4, double var6);

        public boolean intersects(Plane var1, XYZBounds var2, GeoPoint[] var3, Membership[] var4);

        public boolean intersects(GeoShape var1);

        public void getBounds(Bounds var1);
    }

    private static class DistancePair {
        public final double pathCenterDistance;
        public final double distanceAlongPath;

        public DistancePair(double pathCenterDistance, double distanceAlongPath) {
            this.pathCenterDistance = pathCenterDistance;
            this.distanceAlongPath = distanceAlongPath;
        }

        public String toString() {
            return "DistancePair: pathCenterDistance=" + this.pathCenterDistance + ",distanceAlongPath=" + this.distanceAlongPath;
        }
    }
}

