/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene50.compressing;

import java.io.IOException;
import org.apache.lucene.backward_codecs.lucene50.compressing.FieldsIndex;
import org.apache.lucene.backward_codecs.packed.LegacyPackedInts;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.packed.PackedInts;

final class LegacyFieldsIndexReader
extends FieldsIndex {
    final int maxDoc;
    final int[] docBases;
    final long[] startPointers;
    final int[] avgChunkDocs;
    final long[] avgChunkSizes;
    final PackedInts.Reader[] docBasesDeltas;
    final PackedInts.Reader[] startPointersDeltas;

    LegacyFieldsIndexReader(IndexInput fieldsIndexIn, SegmentInfo si) throws IOException {
        int numChunks;
        this.maxDoc = si.maxDoc();
        int[] docBases = new int[16];
        long[] startPointers = new long[16];
        int[] avgChunkDocs = new int[16];
        long[] avgChunkSizes = new long[16];
        Object[] docBasesDeltas = new PackedInts.Reader[16];
        Object[] startPointersDeltas = new PackedInts.Reader[16];
        int packedIntsVersion = fieldsIndexIn.readVInt();
        int blockCount = 0;
        while ((numChunks = fieldsIndexIn.readVInt()) != 0) {
            if (blockCount == docBases.length) {
                int newSize = ArrayUtil.oversize((int)(blockCount + 1), (int)8);
                docBases = ArrayUtil.growExact((int[])docBases, (int)newSize);
                startPointers = ArrayUtil.growExact((long[])startPointers, (int)newSize);
                avgChunkDocs = ArrayUtil.growExact((int[])avgChunkDocs, (int)newSize);
                avgChunkSizes = ArrayUtil.growExact((long[])avgChunkSizes, (int)newSize);
                docBasesDeltas = (PackedInts.Reader[])ArrayUtil.growExact((Object[])docBasesDeltas, (int)newSize);
                startPointersDeltas = (PackedInts.Reader[])ArrayUtil.growExact((Object[])startPointersDeltas, (int)newSize);
            }
            docBases[blockCount] = fieldsIndexIn.readVInt();
            avgChunkDocs[blockCount] = fieldsIndexIn.readVInt();
            int bitsPerDocBase = fieldsIndexIn.readVInt();
            if (bitsPerDocBase > 32) {
                throw new CorruptIndexException("Corrupted bitsPerDocBase: " + bitsPerDocBase, (DataInput)fieldsIndexIn);
            }
            docBasesDeltas[blockCount] = LegacyPackedInts.getReaderNoHeader((DataInput)fieldsIndexIn, PackedInts.Format.PACKED, packedIntsVersion, numChunks, bitsPerDocBase);
            startPointers[blockCount] = fieldsIndexIn.readVLong();
            avgChunkSizes[blockCount] = fieldsIndexIn.readVLong();
            int bitsPerStartPointer = fieldsIndexIn.readVInt();
            if (bitsPerStartPointer > 64) {
                throw new CorruptIndexException("Corrupted bitsPerStartPointer: " + bitsPerStartPointer, (DataInput)fieldsIndexIn);
            }
            startPointersDeltas[blockCount] = LegacyPackedInts.getReaderNoHeader((DataInput)fieldsIndexIn, PackedInts.Format.PACKED, packedIntsVersion, numChunks, bitsPerStartPointer);
            ++blockCount;
        }
        this.docBases = ArrayUtil.copyOfSubArray((int[])docBases, (int)0, (int)blockCount);
        this.startPointers = ArrayUtil.copyOfSubArray((long[])startPointers, (int)0, (int)blockCount);
        this.avgChunkDocs = ArrayUtil.copyOfSubArray((int[])avgChunkDocs, (int)0, (int)blockCount);
        this.avgChunkSizes = ArrayUtil.copyOfSubArray((long[])avgChunkSizes, (int)0, (int)blockCount);
        this.docBasesDeltas = (PackedInts.Reader[])ArrayUtil.copyOfSubArray((Object[])docBasesDeltas, (int)0, (int)blockCount);
        this.startPointersDeltas = (PackedInts.Reader[])ArrayUtil.copyOfSubArray((Object[])startPointersDeltas, (int)0, (int)blockCount);
    }

    private int block(int docID) {
        int lo = 0;
        int hi = this.docBases.length - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValue = this.docBases[mid];
            if (midValue == docID) {
                return mid;
            }
            if (midValue < docID) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return hi;
    }

    private int relativeDocBase(int block, int relativeChunk) {
        int expected = this.avgChunkDocs[block] * relativeChunk;
        long delta = BitUtil.zigZagDecode((long)this.docBasesDeltas[block].get(relativeChunk));
        return expected + (int)delta;
    }

    private long relativeStartPointer(int block, int relativeChunk) {
        long expected = this.avgChunkSizes[block] * (long)relativeChunk;
        long delta = BitUtil.zigZagDecode((long)this.startPointersDeltas[block].get(relativeChunk));
        return expected + delta;
    }

    private int relativeChunk(int block, int relativeDoc) {
        int lo = 0;
        int hi = this.docBasesDeltas[block].size() - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midValue = this.relativeDocBase(block, mid);
            if (midValue == relativeDoc) {
                return mid;
            }
            if (midValue < relativeDoc) {
                lo = mid + 1;
                continue;
            }
            hi = mid - 1;
        }
        return hi;
    }

    @Override
    long getStartPointer(int docID) {
        if (docID < 0 || docID >= this.maxDoc) {
            throw new IllegalArgumentException("docID out of range [0-" + this.maxDoc + "]: " + docID);
        }
        int block = this.block(docID);
        int relativeChunk = this.relativeChunk(block, docID - this.docBases[block]);
        return this.startPointers[block] + this.relativeStartPointer(block, relativeChunk);
    }

    @Override
    public LegacyFieldsIndexReader clone() {
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(blocks=" + this.docBases.length + ")";
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    void checkIntegrity() throws IOException {
    }
}

