/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.attrs;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.carrot2.attrs.Attr;
import org.carrot2.attrs.Constraint;

public class AttrEnum<T extends Enum<T>>
extends Attr<T> {
    private Class<T> clazz;

    AttrEnum(Class<T> clazz, T value, List<? extends Constraint<? super T>> constraint, String label) {
        super(value, label, constraint);
        if (!clazz.isEnum()) {
            throw new RuntimeException(String.format(Locale.ROOT, "Expected an enum class: %s", clazz.getSimpleName()));
        }
        this.clazz = clazz;
    }

    public Class<T> enumClass() {
        return this.clazz;
    }

    public static <T extends Enum<T>> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    public static class Builder<T extends Enum<T>>
    extends Attr.BuilderScaffold<T> {
        private Class<T> clazz;

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
            this.addConstraint(Constraint.named("value in " + EnumSet.allOf(clazz), v -> {}));
        }

        @Override
        public Builder<T> label(String label) {
            super.label(label);
            return this;
        }

        public AttrEnum<T> defaultValue(T defaultValue) {
            return new AttrEnum<T>(this.clazz, defaultValue, this.getConstraint(), this.label);
        }
    }
}

