/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.semver4j.Range;
import org.semver4j.RangesList;
import org.semver4j.internal.RangeProcessorPipeline;
import org.semver4j.internal.Tokenizers;
import org.semver4j.processor.AllVersionsProcessor;
import org.semver4j.processor.CaretProcessor;
import org.semver4j.processor.HyphenProcessor;
import org.semver4j.processor.IvyProcessor;
import org.semver4j.processor.Processor;
import org.semver4j.processor.TildeProcessor;
import org.semver4j.processor.XRangeProcessor;

@NullMarked
class RangesString {
    private static final Pattern splitterPattern = Pattern.compile("(\\s*)([<>]?=?)\\s*");
    private static final Pattern comparatorPattern = Pattern.compile(Tokenizers.COMPARATOR);
    private final RangeProcessorPipeline rangeProcessorPipeline;

    RangesString() {
        this(new AllVersionsProcessor(), new IvyProcessor(), new HyphenProcessor(), new CaretProcessor(), new TildeProcessor(), new XRangeProcessor());
    }

    RangesString(Processor start, Processor ... additional) {
        this.rangeProcessorPipeline = RangeProcessorPipeline.startWith(start);
        for (Processor p : additional) {
            this.rangeProcessorPipeline.addProcessor(p);
        }
    }

    RangesList get(String range, boolean includePrerelease) {
        String[] rangeSections;
        RangesList rangesList = new RangesList(includePrerelease);
        range = range.trim();
        for (String rangeSection : rangeSections = range.split("\\|\\|")) {
            rangeSection = RangesString.stripWhitespacesBetweenRangeOperator(rangeSection);
            rangeSection = this.applyProcessors(rangeSection, includePrerelease);
            List<Range> ranges = RangesString.addRanges(rangeSection);
            rangesList.add(ranges);
        }
        return rangesList;
    }

    private static String stripWhitespacesBetweenRangeOperator(String rangeSection) {
        Matcher matcher = splitterPattern.matcher(rangeSection);
        return matcher.replaceAll("$1$2").trim();
    }

    private String applyProcessors(String range, boolean includePrerelease) {
        return this.rangeProcessorPipeline.process(range, includePrerelease);
    }

    private static List<Range> addRanges(String range) {
        String[] parsedRanges;
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String parsedRange : parsedRanges = range.split("\\s+")) {
            Matcher matcher = comparatorPattern.matcher(parsedRange);
            if (!matcher.matches()) continue;
            String rangeOperator = matcher.group(1);
            String version = matcher.group(2);
            ranges.add(new Range(version, Range.RangeOperator.value(rangeOperator)));
        }
        return ranges;
    }
}

