/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.CodecReader;
import org.apache.lucene.index.FilterCodecReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SlowCodecReaderWrapper;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.misc.store.HardlinkCopyDirectoryWrapper;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.HashBasedRouter;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.BitsFilteredPostingsEnum;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.SolrIndexConfig;
import org.apache.solr.update.SolrIndexWriter;
import org.apache.solr.update.SplitIndexCommand;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrIndexSplitter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String INDEX_PREFIX = "index.";
    final SplitIndexCommand cmd;
    final SolrIndexSearcher searcher;
    final SchemaField field;
    final DocRouter.Range[] rangesArr;
    final HashBasedRouter hashRouter;
    final int numPieces;
    final String splitKey;
    SplitMethod splitMethod;
    final RTimerTree timings = new RTimerTree();

    public SolrIndexSplitter(SplitIndexCommand cmd) {
        this.cmd = cmd;
        this.searcher = cmd.getReq().getSearcher();
        HashBasedRouter hashBasedRouter = this.hashRouter = cmd.router instanceof HashBasedRouter ? (HashBasedRouter)cmd.router : null;
        if (cmd.ranges == null) {
            this.numPieces = cmd.paths != null ? cmd.paths.size() : cmd.cores.size();
            this.rangesArr = null;
        } else {
            this.numPieces = cmd.ranges.size();
            this.rangesArr = cmd.ranges.toArray(new DocRouter.Range[0]);
        }
        this.field = cmd.routeFieldName == null ? (this.searcher.getSchema().isUsableForChildDocs() ? this.searcher.getSchema().getField("_root_") : this.searcher.getSchema().getUniqueKeyField()) : this.searcher.getSchema().getField(cmd.routeFieldName);
        if (cmd.splitKey == null) {
            this.splitKey = null;
        } else {
            SolrIndexSplitter.checkRouterSupportsSplitKey(this.hashRouter, cmd.splitKey);
            this.splitKey = ((CompositeIdRouter)this.hashRouter).getRouteKeyNoSuffix(cmd.splitKey);
        }
        this.splitMethod = cmd.cores == null ? SplitMethod.REWRITE : cmd.splitMethod;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void split(NamedList<Object> results) throws IOException {
        block12: {
            RTimerTree t;
            SolrCore parentCore = this.searcher.getCore();
            Directory parentDirectory = this.searcher.getRawReader().directory();
            Lock parentDirectoryLock = null;
            UpdateLog ulog = parentCore.getUpdateHandler().getUpdateLog();
            if (ulog == null && this.splitMethod == SplitMethod.LINK) {
                log.warn("No updateLog in parent core, switching to use potentially slower 'splitMethod=rewrite'");
                this.splitMethod = SplitMethod.REWRITE;
            }
            if (this.splitMethod == SplitMethod.LINK) {
                RTimerTree t2 = this.timings.sub("closeParentIW");
                try {
                    ulog.bufferUpdates();
                    parentCore.getSolrCoreState().closeIndexWriter(parentCore, false);
                    parentDirectoryLock = parentDirectory.obtainLock("write.lock");
                    log.info("Splitting in 'link' mode: closed parent IndexWriter...");
                    t2.stop();
                }
                catch (Exception e) {
                    if (parentDirectoryLock != null) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{parentDirectoryLock});
                    }
                    try {
                        parentCore.getSolrCoreState().openIndexWriter(parentCore);
                        ulog.applyBufferedUpdates();
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error closing current IndexWriter, aborting 'link' split...", (Throwable)e);
                    }
                    catch (Exception e1) {
                        log.error("Error reopening IndexWriter after failed close", (Throwable)e1);
                        log.error("Original error closing IndexWriter:", (Throwable)e);
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reopening IndexWriter after failed close", (Throwable)e1);
                    }
                }
            }
            boolean success = false;
            try {
                t = this.timings.sub("doSplit");
                this.doSplit();
                t.stop();
                success = true;
                if (this.splitMethod != SplitMethod.LINK) break block12;
            }
            catch (Exception e) {
                try {
                    results.add("failed", (Object)e.toString());
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.splitMethod != SplitMethod.LINK) throw throwable;
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{parentDirectoryLock});
                    RTimerTree t3 = this.timings.sub("reopenParentIW");
                    parentCore.getSolrCoreState().openIndexWriter(parentCore);
                    t3.stop();
                    t3 = this.timings.sub("parentApplyBufferedUpdates");
                    ulog.applyBufferedUpdates();
                    t3.stop();
                    if (!log.isInfoEnabled()) throw throwable;
                    log.info("Splitting in 'link' mode {}: re-opened parent IndexWriter.", (Object)(success ? "finished" : "FAILED"));
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{parentDirectoryLock});
            t = this.timings.sub("reopenParentIW");
            parentCore.getSolrCoreState().openIndexWriter(parentCore);
            t.stop();
            t = this.timings.sub("parentApplyBufferedUpdates");
            ulog.applyBufferedUpdates();
            t.stop();
            if (log.isInfoEnabled()) {
                log.info("Splitting in 'link' mode {}: re-opened parent IndexWriter.", (Object)(success ? "finished" : "FAILED"));
            }
        }
        results.add("timing", this.timings.asNamedList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doSplit() throws IOException {
        String hardLinkPath;
        int partitionNumber;
        RTimerTree t;
        List leaves = this.searcher.getRawReader().leaves();
        Directory parentDirectory = this.searcher.getRawReader().directory();
        ArrayList<FixedBitSet[]> segmentDocSets = new ArrayList<FixedBitSet[]>(leaves.size());
        SolrIndexConfig parentConfig = this.searcher.getCore().getSolrConfig().indexConfig;
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).format(new Date());
        if (log.isInfoEnabled()) {
            log.info("SolrIndexSplitter: partitions={} segments={}", (Object)this.numPieces, (Object)leaves.size());
        }
        AtomicInteger currentPartition = new AtomicInteger();
        if (this.splitMethod != SplitMethod.LINK) {
            t = this.timings.sub("findDocSetsPerLeaf");
            for (LeafReaderContext readerContext : leaves) {
                assert (readerContext.ordInParent == segmentDocSets.size());
                FixedBitSet[] docSets = SolrIndexSplitter.split(readerContext, this.numPieces, this.field, this.rangesArr, this.splitKey, this.hashRouter, currentPartition, false);
                segmentDocSets.add(docSets);
            }
            t.stop();
        }
        ConcurrentHashMap<IndexReader.CacheKey, FixedBitSet[]> docsToDeleteCache = new ConcurrentHashMap<IndexReader.CacheKey, FixedBitSet[]>();
        for (int partitionNumber2 = 0; partitionNumber2 < this.numPieces; ++partitionNumber2) {
            Object path;
            IndexWriter iw;
            SolrCore subCore;
            String partitionName = "SolrIndexSplitter:partition=" + partitionNumber2 + ",partitionCount=" + this.numPieces + (String)(this.cmd.ranges != null ? ",range=" + String.valueOf(this.cmd.ranges.get(partitionNumber2)) : "");
            log.info(partitionName);
            boolean success = false;
            RefCounted<IndexWriter> iwRef = null;
            if (this.cmd.cores != null && this.splitMethod != SplitMethod.LINK) {
                subCore = this.cmd.cores.get(partitionNumber2);
                iwRef = subCore.getUpdateHandler().getSolrCoreState().getIndexWriter(subCore);
                iw = iwRef.get();
            } else if (this.splitMethod == SplitMethod.LINK) {
                subCore = this.cmd.cores.get(partitionNumber2);
                path = subCore.getDataDir() + INDEX_PREFIX + timestamp;
                t = this.timings.sub("hardLinkCopy");
                t.resume();
                Directory splitDir = subCore.getDirectoryFactory().get((String)path, DirectoryFactory.DirContext.DEFAULT, subCore.getSolrConfig().indexConfig.lockType);
                HardlinkCopyDirectoryWrapper hardLinkedDir = new HardlinkCopyDirectoryWrapper(splitDir);
                boolean copiedOk = false;
                try {
                    for (String file : parentDirectory.listAll()) {
                        if (file.equals("write.lock")) continue;
                        hardLinkedDir.copyFrom(parentDirectory, file, file, IOContext.DEFAULT);
                    }
                    copiedOk = true;
                }
                finally {
                    if (!copiedOk) {
                        subCore.getDirectoryFactory().doneWithDirectory(splitDir);
                        subCore.getDirectoryFactory().remove(splitDir);
                    }
                }
                t.pause();
                IndexWriterConfig iwConfig = parentConfig.toIndexWriterConfig(subCore);
                iwConfig.setMergePolicy(NoMergePolicy.INSTANCE);
                t = this.timings.sub("createSubIW");
                t.resume();
                iw = new SolrIndexWriter(partitionName, splitDir, iwConfig);
                t.pause();
            } else {
                SolrCore core = this.searcher.getCore();
                path = this.cmd.paths.get(partitionNumber2);
                t = this.timings.sub("createSubIW");
                t.resume();
                iw = SolrIndexWriter.create(core, partitionName, (String)path, core.getDirectoryFactory(), true, core.getLatestSchema(), core.getSolrConfig().indexConfig, core.getDeletionPolicy(), core.getCodec());
                t.pause();
            }
            try {
                if (this.splitMethod == SplitMethod.LINK) {
                    t = this.timings.sub("deleteDocuments");
                    t.resume();
                    iw.deleteDocuments(new Query[]{new SplittingQuery(partitionNumber2, this.field, this.rangesArr, this.hashRouter, this.splitKey, docsToDeleteCache, currentPartition)});
                    t.pause();
                } else {
                    t = this.timings.sub("addIndexes");
                    t.resume();
                    for (int segmentNumber = 0; segmentNumber < leaves.size(); ++segmentNumber) {
                        if (log.isInfoEnabled()) {
                            log.info("SolrIndexSplitter: partition # {} partitionCount={} {} segment #={} segmentCount={}", new Object[]{partitionNumber2, this.numPieces, this.cmd.ranges != null ? " range=" + String.valueOf(this.cmd.ranges.get(partitionNumber2)) : "", segmentNumber, leaves.size()});
                        }
                        CodecReader subReader = SlowCodecReaderWrapper.wrap((LeafReader)((LeafReaderContext)leaves.get(segmentNumber)).reader());
                        iw.addIndexes(new CodecReader[]{new LiveDocsReader(subReader, ((FixedBitSet[])segmentDocSets.get(segmentNumber))[partitionNumber2])});
                    }
                    t.pause();
                }
                SolrIndexWriter.setCommitData(iw, -1L, this.cmd.commitData);
                t = this.timings.sub("subIWCommit");
                t.resume();
                iw.commit();
                t.pause();
                success = true;
                if (iwRef != null) {
                    iwRef.decref();
                    continue;
                }
                t = this.timings.sub("subIWClose");
            }
            catch (Throwable throwable) {
                if (iwRef != null) {
                    iwRef.decref();
                    throw throwable;
                }
                if (success) {
                    t = this.timings.sub("subIWClose");
                    t.resume();
                    iw.close();
                    t.pause();
                } else {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{iw});
                }
                if (this.splitMethod != SplitMethod.LINK) throw throwable;
                SolrCore subCore2 = this.cmd.cores.get(partitionNumber2);
                subCore2.getDirectoryFactory().release(iw.getDirectory());
                throw throwable;
            }
            t.resume();
            iw.close();
            t.pause();
            if (this.splitMethod != SplitMethod.LINK) continue;
            SolrCore subCore3 = this.cmd.cores.get(partitionNumber2);
            subCore3.getDirectoryFactory().release(iw.getDirectory());
        }
        if (this.splitMethod != SplitMethod.LINK) return;
        if (this.cmd.cores == null) return;
        boolean switchOk = true;
        t = this.timings.sub("switchSubIndexes");
        for (partitionNumber = 0; partitionNumber < this.numPieces; ++partitionNumber) {
            SolrCore subCore = this.cmd.cores.get(partitionNumber);
            String indexDirPath = subCore.getIndexDir();
            log.debug("Switching directories");
            hardLinkPath = subCore.getDataDir() + INDEX_PREFIX + timestamp;
            subCore.modifyIndexProps(INDEX_PREFIX + timestamp);
            try {
                subCore.getUpdateHandler().newIndexWriter(false);
                this.openNewSearcher(subCore);
                continue;
            }
            catch (Exception e) {
                log.error("Failed to switch sub-core {} to {}, split will fail", new Object[]{indexDirPath, hardLinkPath, e});
                switchOk = false;
                break;
            }
        }
        t.stop();
        if (!switchOk) {
            t = this.timings.sub("rollbackSubIndexes");
            partitionNumber = 0;
            while (true) {
                Directory dir;
                SolrCore subCore;
                block43: {
                    if (partitionNumber >= this.numPieces) {
                        t.stop();
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "There were errors during index split");
                    }
                    subCore = this.cmd.cores.get(partitionNumber);
                    dir = null;
                    try {
                        dir = subCore.getDirectoryFactory().get(subCore.getDataDir(), DirectoryFactory.DirContext.META_DATA, subCore.getSolrConfig().indexConfig.lockType);
                        dir.deleteFile("index.properties");
                        if (dir == null) break block43;
                    }
                    catch (Throwable throwable) {
                        if (dir == null) throw throwable;
                        subCore.getDirectoryFactory().release(dir);
                        throw throwable;
                    }
                    subCore.getDirectoryFactory().release(dir);
                }
                hardLinkPath = subCore.getDataDir() + INDEX_PREFIX + timestamp;
                try {
                    dir = subCore.getDirectoryFactory().get(hardLinkPath, DirectoryFactory.DirContext.DEFAULT, subCore.getSolrConfig().indexConfig.lockType);
                    subCore.getDirectoryFactory().doneWithDirectory(dir);
                    subCore.getDirectoryFactory().remove(dir);
                }
                finally {
                    if (dir != null) {
                        subCore.getDirectoryFactory().release(dir);
                    }
                }
                subCore.getUpdateHandler().newIndexWriter(false);
                try {
                    this.openNewSearcher(subCore);
                }
                catch (Exception e) {
                    log.warn("Error rolling back failed split of {}", (Object)hardLinkPath, (Object)e);
                }
                ++partitionNumber;
            }
        }
        t = this.timings.sub("cleanSubIndex");
        partitionNumber = 0;
        while (true) {
            block45: {
                if (partitionNumber >= this.numPieces) {
                    t.stop();
                    return;
                }
                SolrCore subCore = this.cmd.cores.get(partitionNumber);
                String oldIndexPath = subCore.getDataDir() + "index";
                Directory indexDir = null;
                try {
                    indexDir = subCore.getDirectoryFactory().get(oldIndexPath, DirectoryFactory.DirContext.DEFAULT, subCore.getSolrConfig().indexConfig.lockType);
                    subCore.getDirectoryFactory().doneWithDirectory(indexDir);
                    subCore.getDirectoryFactory().remove(indexDir);
                    if (indexDir == null) break block45;
                }
                catch (Throwable throwable) {
                    if (indexDir == null) throw throwable;
                    subCore.getDirectoryFactory().release(indexDir);
                    throw throwable;
                }
                subCore.getDirectoryFactory().release(indexDir);
            }
            ++partitionNumber;
        }
    }

    private void openNewSearcher(SolrCore core) throws Exception {
        Future[] waitSearcher = (Future[])Array.newInstance(Future.class, 1);
        core.getSearcher(true, false, waitSearcher, true);
        if (waitSearcher[0] != null) {
            waitSearcher[0].get();
        }
    }

    static FixedBitSet[] split(LeafReaderContext readerContext, int numPieces, SchemaField field, DocRouter.Range[] rangesArr, String splitKey, HashBasedRouter hashRouter, AtomicInteger currentPartition, boolean delete) throws IOException {
        Terms terms;
        TermsEnum termsEnum;
        SolrIndexSplitter.checkRouterSupportsSplitKey(hashRouter, splitKey);
        LeafReader reader = readerContext.reader();
        FixedBitSet[] docSets = new FixedBitSet[numPieces];
        for (int i = 0; i < docSets.length; ++i) {
            docSets[i] = new FixedBitSet(reader.maxDoc());
            if (!delete) continue;
            docSets[i].set(0, reader.maxDoc());
        }
        Bits liveDocs = reader.getLiveDocs();
        if (liveDocs != null && delete) {
            FixedBitSet liveDocsSet = FixedBitSet.copyOf((Bits)liveDocs);
            for (FixedBitSet set : docSets) {
                set.and(liveDocsSet);
            }
        }
        TermsEnum termsEnum2 = termsEnum = (terms = reader.terms(field.getName())) == null ? null : terms.iterator();
        if (termsEnum == null) {
            return docSets;
        }
        BytesRef term = null;
        PostingsEnum postingsEnum = null;
        int[] docsMatchingRanges = null;
        if (rangesArr != null) {
            docsMatchingRanges = new int[rangesArr.length + 1];
        }
        CharsRefBuilder idRef = new CharsRefBuilder();
        while ((term = termsEnum.next()) != null) {
            int doc;
            String part1;
            field.getType().indexedToReadable(term, idRef);
            String idString = idRef.toString();
            if (splitKey != null && ((part1 = ((CompositeIdRouter)hashRouter).getRouteKeyNoSuffix(idString)) == null || !splitKey.equals(part1))) continue;
            int hash = 0;
            if (hashRouter != null && rangesArr != null) {
                hash = hashRouter.sliceHash(idString, null, null, null);
            }
            postingsEnum = termsEnum.postings(postingsEnum, 0);
            postingsEnum = BitsFilteredPostingsEnum.wrap(postingsEnum, liveDocs);
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                if (rangesArr == null) {
                    if (delete) {
                        docSets[currentPartition.get()].clear(doc);
                    } else {
                        docSets[currentPartition.get()].set(doc);
                    }
                    currentPartition.set((currentPartition.get() + 1) % numPieces);
                    continue;
                }
                int matchingRangesCount = 0;
                for (int i = 0; i < rangesArr.length; ++i) {
                    if (!rangesArr[i].includes(hash)) continue;
                    if (delete) {
                        docSets[i].clear(doc);
                    } else {
                        docSets[i].set(doc);
                    }
                    ++matchingRangesCount;
                }
                int n = matchingRangesCount;
                docsMatchingRanges[n] = docsMatchingRanges[n] + 1;
            }
        }
        if (docsMatchingRanges != null) {
            block9: for (int ii = 0; ii < docsMatchingRanges.length; ++ii) {
                if (0 == docsMatchingRanges[ii]) continue;
                switch (ii) {
                    case 0: {
                        log.error("Splitting {}: {} documents belong to no shards and will be dropped", (Object)reader, (Object)docsMatchingRanges[ii]);
                        continue block9;
                    }
                    case 1: {
                        log.info("Splitting {}: {} documents will move into a sub-shard", (Object)reader, (Object)docsMatchingRanges[ii]);
                        continue block9;
                    }
                    default: {
                        log.error("Splitting {}: {} documents will be moved to multiple ({}) sub-shards", new Object[]{reader, docsMatchingRanges[ii], ii});
                    }
                }
            }
        }
        return docSets;
    }

    private static void checkRouterSupportsSplitKey(HashBasedRouter hashRouter, String splitKey) {
        if (splitKey != null && !(hashRouter instanceof CompositeIdRouter)) {
            throw new IllegalStateException("splitKey isn't supported for router " + String.valueOf(hashRouter.getClass()));
        }
    }

    static class LiveDocsReader
    extends FilterCodecReader {
        final FixedBitSet liveDocs;
        final int numDocs;

        public LiveDocsReader(CodecReader in, FixedBitSet liveDocs) {
            super(in);
            this.liveDocs = liveDocs;
            this.numDocs = liveDocs.cardinality();
        }

        public int numDocs() {
            return this.numDocs;
        }

        public Bits getLiveDocs() {
            return this.liveDocs;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }

    private class SplittingQuery
    extends Query {
        private final int partition;
        private final SchemaField field;
        private final DocRouter.Range[] rangesArr;
        private final HashBasedRouter hashRouter;
        private final String splitKey;
        private final Map<IndexReader.CacheKey, FixedBitSet[]> docsToDelete;
        private final AtomicInteger currentPartition;

        SplittingQuery(int partition, SchemaField field, DocRouter.Range[] rangesArr, HashBasedRouter hashRouter, String splitKey, Map<IndexReader.CacheKey, FixedBitSet[]> docsToDelete, AtomicInteger currentPartition) {
            this.partition = partition;
            this.field = field;
            this.rangesArr = rangesArr;
            this.hashRouter = hashRouter;
            this.splitKey = splitKey;
            this.docsToDelete = docsToDelete;
            this.currentPartition = currentPartition;
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    Bits liveDocs;
                    RTimerTree t = SolrIndexSplitter.this.timings.sub("findDocsToDelete");
                    t.resume();
                    FixedBitSet set = SplittingQuery.this.findDocsToDelete(context);
                    t.pause();
                    if (log.isInfoEnabled()) {
                        log.info("### partition={}, leaf={}, maxDoc={}, numDels={}, setLen={}, setCard={}", new Object[]{SplittingQuery.this.partition, context, context.reader().maxDoc(), context.reader().numDeletedDocs(), set.length(), set.cardinality()});
                    }
                    if ((liveDocs = context.reader().getLiveDocs()) != null) {
                        FixedBitSet dels = FixedBitSet.copyOf((Bits)liveDocs);
                        dels.flip(0, dels.length());
                        dels.and(set);
                        if (dels.cardinality() > 0) {
                            log.error("### INVALID DELS {}", (Object)dels.cardinality());
                        }
                    }
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, (DocIdSetIterator)new BitSetIterator((BitSet)set, (long)set.length()));
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return false;
                }

                public String toString() {
                    return "weight(shardSplittingQuery,part" + SplittingQuery.this.partition + ")";
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private FixedBitSet findDocsToDelete(LeafReaderContext readerContext) throws IOException {
            FixedBitSet[] perPartition = this.docsToDelete.get(readerContext.reader().getCoreCacheHelper().getKey());
            if (perPartition != null) {
                return perPartition[this.partition];
            }
            Map<IndexReader.CacheKey, FixedBitSet[]> map = this.docsToDelete;
            synchronized (map) {
                perPartition = this.docsToDelete.get(readerContext.reader().getCoreCacheHelper().getKey());
                if (perPartition != null) {
                    return perPartition[this.partition];
                }
                perPartition = SolrIndexSplitter.split(readerContext, SolrIndexSplitter.this.numPieces, this.field, this.rangesArr, this.splitKey, this.hashRouter, this.currentPartition, true);
                this.docsToDelete.put(readerContext.reader().getCoreCacheHelper().getKey(), perPartition);
                return perPartition[this.partition];
            }
        }

        public String toString(String field) {
            return "shardSplittingQuery";
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SplittingQuery)) {
                return false;
            }
            SplittingQuery q = (SplittingQuery)((Object)obj);
            return this.partition == q.partition;
        }

        public int hashCode() {
            return this.partition;
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }
    }

    public static enum SplitMethod {
        REWRITE,
        LINK;


        public static SplitMethod get(String p) {
            if (p != null) {
                try {
                    return SplitMethod.valueOf(p.toUpperCase(Locale.ROOT));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

