/**
 * This file was automatically generated by scripts/zap-update-types.ts. Do NOT edit manually.
 *
 * ZCL data type definitions.
 */
/**
 * @type enum8
 */
export declare enum ZclType {
    Nodata = 0,
    Data8 = 8,
    Data16 = 9,
    Data24 = 10,
    Data32 = 11,
    Data40 = 12,
    Data48 = 13,
    Data56 = 14,
    Data64 = 15,
    Bool = 16,
    Map8 = 24,
    Map16 = 25,
    Map24 = 26,
    Map32 = 27,
    Map40 = 28,
    Map48 = 29,
    Map56 = 30,
    Map64 = 31,
    Uint8 = 32,
    Uint16 = 33,
    Uint24 = 34,
    Uint32 = 35,
    Uint40 = 36,
    Uint48 = 37,
    Uint56 = 38,
    Uint64 = 39,
    Int8 = 40,
    Int16 = 41,
    Int24 = 42,
    Int32 = 43,
    Int40 = 44,
    Int48 = 45,
    Int56 = 46,
    Int64 = 47,
    Enum8 = 48,
    Enum16 = 49,
    Semi = 56,
    Single = 57,
    Double = 58,
    Octstr = 65,
    String = 66,
    Octstr16 = 67,
    String16 = 68,
    Array = 72,
    Struct = 76,
    Set = 80,
    Bag = 81,
    ToD = 224,
    Date = 225,
    Utc = 226,
    ClusterId = 232,
    AttribId = 233,
    BacOid = 234,
    Eui64 = 240,
    Key128 = 241,
    Unk = 255
}
/**
 * @type enum8
 */
export declare enum AttributeReportingStatus {
    Pending = 0,
    Complete = 1
}
/**
 * @type enum8
 */
export declare enum ZclStatus {
    Success = 0,
    Failure = 1,
    NotAuthorized = 126,
    MalformedCommand = 128,
    UnsupClusterCommand = 129,
    UnsupGeneralCommand = 130,
    UnsupManufClusterCommand = 131,
    UnsupManufGeneralCommand = 132,
    InvalidField = 133,
    UnsupportedAttribute = 134,
    InvalidValue = 135,
    ReadOnly = 136,
    InsufficientSpace = 137,
    DuplicateExists = 138,
    NotFound = 139,
    UnreportableAttribute = 140,
    InvalidDataType = 141,
    InvalidSelector = 142,
    WriteOnly = 143,
    InconsistentStartupState = 144,
    DefinedOutOfBand = 145,
    Inconsistent = 146,
    ActionDenied = 147,
    Timeout = 148,
    Abort = 149,
    InvalidImage = 150,
    WaitForData = 151,
    NoImageAvailable = 152,
    RequireMoreImage = 153,
    NotificationPending = 154,
    HardwareFailure = 192,
    SoftwareFailure = 193,
    CalibrationError = 194,
    UnsupportedCluster = 195,
    LimitReached = 196
}
/**
 * @type enum8
 */
export declare enum ProfileIntervalPeriod {
    Daily = 0,
    Six0minutes = 1,
    Three0minutes = 2,
    One5minutes = 3,
    One0minutes = 4,
    Sevendot5minutes = 5,
    Fiveminutes = 6,
    Twodot5minutes = 7
}
/**
 * @type enum16
 */
export declare enum IasZoneType {
    StandardCie = 0,
    MotionSensor = 13,
    ContactSwitch = 21,
    DoorOrWindowHandle = 22,
    FireSensor = 40,
    WaterSensor = 42,
    CarbonMonoxideSensor = 43,
    PersonalEmergencyDevice = 44,
    VibrationOrMovementSensor = 45,
    RemoteControl = 271,
    KeyFob = 277,
    Keypad = 541,
    StandardWarningDevice = 549,
    GlassBreakSensor = 550,
    SecurityRepeater = 553,
    Invalid = 65535
}
/**
 * @type map16
 */
export declare enum IasZoneStatusMask {
    Alarm1 = 1,
    Alarm2 = 2,
    Tamper = 4,
    BatteryLow = 8,
    SupervisionNotify = 16,
    RestoreNotify = 32,
    Trouble = 64,
    AcmainsFault = 128,
    Test = 256,
    BatteryDefect = 512
}
export declare enum IasZoneStatusShiftRight {
    Alarm1 = 0,
    Alarm2 = 1,
    Tamper = 2,
    BatteryLow = 3,
    SupervisionNotify = 4,
    RestoreNotify = 5,
    Trouble = 6,
    AcmainsFault = 7,
    Test = 8,
    BatteryDefect = 9
}
/**
 * @type unk
 */
export interface AnyType {
    type: number;
    value: unknown;
}
export interface ReadAttributeResponseRecord {
    attributeIdentifier: number;
    status: number;
    atttribute?: AnyType;
}
export interface WriteAttributeRecord {
    attributeIdentifier: number;
    attribute: AnyType;
}
export interface WriteAttributeResponseRecord {
    status: number;
    attributeIdentifier?: number;
}
/**
 * @type enum8
 */
export declare enum ReportingRole {
    Generator = 0,
    Recipient = 1
}
export interface ConfigureReportingRecord {
    direction: number;
    attributeIdentifier: number;
    attributeType?: number;
    minimumReportingInterval?: number;
    maximumReportingInterval?: number;
    reportableChange?: unknown;
    timeout?: number;
}
export interface ConfigureReportingResponseRecord {
    status: number;
    direction?: number;
    attributeIdentifier?: number;
}
export interface ReadReportingConfigurationRecord {
    direction: number;
    attributeIdentifier: number;
}
export interface ReadReportingConfigurationResponseRecord {
    direction: number;
    attributeIdentifier: number;
    attributeType?: number;
    minimumReportingInterval?: number;
    maximumReportingInterval?: number;
    reportableChange?: unknown;
    timeout?: number;
}
export interface AttributeReportRecord {
    attributeIdentifier: number;
    attribute: AnyType;
}
export interface DiscoverAtttributesResponseRecord {
    attributeIdentifier: number;
    attributeType: number;
}
export interface ReadStructuredRecord {
    attributeIdentifier: number;
    index: number;
}
export interface WriteStructuredRecord {
    attributeIdentifier: number;
    selector: number;
    attribute: AnyType;
}
export interface WriteStructuredResponseRecord {
    status: number;
    attributeIdentifier?: number;
    selector?: number;
}
export interface DiscoverAtttributesExtendedResponseRecord {
    attributeIdentifier: number;
    accessControl: number;
}
/**
 * @cluster Basic
 * @type enum8
 */
export declare enum PowerSource {
    Unknown = 0,
    SinglePhaseMains = 1,
    ThreePhaseMains = 2,
    Battery = 3,
    Dcsource = 4,
    EmergencyMainsConstantlyPowered = 5,
    EmergencyMainsAndTransferSwitch = 6,
    UnknownWithBatteryBackup = 128,
    SinglePhaseMainsWithBatteryBackup = 129,
    ThreePhaseMainsWithBatteryBackup = 130,
    BatteryWithBatteryBackup = 131,
    DcsourceWithBatteryBackup = 132,
    EmergencyMainsConstantlyPoweredWithBatteryBackup = 133,
    EmergencyMainsAndTransferSwitchWithBatteryBackup = 134
}
/**
 * @cluster Basic
 * @type enum8
 */
export declare enum GenericDeviceClass {
    Lighting = 0
}
/**
 * @cluster Basic
 * @type enum8
 */
export declare enum GenericDeviceType {
    Incandescent = 0,
    SpotlightHalogen = 1,
    HalogenBulb = 2,
    Cfl = 3,
    LinearFluorescent = 4,
    Ledbulb = 5,
    SpotlightLed = 6,
    Ledstrip = 7,
    Ledtube = 8,
    GenericIndoorLuminaireOrLightFixture = 9,
    GenericOutdoorLuminaireOrLightFixture = 10,
    PendantLuminaireOrLightFixture = 11,
    FloorStandingLuminaireOrLightFixture = 12,
    GenericController = 224,
    WallSwitch = 225,
    PortableRemoteController = 226,
    MotionSensorOrLightSensor = 227,
    GenericActuator = 240,
    WallSocket = 241,
    GatewayOrBridge = 242,
    PlugInUnit = 243,
    RetrofitActuator = 244,
    Unspecified = 255
}
/**
 * @cluster Basic
 * @type enum8
 */
export declare enum PhysicalEnvironment {
    UnspecifiedEnvironment = 0,
    Deprecated = 1,
    Bar = 2,
    Courtyard = 3,
    Bathroom = 4,
    Bedroom = 5,
    BilliardRoom = 6,
    UtilityRoom = 7,
    Cellar = 8,
    StorageCloset = 9,
    Theater = 10,
    Office = 11,
    Deck = 12,
    Den = 13,
    DiningRoom = 14,
    ElectricalRoom = 15,
    Elevator = 16,
    Entry = 17,
    FamilyRoom = 18,
    MainFloor = 19,
    Upstairs = 20,
    Downstairs = 21,
    BasementLowerLevel = 22,
    Gallery = 23,
    GameRoom = 24,
    Garage = 25,
    Gym = 26,
    Hallway = 27,
    House = 28,
    Kitchen = 29,
    LaundryRoom = 30,
    Library = 31,
    MasterBedroom = 32,
    MudRoom = 33,
    Nursery = 34,
    Pantry = 35,
    Office2 = 36,
    Outside = 37,
    Pool = 38,
    Porch = 39,
    SewingRoom = 40,
    SittingRoom = 41,
    Stairway = 42,
    Yard = 43,
    Attic = 44,
    HotTub = 45,
    LivingRoom = 46,
    Sauna = 47,
    ShopOrWorkshop = 48,
    GuestBedroom = 49,
    GuestBath = 50,
    PowderRoom = 51,
    BackYard = 52,
    FrontYard = 53,
    Patio = 54,
    Driveway = 55,
    SunRoom = 56,
    LivingRoom2 = 57,
    Spa = 58,
    Whirlpool = 59,
    Shed = 60,
    EquipmentStorage = 61,
    HobbyOrCraftRoom = 62,
    Fountain = 63,
    Pond = 64,
    ReceptionRoom = 65,
    BreakfastRoom = 66,
    Nook = 67,
    Garden = 68,
    Balcony = 69,
    PanicRoom = 70,
    Terrace = 71,
    Roof = 72,
    Toilet = 73,
    ToiletMain = 74,
    OutsideToilet = 75,
    ShowerRoom = 76,
    Study = 77,
    FrontGarden = 78,
    BackGarden = 79,
    Kettle = 80,
    Television = 81,
    Stove = 82,
    Microwave = 83,
    Toaster = 84,
    Vacuum = 85,
    Appliance = 86,
    FrontDoor = 87,
    BackDoor = 88,
    FridgeDoor = 89,
    MedicationCabinetDoor = 96,
    WardrobeDoor = 97,
    FrontCupboardDoor = 98,
    OtherDoor = 99,
    WaitingRoom = 100,
    TriageRoom = 101,
    DoctorsOffice = 102,
    PatientsPrivateRoom = 103,
    ConsultationRoom = 104,
    NurseStation = 105,
    Ward = 106,
    Corridor = 107,
    OperatingTheatre = 108,
    DentalSurgeryRoom = 109,
    MedicalImagingRoom = 110,
    DecontaminationRoom = 111,
    Atrium = 112,
    Mirror = 113,
    UnknownEnvironment = 255
}
/**
 * @cluster Basic
 * @type map8
 */
export declare enum AlarmMask {
    GeneralHardwareFault = 1,
    GeneralSoftwareFault = 2
}
/**
 * @cluster Basic
 */
export declare enum AlarmShiftRight {
    GeneralSoftwareFault = 1
}
/**
 * @cluster Basic
 * @type map8
 */
export declare enum DisableLocalConfigMask {
    DisableResetToFactoryDefaults = 1,
    DisableDeviceConfiguration = 2
}
/**
 * @cluster Basic
 */
export declare enum DisableLocalConfigShiftRight {
    DisableDeviceConfiguration = 1
}
/**
 * @cluster PowerConfiguration
 * @type enum8
 */
export declare enum BatterySize {
    NoBattery = 0,
    BuiltIn = 1,
    Other = 2,
    Aa = 3,
    Aaa = 4,
    C = 5,
    D = 6,
    Cr2 = 7,
    Cr123a = 8,
    Unknown = 255
}
/**
 * @cluster PowerConfiguration
 * @type map8
 */
export declare enum BatteryAlarmMask {
    BatteryVoltageTooLow = 1,
    BatteryAlarm1 = 2,
    BatteryAlarm2 = 4,
    BatteryAlarm3 = 8
}
/**
 * @cluster PowerConfiguration
 */
export declare enum BatteryAlarmShiftRight {
    BatteryAlarm1 = 1,
    BatteryAlarm2 = 2,
    BatteryAlarm3 = 3
}
/**
 * @cluster PowerConfiguration
 * @type map32
 */
export declare enum BatteryAlarmStateMask {
    Battery1minThreshold = 1,
    Battery1threshold1 = 2,
    Battery1threshold2 = 4,
    Battery1threshold3 = 8,
    Battery2minThreshold = 1024,
    Battery2threshold1 = 2048,
    Battery2threshold2 = 4096,
    Battery2threshold3 = 8192,
    Battery3minThreshold = 1048576,
    Battery3threshold1 = 2097152,
    Battery3threshold2 = 4194304,
    Battery3threshold3 = 8388608,
    MainsPowerSupplyLost = 1073741824
}
/**
 * @cluster PowerConfiguration
 */
export declare enum BatteryAlarmStateShiftRight {
    Battery1threshold1 = 1,
    Battery1threshold2 = 2,
    Battery1threshold3 = 3,
    Battery2minThreshold = 16,
    Battery2threshold1 = 17,
    Battery2threshold2 = 18,
    Battery2threshold3 = 19,
    Battery3minThreshold = 32,
    Battery3threshold1 = 33,
    Battery3threshold2 = 34,
    Battery3threshold3 = 35,
    MainsPowerSupplyLost = 48
}
/**
 * @cluster PowerConfiguration
 * @type map8
 */
export declare enum MainsAlarmMask {
    MainsVoltageTooLow = 1,
    MainsVoltageTooHigh = 2,
    MainsPowerSupplyLost = 4
}
/**
 * @cluster PowerConfiguration
 */
export declare enum MainsAlarmShiftRight {
    MainsVoltageTooHigh = 1,
    MainsPowerSupplyLost = 2
}
/**
 * @cluster DeviceTemperatureConfiguration
 * @type map8
 */
export declare enum DeviceTempAlarmMask {
    DeviceTemperatureTooLow = 1,
    DeviceTemperatureTooHigh = 2
}
/**
 * @cluster DeviceTemperatureConfiguration
 */
export declare enum DeviceTempAlarmShiftRight {
    DeviceTemperatureTooHigh = 1
}
/**
 * @cluster Identify
 * @type uint8
 */
export declare enum EffectIdentifier {
    Blink = 0,
    Breathe = 1,
    Okay = 2,
    ChannelChange = 11,
    FinishEffect = 254,
    StopEffect = 255
}
/**
 * @cluster Identify
 * @type uint8
 */
export declare enum EffectVariant {
    Default = 0
}
/**
 * @cluster Groups
 * @type map8
 */
export declare enum NameSupportMask {
    Supported = 128
}
/**
 * @cluster Groups
 */
export declare enum NameSupportShiftRight {
    Supported = 7
}
/**
 * @cluster Scenes
 */
export interface SExtensionFieldSetList {
    clusterId: number;
    extensionFieldSet: string;
}
/**
 * @cluster Scenes
 * @type uint8
 */
export declare enum ModeMask {
    CopyAllScenes = 1
}
/**
 * @cluster OnOff
 * @type enum8
 */
export declare enum StartUpOnOff {
    SetOnOffTo0 = 0,
    SetOnOffTo1 = 1,
    TogglePreviousOnOff = 2,
    SetPreviousOnOff = 255
}
/**
 * @cluster OnOff
 * @type uint8
 */
export declare enum OnOffControlMask {
    AcceptOnlyWhenOn = 1
}
/**
 * @cluster Level
 * @type map8
 */
export declare enum LevelOptionsMask {
    ExecuteIfOff = 1,
    CoupleColorTempToLevel = 2
}
/**
 * @cluster Level
 */
export declare enum LevelOptionsShiftRight {
    CoupleColorTempToLevel = 1
}
/**
 * @cluster Level
 * @type enum8
 */
export declare enum MoveStepMode {
    Up = 0,
    Down = 1
}
/**
 * @cluster Time
 * @type map8
 */
export declare enum TimeStatusMask {
    Master = 1,
    Synchronized = 2,
    MasterZoneDst = 4,
    Superseding = 8
}
/**
 * @cluster Time
 */
export declare enum TimeStatusShiftRight {
    Synchronized = 1,
    MasterZoneDst = 2,
    Superseding = 3
}
/**
 * @cluster IlluminanceMeasurement
 * @type enum8
 */
export declare enum LightSensorType {
    Photodiode = 0,
    Cmos = 1,
    Unknown = 255
}
/**
 * @cluster IlluminanceLevelSensing
 * @type enum8
 */
export declare enum LevelStatus {
    IlluminanceOnTarget = 0,
    IlluminanceBelowTarget = 1,
    IlluminanceAboveTarget = 2
}
/**
 * @cluster OccupancySensing
 * @type map8
 */
export declare enum OccupancyMask {
    SensedOccupancy = 1
}
/**
 * @cluster OccupancySensing
 * @type enum8
 */
export declare enum OccupancySensorType {
    Pir = 0,
    Ultrasonic = 1,
    PirandUltrasonic = 2,
    PhysicalContact = 3
}
/**
 * @cluster OccupancySensing
 * @type map8
 */
export declare enum OccupancySensorTypeBitmapMask {
    Pir = 1,
    Ultrasonic = 2,
    PhysicalContact = 4
}
/**
 * @cluster OccupancySensing
 */
export declare enum OccupancySensorTypeBitmapShiftRight {
    Ultrasonic = 1,
    PhysicalContact = 2
}
/**
 * @cluster ElectricalMeasurement
 * @type map32
 */
export declare enum MeasurementTypeMask {
    ActiveMeasurementAc = 1,
    ReactiveMeasurementAc = 2,
    ApparentMeasurementAc = 4,
    PhaseAmeasurement = 8,
    PhaseBmeasurement = 16,
    PhaseCmeasurement = 32,
    Dcmeasurement = 64,
    HarmonicsMeasurement = 128,
    PowerQualityMeasurement = 256
}
/**
 * @cluster ElectricalMeasurement
 */
export declare enum MeasurementTypeShiftRight {
    ReactiveMeasurementAc = 1,
    ApparentMeasurementAc = 2,
    PhaseAmeasurement = 3,
    PhaseBmeasurement = 4,
    PhaseCmeasurement = 5,
    Dcmeasurement = 6,
    HarmonicsMeasurement = 7,
    PowerQualityMeasurement = 8
}
/**
 * @cluster ElectricalMeasurement
 * @type map8
 */
export declare enum DCOverloadAlarmsMask {
    VoltageOverload = 1,
    CurrentOverload = 2
}
/**
 * @cluster ElectricalMeasurement
 */
export declare enum DCOverloadAlarmsShiftRight {
    CurrentOverload = 1
}
/**
 * @cluster ElectricalMeasurement
 * @type map16
 */
export declare enum ACAlarmsMask {
    VoltageOverload = 1,
    CurrentOverload = 2,
    ActivePowerOverload = 4,
    ReactivePowerOverload = 8,
    AverageRmsoverVoltage = 16,
    AverageRmsunderVoltage = 32,
    RmsextremeOverVoltage = 64,
    RmsextremeUnderVoltage = 128,
    RmsvoltageSag = 256,
    RmsvoltageSwell = 512
}
/**
 * @cluster ElectricalMeasurement
 */
export declare enum ACAlarmsShiftRight {
    CurrentOverload = 1,
    ActivePowerOverload = 2,
    ReactivePowerOverload = 3,
    AverageRmsoverVoltage = 4,
    AverageRmsunderVoltage = 5,
    RmsextremeOverVoltage = 6,
    RmsextremeUnderVoltage = 7,
    RmsvoltageSag = 8,
    RmsvoltageSwell = 9
}
/**
 * @cluster ElectricalMeasurement
 * @type enum8
 */
export declare enum Status {
    Success = 0,
    AttributeProfileNotSupported = 1,
    InvalidStartTime = 2,
    MoreIntervalsRequestedThanCanBeReturned = 3,
    NoIntervalsAvailableForTheRequestedTime = 4
}
/**
 * @cluster ColorControl
 * @type map8
 */
export declare enum CCColorOptionsMask {
    ExecuteIfOff = 1
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum ColorControlDirection {
    ShortestDistance = 0,
    LongestDistance = 1,
    Up = 2,
    Down = 3
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum ColorControlMoveMode {
    Stop = 0,
    Up = 1,
    Down = 3
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum ColorControlStepMode {
    Up = 1,
    Down = 3
}
/**
 * @cluster ColorControl
 * @type uint8
 */
export declare enum ColorControlColorLoopDirection {
    DecrementEnhancedCurrentHue = 0,
    IncrementEnhancedCurrentHue = 1
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum DriftCompensation {
    None = 0,
    OtherOrUnknown = 1,
    TemperatureMonitoring = 2,
    OpticalLuminanceMonitoringAndFeedback = 3,
    OpticalColorMonitoringAndFeedback = 4
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum ColorMode {
    CurrentHueAndCurrentSaturation = 0,
    CurrentXandCurrentY = 1,
    ColorTemperatureMireds = 2
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum EnhancedColorMode {
    CurrentHueAndCurrentSaturation = 0,
    CurrentXandCurrentY = 1,
    ColorTemperatureMireds = 2,
    EnhancedCurrentHueAndCurrentSaturation = 3
}
/**
 * @cluster ColorControl
 * @type uint8
 */
export declare enum ColorLoopActive {
    ColorLoopInactive = 0,
    ColorLoopActive = 1
}
/**
 * @cluster ColorControl
 * @type map16
 */
export declare enum ColorCapabilitiesMask {
    HueSaturationSupported = 1,
    EnhancedHueSupported = 2,
    ColorLoopSupported = 4,
    Xysupported = 8,
    ColorTemperatureSupported = 16
}
/**
 * @cluster ColorControl
 */
export declare enum ColorCapabilitiesShiftRight {
    EnhancedHueSupported = 1,
    ColorLoopSupported = 2,
    Xysupported = 3,
    ColorTemperatureSupported = 4
}
/**
 * @cluster ColorControl
 * @type map8
 */
export declare enum UpdateFlagsMask {
    UpdateAction = 1,
    UpdateDirection = 2,
    UpdateTime = 4,
    UpdateStartHue = 8
}
/**
 * @cluster ColorControl
 */
export declare enum UpdateFlagsShiftRight {
    UpdateDirection = 1,
    UpdateTime = 2,
    UpdateStartHue = 3
}
/**
 * @cluster ColorControl
 * @type enum8
 */
export declare enum Action {
    DeactivateColorLoop = 0,
    ActivateColorLoopFromColorLoopStartEnhancedHue = 1,
    ActivateColorLoopFromEnhancedCurrentHue = 2
}
/**
 * @cluster BallastConfiguration
 * @type map8
 */
export declare enum BallastStatusMask {
    BallastNonOperational = 1,
    LampFailure = 2
}
/**
 * @cluster BallastConfiguration
 */
export declare enum BallastStatusShiftRight {
    LampFailure = 1
}
/**
 * @cluster BallastConfiguration
 * @type map8
 */
export declare enum LampAlarmModeMask {
    LampBurnHours = 1
}
/**
 * @cluster PumpConfigurationAndControl
 * @type enum8
 */
export declare enum PumpOperationMode {
    Normal = 0,
    Minimum = 1,
    Maximum = 2,
    Local = 3
}
/**
 * @cluster PumpConfigurationAndControl
 * @type enum8
 */
export declare enum PumpControlMode {
    ConstantSpeed = 0,
    ConstantPressure = 1,
    ProportionalPressure = 2,
    ConstantFlow = 3,
    ConstantTemperature = 5,
    Automatic = 7
}
/**
 * @cluster PumpConfigurationAndControl
 * @type map16
 */
export declare enum PumpStatusMask {
    DeviceFault = 1,
    SupplyFault = 2,
    SpeedLow = 4,
    SpeedHigh = 8,
    LocalOverride = 16,
    Running = 32,
    RemotePressure = 64,
    RemoteFlow = 128,
    RemoteTemperature = 256
}
/**
 * @cluster PumpConfigurationAndControl
 */
export declare enum PumpStatusShiftRight {
    SupplyFault = 1,
    SpeedLow = 2,
    SpeedHigh = 3,
    LocalOverride = 4,
    Running = 5,
    RemotePressure = 6,
    RemoteFlow = 7,
    RemoteTemperature = 8
}
/**
 * @cluster Thermostat
 */
export interface TransitionType {
    transitionTime: number;
    heatSetPoint?: number;
    coolSetPoint?: number;
}
/**
 * @cluster Thermostat
 * @type map8
 */
export declare enum TstatScheduleDOWMask {
    Sunday = 1,
    Monday = 2,
    Tuesday = 4,
    Wednesday = 8,
    Thursday = 16,
    Friday = 32,
    Saturday = 64,
    AwayOrVacation = 128
}
/**
 * @cluster Thermostat
 */
export declare enum TstatScheduleDOWShiftRight {
    Monday = 1,
    Tuesday = 2,
    Wednesday = 3,
    Thursday = 4,
    Friday = 5,
    Saturday = 6,
    AwayOrVacation = 7
}
/**
 * @cluster Thermostat
 * @type map8
 */
export declare enum TstatScheduleModeMask {
    Heat = 1,
    Cool = 2
}
/**
 * @cluster Thermostat
 */
export declare enum TstatScheduleModeShiftRight {
    Cool = 1
}
/**
 * @cluster Thermostat
 * @type map8
 */
export declare enum HVACSystemTypeConfigurationMask {
    CoolingSystemStage = 3,
    HeatingSystemStage = 12,
    HeatingSystemType = 16,
    HeatingFuelSource = 32
}
/**
 * @cluster Thermostat
 */
export declare enum HVACSystemTypeConfigurationShiftRight {
    HeatingSystemStage = 2,
    HeatingSystemType = 4,
    HeatingFuelSource = 5
}
/**
 * @cluster Thermostat
 * @type map8
 */
export declare enum RemoteSensingMask {
    LocalTemperatureRemote = 1,
    OutdoorTemperatureRemote = 2,
    OccupancyRemote = 4
}
/**
 * @cluster Thermostat
 */
export declare enum RemoteSensingShiftRight {
    OutdoorTemperatureRemote = 1,
    OccupancyRemote = 2
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ControlSequenceOfOperation {
    CoolingOnly = 0,
    CoolingWithReheat = 1,
    HeatingOnly = 2,
    HeatingWithReheat = 3,
    CoolingAndHeating4pipes = 4,
    CoolingAndHeating4pipesWithReheat = 5
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum SystemMode {
    Off = 0,
    Auto = 1,
    Cool = 3,
    Heat = 4,
    EmergencyHeating = 5,
    Precooling = 6,
    FanOnly = 7,
    Dry = 8,
    Sleep = 9
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ThermostatRunningMode {
    Off = 0,
    Cool = 3,
    Heat = 4
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum StartOfWeek {
    Sunday = 0,
    Monday = 1,
    Tuesday = 2,
    Wednesday = 3,
    Thursday = 4,
    Friday = 5,
    Sunday2 = 6
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum TemperatureSetpointHold {
    SetpointHoldOff = 0,
    SetpointHoldOn = 1
}
/**
 * @cluster Thermostat
 * @type map8
 */
export declare enum ThermostatProgrammingOperationModeMask {
    ProgrammingMode = 1,
    AutoOrRecovery = 2,
    EconomyOrEnergyStar = 4
}
/**
 * @cluster Thermostat
 */
export declare enum ThermostatProgrammingOperationModeShiftRight {
    AutoOrRecovery = 1,
    EconomyOrEnergyStar = 2
}
/**
 * @cluster Thermostat
 * @type map16
 */
export declare enum ThermostatRunningStateMask {
    HeatOn = 1,
    CoolOn = 2,
    FanOn = 4,
    HeatSecondStageOn = 8,
    CoolSecondStageOn = 16,
    FanSecondStageOn = 32,
    FanThirdStageOn = 64
}
/**
 * @cluster Thermostat
 */
export declare enum ThermostatRunningStateShiftRight {
    CoolOn = 1,
    FanOn = 2,
    HeatSecondStageOn = 3,
    CoolSecondStageOn = 4,
    FanSecondStageOn = 5,
    FanThirdStageOn = 6
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum SetpointChangeSource {
    Manual = 0,
    ScheduleOrInternalProgramming = 1,
    External = 2
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ACType {
    CoolingAndFixedSpeed = 1,
    HeatPumpAndFixedSpeed = 2,
    CoolingAndInverter = 3,
    HeatPumpAndInverter = 4
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ACRefrigerantType {
    R22 = 1,
    R410a = 2,
    R407c = 3
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ACCompressorType {
    T1 = 1,
    T2 = 2,
    T3 = 3
}
/**
 * @cluster Thermostat
 * @type map32
 */
export declare enum ACErrorCodeMask {
    CompressorFailureOrRefrigerantLeakage = 1,
    RoomTemperatureSensorFailure = 2,
    OutdoorTemperatureSensorFailure = 4,
    IndoorCoilTemperatureSensorFailure = 8,
    FanFailure = 16
}
/**
 * @cluster Thermostat
 */
export declare enum ACErrorCodeShiftRight {
    RoomTemperatureSensorFailure = 1,
    OutdoorTemperatureSensorFailure = 2,
    IndoorCoilTemperatureSensorFailure = 3,
    FanFailure = 4
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ACLouverPosition {
    FullyClosed = 1,
    FullyOpen = 2,
    QuarterOpen = 3,
    HalfOpen = 4,
    ThreeQuartersOpen = 5
}
/**
 * @cluster Thermostat
 * @type enum8
 */
export declare enum ACCapacityFormat {
    Btuh = 0
}
/**
 * @cluster FanControl
 * @type enum8
 */
export declare enum FanMode {
    Off = 0,
    Low = 1,
    Medium = 2,
    High = 3,
    On = 4,
    Auto = 5,
    Smart = 6
}
/**
 * @cluster FanControl
 * @type enum8
 */
export declare enum FanModeSequence {
    LowMedHigh = 0,
    LowHigh = 1,
    LowMedHighAuto = 2,
    LowHighAuto = 3,
    OnAuto = 4
}
/**
 * @cluster DehumidificationControl
 * @type enum8
 */
export declare enum RelativeHumidityMode {
    MeasuredLocally = 0,
    UpdatedOverTheNetwork = 1
}
/**
 * @cluster DehumidificationControl
 * @type enum8
 */
export declare enum DehumidificationLockout {
    DehumidificationNotAllowed = 0,
    DehumidificationAllowed = 1
}
/**
 * @cluster DehumidificationControl
 * @type enum8
 */
export declare enum RelativeHumidityDisplay {
    NotDisplayed = 0,
    Displayed = 1
}
/**
 * @cluster ThermostatUserInterfaceConfiguration
 * @type enum8
 */
export declare enum TemperatureDisplayMode {
    Celsius = 0,
    Fahrenheit = 1
}
/**
 * @cluster ThermostatUserInterfaceConfiguration
 * @type enum8
 */
export declare enum KeypadLockout {
    None = 0,
    Level1 = 1,
    Level2 = 2,
    Level3 = 3,
    Level4 = 4,
    Level5 = 5
}
/**
 * @cluster ThermostatUserInterfaceConfiguration
 * @type enum8
 */
export declare enum ScheduleProgrammingVisibility {
    LocalEnabled = 0,
    LocalDisabled = 1
}
/**
 * @cluster ShadeConfiguration
 * @type enum8
 */
export declare enum SHDCFGDirection {
    Closing = 0,
    Opening = 1
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum DrlkUserStatus {
    Available = 0,
    OccupiedEnabled = 1,
    OccupiedDisabled = 3,
    NotSupported = 255
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum DrlkSettableUserStatus {
    OccupiedEnabled = 1,
    OccupiedDisabled = 3
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum DrlkUserType {
    UnrestrictedUser = 0,
    YearDayScheduleUser = 1,
    WeekDayScheduleUser = 2,
    MasterUser = 3,
    NonAccessUser = 4,
    NotSupported = 255
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum DrlkOperMode {
    Normal = 0,
    Vacation = 1,
    Privacy = 2,
    NoRflockOrUnlock = 3,
    Passage = 4
}
/**
 * @cluster DoorLock
 * @type map8
 */
export declare enum DrlkDaysMask {
    Sun = 1,
    Mon = 2,
    Tue = 4,
    Wed = 8,
    Thu = 16,
    Fri = 32,
    Sat = 64,
    Enable = 128
}
/**
 * @cluster DoorLock
 */
export declare enum DrlkDaysShiftRight {
    Mon = 1,
    Tue = 2,
    Wed = 3,
    Thu = 4,
    Fri = 5,
    Sat = 6,
    Enable = 7
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum DrlkPassFailStatus {
    Pass = 0,
    Fail = 1
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum DrlkSetCodeStatus {
    Success = 0,
    GeneralFailure = 1,
    MemoryFull = 2,
    DuplicateCode = 3
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum DrlkOperEventSource {
    Keypad = 0,
    Rf = 1,
    Manual = 2,
    Rfid = 3,
    Indeterminate = 255
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum LockState {
    NotFullyLocked = 0,
    Locked = 1,
    Unlocked = 2,
    Undefined = 255
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum LockType {
    DeadBolt = 0,
    Magnetic = 1,
    Other = 2,
    Mortise = 3,
    Rim = 4,
    LatchBolt = 5,
    CylindricalLock = 6,
    TubularLock = 7,
    InterconnectedLock = 8,
    DeadLatch = 9,
    DoorFurniture = 10
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum DoorState {
    Open = 0,
    Closed = 1,
    ErrorJammed = 2,
    ErrorForcedOpen = 3,
    ErrorUnspecified = 4,
    Undefined = 255
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum LEDSettings {
    NeverUseLed = 0,
    UseLedexceptForAccessAllowed = 1,
    UseLedforAllEvents = 2
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum SoundVolume {
    SilentMode = 0,
    LowVolume = 1,
    HighVolume = 2
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum SupportedOperatingModesMask {
    NormalModeSupported = 1,
    VacationModeSupported = 2,
    PrivacyModeSupported = 4,
    NoRflockOrUnlockModeSupported = 8,
    PassageModeSupported = 16
}
/**
 * @cluster DoorLock
 */
export declare enum SupportedOperatingModesShiftRight {
    VacationModeSupported = 1,
    PrivacyModeSupported = 2,
    NoRflockOrUnlockModeSupported = 3,
    PassageModeSupported = 4
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum DefaultConfigurationRegisterMask {
    DefaultEnableLocalProgrammingAttributeIsEnabled = 1,
    DefaultKeypadInterfaceIsEnabled = 2,
    DefaultRfinterfaceIsEnabled = 4,
    DefaultSoundVolumeIsEnabled = 32,
    DefaultAutoRelockTimeIsEnabled = 64,
    DefaultLedsettingsIsEnabled = 128
}
/**
 * @cluster DoorLock
 */
export declare enum DefaultConfigurationRegisterShiftRight {
    DefaultKeypadInterfaceIsEnabled = 1,
    DefaultRfinterfaceIsEnabled = 2,
    DefaultSoundVolumeIsEnabled = 5,
    DefaultAutoRelockTimeIsEnabled = 6,
    DefaultLedsettingsIsEnabled = 7
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum SecurityLevel {
    Network = 0,
    Aps = 1
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum KeypadOperationEventMask {
    KeypadOpUnknownOrMs = 1,
    KeypadOpLock = 2,
    KeypadOpUnlock = 4,
    KeypadOpLockErrorInvalidPin = 8,
    KeypadOpLockErrorInvalidSchedule = 16,
    KeypadOpUnlockInvalidPin = 32,
    KeypadOpUnlockInvalidSchedule = 64,
    KeypadOpNonAccessUser = 128
}
/**
 * @cluster DoorLock
 */
export declare enum KeypadOperationEventShiftRight {
    KeypadOpLock = 1,
    KeypadOpUnlock = 2,
    KeypadOpLockErrorInvalidPin = 3,
    KeypadOpLockErrorInvalidSchedule = 4,
    KeypadOpUnlockInvalidPin = 5,
    KeypadOpUnlockInvalidSchedule = 6,
    KeypadOpNonAccessUser = 7
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum RFOperationEventMask {
    RfopUnknownOrMs = 1,
    RfopLock = 2,
    RfopUnlock = 4,
    RfopLockErrorInvalidCode = 8,
    RfopLockErrorInvalidSchedule = 16,
    RfopUnlockInvalidCode = 32,
    RfopUnlockInvalidSchedule = 64
}
/**
 * @cluster DoorLock
 */
export declare enum RFOperationEventShiftRight {
    RfopLock = 1,
    RfopUnlock = 2,
    RfopLockErrorInvalidCode = 3,
    RfopLockErrorInvalidSchedule = 4,
    RfopUnlockInvalidCode = 5,
    RfopUnlockInvalidSchedule = 6
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum ManualOperationEventMask {
    ManualOpUnknownOrMs = 1,
    ManualOpThumbturnLock = 2,
    ManualOpThumbturnUnlock = 4,
    ManualOpOneTouchLock = 8,
    ManualOpKeyLock = 16,
    ManualOpKeyUnlock = 32,
    ManualOpAutoLock = 64,
    ManualOpScheduleLock = 128,
    ManualOpScheduleUnlock = 256,
    ManualOpLock = 512,
    ManualOpUnlock = 1024
}
/**
 * @cluster DoorLock
 */
export declare enum ManualOperationEventShiftRight {
    ManualOpThumbturnLock = 1,
    ManualOpThumbturnUnlock = 2,
    ManualOpOneTouchLock = 3,
    ManualOpKeyLock = 4,
    ManualOpKeyUnlock = 5,
    ManualOpAutoLock = 6,
    ManualOpScheduleLock = 7,
    ManualOpScheduleUnlock = 8,
    ManualOpLock = 9,
    ManualOpUnlock = 16
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum RFIDOperationEventMask {
    RfidopUnknownOrMs = 1,
    RfidopLock = 2,
    RfidopUnlock = 4,
    RfidopLockErrorInvalidRfid = 8,
    RfidopLockErrorInvalidSchedule = 16,
    RfidopUnlockErrorInvalidRfid = 32,
    RfidopUnlockErrorInvalidSchedule = 64
}
/**
 * @cluster DoorLock
 */
export declare enum RFIDOperationEventShiftRight {
    RfidopLock = 1,
    RfidopUnlock = 2,
    RfidopLockErrorInvalidRfid = 3,
    RfidopLockErrorInvalidSchedule = 4,
    RfidopUnlockErrorInvalidRfid = 5,
    RfidopUnlockErrorInvalidSchedule = 6
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum KeypadProgrammingEventMask {
    KeypadProgUnknownOrMs = 1,
    KeypadProgMasterCodeChanged = 2,
    KeypadProgPinadded = 4,
    KeypadProgPindeleted = 8,
    KeypadProgPinchanged = 16
}
/**
 * @cluster DoorLock
 */
export declare enum KeypadProgrammingEventShiftRight {
    KeypadProgMasterCodeChanged = 1,
    KeypadProgPinadded = 2,
    KeypadProgPindeleted = 3,
    KeypadProgPinchanged = 4
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum RFProgrammingEventMask {
    RfprogUnknownOrMs = 1,
    RfprogPinadded = 4,
    RfprogPindeleted = 8,
    RfprogPinchanged = 16,
    RfprogRfidadded = 32,
    RfprogRfiddeleted = 64
}
/**
 * @cluster DoorLock
 */
export declare enum RFProgrammingEventShiftRight {
    RfprogPinadded = 2,
    RfprogPindeleted = 3,
    RfprogPinchanged = 4,
    RfprogRfidadded = 5,
    RfprogRfiddeleted = 6
}
/**
 * @cluster DoorLock
 * @type map16
 */
export declare enum RFIDProgrammingEventMask {
    RfidprogUnknownOrMs = 1,
    RfidprogRfidadded = 32,
    RfidprogRfiddeleted = 64
}
/**
 * @cluster DoorLock
 */
export declare enum RFIDProgrammingEventShiftRight {
    RfidprogRfidadded = 5,
    RfidprogRfiddeleted = 6
}
/**
 * @cluster DoorLock
 * @type enum8
 */
export declare enum EventType {
    Operation = 0,
    Programming = 1,
    Alarm = 2
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum OperationEventCode {
    UnknownOrMs = 0,
    Lock = 1,
    Unlock = 2,
    LockFailureInvalidPinorId = 3,
    LockFailureInvalidSchedule = 4,
    UnlockFailureInvalidPinorId = 5,
    UnlockFailureInvalidSchedule = 6,
    OneTouchLock = 7,
    KeyLock = 8,
    KeyUnlock = 9,
    AutoLock = 10,
    ScheduleLock = 11,
    ScheduleUnlock = 12,
    ManualLock = 13,
    ManualUnlock = 14,
    NonAccessUserOperationalEvent = 14
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum ProgramEventSource {
    Keypad = 0,
    Rf = 1,
    Rfid = 3,
    Indeterminate = 255
}
/**
 * @cluster DoorLock
 * @type uint8
 */
export declare enum ProgramEventCode {
    UnknownOrMs = 0,
    MasterCodeChanged = 1,
    PincodeAdded = 2,
    PincodeDeleted = 3,
    PincodeChanged = 4,
    RfidcodeAdded = 5,
    RfidcodeDeleted = 6
}
/**
 * @cluster WindowCovering
 * @type enum8
 */
export declare enum WindowCoveringType {
    Rollershade = 0,
    Rollershade2motor = 1,
    RollershadeExterior = 2,
    RollershadeExterior2motor = 3,
    Drapery = 4,
    Awning = 5,
    Shutter = 6,
    TiltBlindTiltOnly = 7,
    TiltBlindLiftAndTilt = 8,
    ProjectorScreen = 9
}
/**
 * @cluster WindowCovering
 * @type map8
 */
export declare enum ConfigOrStatusMask {
    Operational = 1,
    Online = 2,
    OpenAndUpCommandsReversed = 4,
    LiftClosedLoop = 8,
    TiltClosedLoop = 16,
    LiftEncoderControlled = 32,
    TiltEncoderControlled = 64
}
/**
 * @cluster WindowCovering
 */
export declare enum ConfigOrStatusShiftRight {
    Online = 1,
    OpenAndUpCommandsReversed = 2,
    LiftClosedLoop = 3,
    TiltClosedLoop = 4,
    LiftEncoderControlled = 5,
    TiltEncoderControlled = 6
}
/**
 * @cluster BarrierControl
 * @type enum8
 */
export declare enum MovingState {
    Stopped = 0,
    Closing = 1,
    Opening = 2
}
/**
 * @cluster BarrierControl
 * @type map16
 */
export declare enum SafetyStatusMask {
    RemoteLockout = 1,
    TamperDetected = 2,
    FailedCommunication = 4,
    PositionFailure = 8
}
/**
 * @cluster BarrierControl
 */
export declare enum SafetyStatusShiftRight {
    TamperDetected = 1,
    FailedCommunication = 2,
    PositionFailure = 3
}
/**
 * @cluster BarrierControl
 * @type map8
 */
export declare enum CapabilitiesMask {
    PartialBarrier = 1
}
/**
 * @cluster IASZone
 * @type enum8
 */
export declare enum ZoneState {
    NotEnrolled = 0,
    Enrolled = 1
}
/**
 * @cluster IASZone
 * @type enum8
 */
export declare enum EnrollResponseCode {
    Success = 0,
    NotSupported = 1,
    NoEnrollPermit = 2,
    TooManyZones = 3
}
/**
 * @cluster IASACE
 * @type enum8
 */
export declare enum IasaceAudibleNotification {
    Mute = 0,
    DefaultSound = 1
}
/**
 * @cluster IASACE
 * @type enum8
 */
export declare enum IasaceAlarmStatus {
    NoAlarm = 0,
    Burgler = 1,
    Fire = 2,
    Emergency = 3,
    PolicePanic = 4,
    FirePanic = 5,
    EmergencyPanic = 6
}
/**
 * @cluster IASACE
 * @type enum8
 */
export declare enum IasacPanelStatus {
    PanelDisarmedReadyToArm = 0,
    ArmedStay = 1,
    ArmedNight = 2,
    ArmedAway = 3,
    ExitDelay = 4,
    EntryDelay = 5,
    NotReadyToArm = 6,
    InAlarm = 7,
    ArmingStay = 8,
    ArmingNight = 9,
    ArmingAway = 10
}
/**
 * @cluster IASACE
 */
export interface IasaceZoneStatusRecord {
    zoneID: number;
    zoneStatus: number;
}
/**
 * @cluster IASACE
 * @type enum8
 */
export declare enum ArmMode {
    Disarm = 0,
    ArmDayHomeZonesOnly = 1,
    ArmNightSleepZonesOnly = 2,
    ArmAllZones = 3
}
/**
 * @cluster IASACE
 * @type enum8
 */
export declare enum ArmNotification {
    AllZonesDisarmed = 0,
    OnlyDayHomeZonesArmed = 1,
    OnlyNightSleepZonesArmed = 2,
    AllZonesArmed = 3,
    InvalidArmDisarmCode = 4,
    NotReadyToArm = 5,
    AlreadyDisarmed = 6
}
/**
 * @cluster IASACE
 * @type uint8
 */
export declare enum ZoneIDBypassResult {
    ZoneBypassed = 0,
    ZoneNotBypassed = 1,
    NotAllowed = 2,
    InvalidZoneId = 3,
    UnknownZoneId = 4,
    InvalidArmDisarmCode = 5
}
/**
 * @cluster IASWD
 * @type enum8
 */
export declare enum IaswdLevel {
    LowLevel = 0,
    MediumLevel = 1,
    HighLevel = 2,
    VeryHighLevel = 3
}
/**
 * @cluster IASWD
 * @type map8
 */
export declare enum SirenConfigurationMask {
    SirenLevel = 3,
    Strobe = 12,
    WarningMode = 240
}
/**
 * @cluster IASWD
 */
export declare enum SirenConfigurationShiftRight {
    SirenLevel = 0,
    Strobe = 2,
    WarningMode = 4
}
/**
 * @cluster IASWD
 * @type map8
 */
export declare enum SquawkConfigurationMask {
    SquawkLevel = 3,
    SquawkStrobeActive = 8,
    SquawkMode = 240
}
/**
 * @cluster IASWD
 */
export declare enum SquawkConfigurationShiftRight {
    SquawkLevel = 0,
    SquawkStrobeActive = 3,
    SquawkMode = 4
}
/**
 * @cluster Commissioning
 * @type uint8
 */
export declare enum ProtocolVersion {
    Zigbee2006orLater = 2
}
/**
 * @cluster Commissioning
 * @type uint8
 */
export declare enum StackProfile {
    ZigbeeStackProfile = 1,
    ZigbeeProStackProfile = 2
}
/**
 * @cluster Commissioning
 * @type enum8
 */
export declare enum StartupControl {
    OnAnetwork = 0,
    FormNetwork = 1,
    RejoinNetwork = 2,
    JoinUsingMacassociation = 3
}
/**
 * @cluster Commissioning
 * @type enum8
 */
export declare enum NetworkKeyType {
    StandardKey = 1
}
/**
 * @cluster Commissioning
 * @type map8
 */
export declare enum OptionsMask {
    StartupMode = 7,
    Immediate = 8
}
/**
 * @cluster Commissioning
 */
export declare enum OptionsShiftRight {
    Immediate = 3
}
/**
 * @cluster TouchlinkCommissioning
 * @type uint8
 */
export declare enum TLKeyIndex {
    DevelopmentKey = 0,
    MasterKey = 4,
    CertificationKey = 15
}
/**
 * @cluster TouchlinkCommissioning
 * @type map8
 */
export declare enum TLZigbeeInformationMask {
    LogicalType = 3,
    RxOnWhenIdle = 4
}
/**
 * @cluster TouchlinkCommissioning
 */
export declare enum TLZigbeeInformationShiftRight {
    RxOnWhenIdle = 2
}
/**
 * @cluster TouchlinkCommissioning
 * @type map8
 */
export declare enum TLTouchlinkInformationMask {
    FactoryNew = 1,
    AddressAssignment = 2,
    LinkInitiator = 16,
    TouchlinkPriorityRequest = 32,
    ProfileInterop = 128
}
/**
 * @cluster TouchlinkCommissioning
 */
export declare enum TLTouchlinkInformationShiftRight {
    AddressAssignment = 1,
    LinkInitiator = 4,
    TouchlinkPriorityRequest = 5,
    ProfileInterop = 7
}
/**
 * @cluster TouchlinkCommissioning
 * @type uint8
 */
export declare enum TLVersionMask {
    ApplicationDeviceVersion = 15
}
/**
 * @cluster TouchlinkCommissioning
 */
export interface TLDeviceInformationRecord {
    iEEEAddress: string;
    endpointIdentifier: number;
    profileIndentifier: number;
    deviceIdentifier: number;
    version: number;
    groupIdentifierCount: number;
    sort: number;
}
/**
 * @cluster TouchlinkCommissioning
 * @type uint8
 */
export declare enum TLStatus {
    Success = 0,
    Failure = 1
}
/**
 * @cluster TouchlinkCommissioning
 */
export interface TLGroupInformationRecord {
    groupIdentifier: number;
    groupType: number;
}
/**
 * @cluster TouchlinkCommissioning
 */
export interface TLEndpointInformationRecord {
    networkAddress: number;
    endpointIdentifier: number;
    profileIdentifier: number;
    deviceIdentifier: number;
    version: number;
}
/**
 * @cluster TouchlinkCommissioning
 * @type map16
 */
export declare enum KeyBitmaskMask {
    DevelopmentKey = 1,
    MasterKey = 16,
    CertificationKey = 32768
}
/**
 * @cluster TouchlinkCommissioning
 */
export declare enum KeyBitmaskShiftRight {
    MasterKey = 4,
    CertificationKey = 21
}
/**
 * @cluster OTAUpgrade
 * @type uint16
 */
export declare enum OTADeviceSpecificImageType {
    ClientSecurityCredentials = 65472,
    ClientConfiguration = 65473,
    ServerLog = 65474,
    Picture = 65475
}
/**
 * @cluster OTAUpgrade
 * @type map8
 */
export declare enum FieldControlMask {
    HardwareVersionPresent = 1
}
/**
 * @cluster OTAUpgrade
 * @type enum8
 */
export declare enum ImageUpgradeStatus {
    Normal = 0,
    DownloadInProgress = 1,
    DownloadComplete = 2,
    WaitingToUpgrade = 3,
    CountDown = 4,
    WaitForMore = 5,
    WaitingToUpgradeViaExternalEvent = 6
}
/**
 * @cluster OTAUpgrade
 * @type enum8
 */
export declare enum UpgradeActivationPolicy {
    OtaserverActivationAllowed = 0,
    OutOfBandActivationOnly = 1
}
/**
 * @cluster OTAUpgrade
 * @type enum8
 */
export declare enum UpgradeTimeoutPolicy {
    ApplyUpgradeAfterTimeout = 0,
    DoNotApplyUpgradeAfterTimeout = 1
}
/**
 * @cluster OTAUpgrade
 * @type enum8
 */
export declare enum PayloadType {
    QueryJitter = 0,
    QueryJitterAndManufacturerCode = 1,
    QueryJitterManufacturerCodeAndImageType = 2,
    QueryJitterManufacturerCodeImageTypeAndNewFileVersion = 3
}
/** ZCL non-values by type name (key of `ZclType`). */
export declare const ZCL_TYPE_INVALID_BY_TYPE_NAME: Readonly<Record<string, number | bigint>>;
/** ZCL non-values by type ID (value of `ZclType`). */
export declare const ZCL_TYPE_INVALID_BY_TYPE: Readonly<Record<number, number | bigint>>;
//# sourceMappingURL=datatypes.d.ts.map